/*
 * Decompiled with CFR 0.152.
 */
package net.humblestar.gcalcdemo.calculus;

import java.awt.GridBagLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.gcalc.plugin.gui.TextInputPanel;

class NumericalIntegrationInputPanel
extends TextInputPanel {
    protected static final String[] methods = new String[]{"Left Riemann sum", "Right Riemann sum", "Midpoint Rule", "Trapezoidal Rule", "Simpson's Rule"};
    private JComboBox methodsJCB;
    public JTextField answerTF;

    protected NumericalIntegrationInputPanel() {
        super("Numerical Integration", new String[]{"f(x)=", "Lower Bound", "Upper Bound", "Subdivisions"}, new String[]{"", "-4", "4", "10"});
    }

    protected JPanel createInputSubPanel(int n, String[] labels, String[] values) {
        JPanel jp = super.createInputSubPanel(n, labels, values);
        GridBagLayout gb = (GridBagLayout)jp.getLayout();
        this.addLeftSide(jp, gb, new JLabel("Methods"));
        this.methodsJCB = new JComboBox<String>(methods);
        this.addRightSide(jp, gb, this.methodsJCB);
        this.addLeftSide(jp, gb, new JLabel("Approximation"));
        this.answerTF = new JTextField();
        this.addRightSide(jp, gb, this.answerTF);
        this.answerTF.setEditable(false);
        return jp;
    }

    public void setAnswer(double x) {
        this.answerTF.setText("" + (float)x);
    }

    public String[] getValues() {
        String[] ret = super.getValues();
        String[] out = new String[ret.length + 1];
        System.arraycopy(ret, 0, out, 0, ret.length);
        out[out.length - 1] = "" + this.methodsJCB.getSelectedIndex();
        return out;
    }
}

