/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.proto.plugin;

import javax.swing.table.DefaultTableModel;
import net.gcalc.calc.main.SymbolTable;
import net.gcalc.calc.main.SymbolTableException;
import net.gcalc.calc.main.ValueTable;
import net.gcalc.calc.math.CircularDefinitionException;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.math.functions.FunctionFactory;
import net.gcalc.calc.parser.BadSyntaxException;
import net.gcalc.calc.parser.VariableToken;
import net.gcalc.proto.plugin.BadCellInputException;
import net.gcalc.proto.plugin.Formula;

class SpreadsheetModel
extends DefaultTableModel {
    private SymbolTable st = new SymbolTable();
    private ValueTable vt = new ValueTable();

    public int getColumnCount() {
        return 5;
    }

    public int getRowCount() {
        return 100;
    }

    public String getColumnName(int col) {
        int c = 65 + col % 26;
        return new String(new char[]{(char)c});
    }

    public void setValueAt(Object val, int row, int col) {
        if (val instanceof String) {
            String str = ((String)val).trim();
            if (str.startsWith("=")) {
                str = str.substring(1);
            }
            try {
                if (str.length() != 0) {
                    Function f = FunctionFactory.getFunction(str);
                    val = new Formula(f, this.st, this.vt);
                    VariableToken tk = new VariableToken(String.valueOf(this.getColumnName(col)) + (row + 1));
                    this.st.setVariable(tk, f);
                }
            }
            catch (BadSyntaxException e) {
                System.out.println(e);
                val = "\"" + str + "\"";
            }
            catch (CircularDefinitionException e) {
                System.out.println(e);
                throw new BadCellInputException();
            }
            catch (SymbolTableException e) {
                System.out.println(e);
                throw new BadCellInputException();
            }
        }
        super.setValueAt(val, row, col);
    }
}

