/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin.plane.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import net.gcalc.plugin.plane.graph.CartesianGraph;
import net.gcalc.plugin.properties.GraphProperties;
import net.gcalc.plugin.properties.Range;
import net.gcalc.plugin.properties.View;
import net.gcalc.plugin.properties.Zoom;

class ZoomIOPanel
extends JPanel
implements ActionListener {
    private JComboBox factor;
    private JButton in;
    private JButton out;
    private GraphProperties properties;

    public ZoomIOPanel(GraphProperties gp) {
        super(new BorderLayout(5, 5));
        this.properties = gp;
        this.in = new JButton("Zoom in");
        this.out = new JButton("Zoom out");
        this.factor = new JComboBox<String>(new String[]{"1000000:1", "1000:1", "100:1", "10:1", "5:1", "3:1", "2:1", "4:3", "3:2"});
        this.factor.setSelectedIndex(6);
        JPanel buttons = new JPanel(new GridLayout(1, 2));
        buttons.add(this.in);
        buttons.add(this.out);
        this.in.addActionListener(this);
        this.out.addActionListener(this);
        this.add((Component)this.factor, "Center");
        this.add((Component)buttons, "South");
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        int[] a = this.getFactor();
        if (src == this.out) {
            this.zoom(a[1], a[0]);
        } else if (src == this.in) {
            this.zoom(a[0], a[1]);
        }
    }

    private int[] getFactor() {
        String item = (String)this.factor.getSelectedItem();
        StringTokenizer st = new StringTokenizer(item, ":");
        int[] a = new int[]{Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken())};
        return a;
    }

    private void zoom(int s, int d) {
        CartesianGraph graph = (CartesianGraph)this.properties.get(GraphProperties.GRAPH_CANVAS);
        ZoomIO zio = new ZoomIO(s, d);
        this.properties.put(GraphProperties.VIEW, graph.zoomWrapper(zio).getView());
    }

    public class ZoomIO
    extends Zoom {
        private int s;
        private int d;

        public ZoomIO(int a, int b) {
            this.s = a;
            this.d = b;
        }

        public View getView() {
            View view = ZoomIOPanel.this.properties.getViewProperty(GraphProperties.VIEW);
            Range x = view.getRange(0);
            Range y = view.getRange(1);
            double r = x.getWidth() * (double)this.d / (double)this.s / 2.0;
            Range x2 = new Range(x.getCenter() - r, x.getCenter() + r, x.getScale());
            r = y.getWidth() * (double)this.d / (double)this.s / 2.0;
            Range y2 = new Range(y.getCenter() - r, y.getCenter() + r, y.getScale());
            return new View(x2, y2);
        }
    }
}

