// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vmwareengine/v1/vmwareengine.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VMWAREENGINE_V1_VMWARE_ENGINE_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VMWAREENGINE_V1_VMWARE_ENGINE_CLIENT_H

#include "google/cloud/vmwareengine/v1/vmware_engine_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace vmwareengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// VMwareEngine manages VMware's private clusters in the Cloud.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class VmwareEngineClient {
 public:
  explicit VmwareEngineClient(
      std::shared_ptr<VmwareEngineConnection> connection, Options opts = {});
  ~VmwareEngineClient();

  ///@{
  /// @name Copy and move support
  VmwareEngineClient(VmwareEngineClient const&) = default;
  VmwareEngineClient& operator=(VmwareEngineClient const&) = default;
  VmwareEngineClient(VmwareEngineClient&&) = default;
  VmwareEngineClient& operator=(VmwareEngineClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(VmwareEngineClient const& a,
                         VmwareEngineClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(VmwareEngineClient const& a,
                         VmwareEngineClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists `PrivateCloud` resources in a given project and location.
  ///
  /// @param parent  Required. The resource name of the private cloud to be queried for
  ///  clusters. Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.PrivateCloud], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListPrivateCloudsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L570}
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L82}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::PrivateCloud> ListPrivateClouds(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists `PrivateCloud` resources in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ListPrivateCloudsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.PrivateCloud], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListPrivateCloudsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L570}
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L82}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::PrivateCloud> ListPrivateClouds(
      google::cloud::vmwareengine::v1::ListPrivateCloudsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves a `PrivateCloud` resource by its resource name.
  ///
  /// @param name  Required. The resource name of the private cloud to retrieve.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.PrivateCloud])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetPrivateCloudRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L649}
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L82}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::PrivateCloud> GetPrivateCloud(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieves a `PrivateCloud` resource by its resource name.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.GetPrivateCloudRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.PrivateCloud])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetPrivateCloudRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L649}
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L82}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::PrivateCloud> GetPrivateCloud(
      google::cloud::vmwareengine::v1::GetPrivateCloudRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new `PrivateCloud` resource in a given project and location.
  /// Private clouds can only be created in zones, regional private clouds are
  /// not supported.
  ///
  /// Creating a private cloud also creates a [management
  /// cluster](https://cloud.google.com/vmware-engine/docs/concepts-vmware-components)
  /// for that private cloud.
  ///
  /// @param parent  Required. The resource name of the location to create the new
  ///  private cloud in. Resource names are schemeless URIs that follow the
  ///  conventions in https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a`
  /// @param private_cloud  Required. The initial description of the new private cloud.
  /// @param private_cloud_id  Required. The user-provided identifier of the private cloud to be created.
  ///  This identifier must be unique among each `PrivateCloud` within the parent
  ///  and becomes the final token in the name URI.
  ///  The identifier must meet the following requirements:
  ///  @n
  ///  * Only contains 1-63 alphanumeric characters and hyphens
  ///  * Begins with an alphabetical character
  ///  * Ends with a non-hyphen character
  ///  * Not formatted as a UUID
  ///  * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
  ///  (section 3.5)
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateCloud] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.CreatePrivateCloudRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L665}
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L82}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
  CreatePrivateCloud(
      std::string const& parent,
      google::cloud::vmwareengine::v1::PrivateCloud const& private_cloud,
      std::string const& private_cloud_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new `PrivateCloud` resource in a given project and location.
  /// Private clouds can only be created in zones, regional private clouds are
  /// not supported.
  ///
  /// Creating a private cloud also creates a [management
  /// cluster](https://cloud.google.com/vmware-engine/docs/concepts-vmware-components)
  /// for that private cloud.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.CreatePrivateCloudRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateCloud] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.CreatePrivateCloudRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L665}
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L82}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
  CreatePrivateCloud(
      google::cloud::vmwareengine::v1::CreatePrivateCloudRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Modifies a `PrivateCloud` resource. Only the following fields can be
  /// updated: `description`.
  /// Only fields specified in `updateMask` are applied.
  ///
  /// During operation processing, the resource is temporarily in the `ACTIVE`
  /// state before the operation fully completes. For that period of time, you
  /// can't update the resource. Use the operation status to determine when the
  /// processing fully completes.
  ///
  /// @param private_cloud  Required. Private cloud description.
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  `PrivateCloud` resource by the update. The fields specified in `updateMask`
  ///  are relative to the resource, not the full request. A field will be
  ///  overwritten if it is in the mask. If the user does not provide a mask then
  ///  all fields will be overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateCloud] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L82}
  /// [google.cloud.vmwareengine.v1.UpdatePrivateCloudRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L705}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
  UpdatePrivateCloud(
      google::cloud::vmwareengine::v1::PrivateCloud const& private_cloud,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Modifies a `PrivateCloud` resource. Only the following fields can be
  /// updated: `description`.
  /// Only fields specified in `updateMask` are applied.
  ///
  /// During operation processing, the resource is temporarily in the `ACTIVE`
  /// state before the operation fully completes. For that period of time, you
  /// can't update the resource. Use the operation status to determine when the
  /// processing fully completes.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.UpdatePrivateCloudRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateCloud] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L82}
  /// [google.cloud.vmwareengine.v1.UpdatePrivateCloudRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L705}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
  UpdatePrivateCloud(
      google::cloud::vmwareengine::v1::UpdatePrivateCloudRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Schedules a `PrivateCloud` resource for deletion.
  ///
  /// A `PrivateCloud` resource scheduled for deletion has `PrivateCloud.state`
  /// set to `DELETED` and `expireTime` set to the time when deletion is final
  /// and can no longer be reversed. The delete operation is marked as done
  /// as soon as the `PrivateCloud` is successfully scheduled for deletion
  /// (this also applies when `delayHours` is set to zero), and the operation is
  /// not kept in pending state until `PrivateCloud` is purged.
  /// `PrivateCloud` can be restored using `UndeletePrivateCloud` method before
  /// the `expireTime` elapses. When `expireTime` is reached, deletion is final
  /// and all private cloud resources are irreversibly removed and billing stops.
  /// During the final removal process, `PrivateCloud.state` is set to `PURGING`.
  /// `PrivateCloud` can be polled using standard `GET` method for the whole
  /// period of deletion and purging. It will not be returned only
  /// when it is completely purged.
  ///
  /// @param name  Required. The resource name of the private cloud to delete.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateCloud] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DeletePrivateCloudRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L724}
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L82}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
  DeletePrivateCloud(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Schedules a `PrivateCloud` resource for deletion.
  ///
  /// A `PrivateCloud` resource scheduled for deletion has `PrivateCloud.state`
  /// set to `DELETED` and `expireTime` set to the time when deletion is final
  /// and can no longer be reversed. The delete operation is marked as done
  /// as soon as the `PrivateCloud` is successfully scheduled for deletion
  /// (this also applies when `delayHours` is set to zero), and the operation is
  /// not kept in pending state until `PrivateCloud` is purged.
  /// `PrivateCloud` can be restored using `UndeletePrivateCloud` method before
  /// the `expireTime` elapses. When `expireTime` is reached, deletion is final
  /// and all private cloud resources are irreversibly removed and billing stops.
  /// During the final removal process, `PrivateCloud.state` is set to `PURGING`.
  /// `PrivateCloud` can be polled using standard `GET` method for the whole
  /// period of deletion and purging. It will not be returned only
  /// when it is completely purged.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.DeletePrivateCloudRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateCloud] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DeletePrivateCloudRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L724}
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L82}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
  DeletePrivateCloud(
      google::cloud::vmwareengine::v1::DeletePrivateCloudRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Restores a private cloud that was previously scheduled for deletion by
  /// `DeletePrivateCloud`. A `PrivateCloud` resource scheduled for deletion has
  /// `PrivateCloud.state` set to `DELETED` and `PrivateCloud.expireTime` set to
  /// the time when deletion can no longer be reversed.
  ///
  /// @param name  Required. The resource name of the private cloud scheduled for deletion.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateCloud] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L82}
  /// [google.cloud.vmwareengine.v1.UndeletePrivateCloudRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L761}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
  UndeletePrivateCloud(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Restores a private cloud that was previously scheduled for deletion by
  /// `DeletePrivateCloud`. A `PrivateCloud` resource scheduled for deletion has
  /// `PrivateCloud.state` set to `DELETED` and `PrivateCloud.expireTime` set to
  /// the time when deletion can no longer be reversed.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.UndeletePrivateCloudRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateCloud] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L82}
  /// [google.cloud.vmwareengine.v1.UndeletePrivateCloudRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L761}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
  UndeletePrivateCloud(
      google::cloud::vmwareengine::v1::UndeletePrivateCloudRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists `Cluster` resources in a given private cloud.
  ///
  /// @param parent  Required. The resource name of the private cloud to query for clusters.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.Cluster], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.Cluster]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L206}
  /// [google.cloud.vmwareengine.v1.ListClustersRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L781}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::Cluster> ListClusters(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists `Cluster` resources in a given private cloud.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ListClustersRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.Cluster], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.Cluster]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L206}
  /// [google.cloud.vmwareengine.v1.ListClustersRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L781}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::Cluster> ListClusters(
      google::cloud::vmwareengine::v1::ListClustersRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves a `Cluster` resource by its resource name.
  ///
  /// @param name  Required. The cluster resource name to retrieve.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/clusters/my-cluster`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.Cluster])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.Cluster]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L206}
  /// [google.cloud.vmwareengine.v1.GetClusterRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L848}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::Cluster> GetCluster(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieves a `Cluster` resource by its resource name.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.GetClusterRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.Cluster])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.Cluster]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L206}
  /// [google.cloud.vmwareengine.v1.GetClusterRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L848}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::Cluster> GetCluster(
      google::cloud::vmwareengine::v1::GetClusterRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new cluster in a given private cloud.
  /// Creating a new cluster provides additional nodes for
  /// use in the parent private cloud and requires sufficient [node
  /// quota](https://cloud.google.com/vmware-engine/quotas).
  ///
  /// @param parent  Required. The resource name of the private cloud to create a new cluster
  ///  in. Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
  /// @param cluster  Required. The initial description of the new cluster.
  /// @param cluster_id  Required. The user-provided identifier of the new `Cluster`.
  ///  This identifier must be unique among clusters within the parent and becomes
  ///  the final token in the name URI.
  ///  The identifier must meet the following requirements:
  ///  @n
  ///  * Only contains 1-63 alphanumeric characters and hyphens
  ///  * Begins with an alphabetical character
  ///  * Ends with a non-hyphen character
  ///  * Not formatted as a UUID
  ///  * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
  ///  (section 3.5)
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.Cluster] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.Cluster]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L206}
  /// [google.cloud.vmwareengine.v1.CreateClusterRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L864}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::Cluster>> CreateCluster(
      std::string const& parent,
      google::cloud::vmwareengine::v1::Cluster const& cluster,
      std::string const& cluster_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new cluster in a given private cloud.
  /// Creating a new cluster provides additional nodes for
  /// use in the parent private cloud and requires sufficient [node
  /// quota](https://cloud.google.com/vmware-engine/quotas).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.CreateClusterRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.Cluster] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.Cluster]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L206}
  /// [google.cloud.vmwareengine.v1.CreateClusterRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L864}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::Cluster>> CreateCluster(
      google::cloud::vmwareengine::v1::CreateClusterRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Modifies a `Cluster` resource. Only the following fields can be updated:
  /// `node_type_configs.*.node_count`. Only fields specified in `updateMask` are
  /// applied.
  ///
  /// During operation processing, the resource is temporarily in the `ACTIVE`
  /// state before the operation fully completes. For that period of time, you
  /// can't update the resource. Use the operation status to determine when the
  /// processing fully completes.
  ///
  /// @param cluster  Required. The description of the cluster.
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  `Cluster` resource by the update. The fields specified in the `updateMask`
  ///  are relative to the resource, not the full request. A field will be
  ///  overwritten if it is in the mask. If the user does not provide a mask then
  ///  all fields will be overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.Cluster] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.Cluster]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L206}
  /// [google.cloud.vmwareengine.v1.UpdateClusterRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L904}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::Cluster>> UpdateCluster(
      google::cloud::vmwareengine::v1::Cluster const& cluster,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Modifies a `Cluster` resource. Only the following fields can be updated:
  /// `node_type_configs.*.node_count`. Only fields specified in `updateMask` are
  /// applied.
  ///
  /// During operation processing, the resource is temporarily in the `ACTIVE`
  /// state before the operation fully completes. For that period of time, you
  /// can't update the resource. Use the operation status to determine when the
  /// processing fully completes.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.UpdateClusterRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.Cluster] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.Cluster]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L206}
  /// [google.cloud.vmwareengine.v1.UpdateClusterRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L904}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::Cluster>> UpdateCluster(
      google::cloud::vmwareengine::v1::UpdateClusterRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a `Cluster` resource. To avoid unintended data loss, migrate or
  /// gracefully shut down any workloads running on the cluster before deletion.
  /// You cannot delete the management cluster of a private cloud using this
  /// method.
  ///
  /// @param name  Required. The resource name of the cluster to delete.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/clusters/my-cluster`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DeleteClusterRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L927}
  /// [google.cloud.vmwareengine.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1022}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeleteCluster(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a `Cluster` resource. To avoid unintended data loss, migrate or
  /// gracefully shut down any workloads running on the cluster before deletion.
  /// You cannot delete the management cluster of a private cloud using this
  /// method.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.DeleteClusterRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DeleteClusterRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L927}
  /// [google.cloud.vmwareengine.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1022}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeleteCluster(
      google::cloud::vmwareengine::v1::DeleteClusterRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists subnets in a given private cloud.
  ///
  /// @param parent  Required. The resource name of the private cloud to be queried for
  ///  subnets.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.Subnet], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListSubnetsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L947}
  /// [google.cloud.vmwareengine.v1.Subnet]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L269}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::Subnet> ListSubnets(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists subnets in a given private cloud.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ListSubnetsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.Subnet], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListSubnetsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L947}
  /// [google.cloud.vmwareengine.v1.Subnet]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L269}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::Subnet> ListSubnets(
      google::cloud::vmwareengine::v1::ListSubnetsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single subnet.
  ///
  /// @param name  Required. The resource name of the subnet to retrieve.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/subnets/my-subnet`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.Subnet])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetSubnetRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L992}
  /// [google.cloud.vmwareengine.v1.Subnet]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L269}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::Subnet> GetSubnet(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single subnet.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.GetSubnetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.Subnet])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetSubnetRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L992}
  /// [google.cloud.vmwareengine.v1.Subnet]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L269}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::Subnet> GetSubnet(
      google::cloud::vmwareengine::v1::GetSubnetRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single subnet. Only fields specified in
  /// `update_mask` are applied.
  ///
  /// *Note*: This API is synchronous and always returns a successful
  /// `google.longrunning.Operation` (LRO). The returned LRO will only have
  /// `done` and `response` fields.
  ///
  /// @param subnet  Required. Subnet description.
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  `Subnet` resource by the update.
  ///  The fields specified in the `update_mask` are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If the
  ///  user does not provide a mask then all fields will be overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.Subnet] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.Subnet]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L269}
  /// [google.cloud.vmwareengine.v1.UpdateSubnetRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1008}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::Subnet>> UpdateSubnet(
      google::cloud::vmwareengine::v1::Subnet const& subnet,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single subnet. Only fields specified in
  /// `update_mask` are applied.
  ///
  /// *Note*: This API is synchronous and always returns a successful
  /// `google.longrunning.Operation` (LRO). The returned LRO will only have
  /// `done` and `response` fields.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.UpdateSubnetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.Subnet] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.Subnet]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L269}
  /// [google.cloud.vmwareengine.v1.UpdateSubnetRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1008}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::Subnet>> UpdateSubnet(
      google::cloud::vmwareengine::v1::UpdateSubnetRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists node types
  ///
  /// @param parent  Required. The resource name of the location to be queried for node types.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.NodeType], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListNodeTypesRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1054}
  /// [google.cloud.vmwareengine.v1.NodeType]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L323}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::NodeType> ListNodeTypes(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists node types
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ListNodeTypesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.NodeType], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListNodeTypesRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1054}
  /// [google.cloud.vmwareengine.v1.NodeType]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L323}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::NodeType> ListNodeTypes(
      google::cloud::vmwareengine::v1::ListNodeTypesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single `NodeType`.
  ///
  /// @param name  Required. The resource name of the node type to retrieve.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-proj/locations/us-central1-a/nodeTypes/standard-72`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.NodeType])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetNodeTypeRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1125}
  /// [google.cloud.vmwareengine.v1.NodeType]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L323}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::NodeType> GetNodeType(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single `NodeType`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.GetNodeTypeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.NodeType])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetNodeTypeRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1125}
  /// [google.cloud.vmwareengine.v1.NodeType]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L323}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::NodeType> GetNodeType(
      google::cloud::vmwareengine::v1::GetNodeTypeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of credentials for NSX appliance.
  ///
  /// @param private_cloud  Required. The resource name of the private cloud
  ///  to be queried for credentials.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.Credentials])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.Credentials]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L362}
  /// [google.cloud.vmwareengine.v1.ShowNsxCredentialsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1141}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::Credentials> ShowNsxCredentials(
      std::string const& private_cloud, Options opts = {});

  // clang-format off
  ///
  /// Gets details of credentials for NSX appliance.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ShowNsxCredentialsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.Credentials])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.Credentials]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L362}
  /// [google.cloud.vmwareengine.v1.ShowNsxCredentialsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1141}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::Credentials> ShowNsxCredentials(
      google::cloud::vmwareengine::v1::ShowNsxCredentialsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of credentials for Vcenter appliance.
  ///
  /// @param private_cloud  Required. The resource name of the private cloud
  ///  to be queried for credentials.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.Credentials])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.Credentials]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L362}
  /// [google.cloud.vmwareengine.v1.ShowVcenterCredentialsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1158}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::Credentials> ShowVcenterCredentials(
      std::string const& private_cloud, Options opts = {});

  // clang-format off
  ///
  /// Gets details of credentials for Vcenter appliance.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ShowVcenterCredentialsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.Credentials])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.Credentials]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L362}
  /// [google.cloud.vmwareengine.v1.ShowVcenterCredentialsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1158}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::Credentials> ShowVcenterCredentials(
      google::cloud::vmwareengine::v1::ShowVcenterCredentialsRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Resets credentials of the NSX appliance.
  ///
  /// @param private_cloud  Required. The resource name of the private cloud
  ///  to reset credentials for.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateCloud] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L82}
  /// [google.cloud.vmwareengine.v1.ResetNsxCredentialsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1175}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
  ResetNsxCredentials(std::string const& private_cloud, Options opts = {});

  // clang-format off
  ///
  /// Resets credentials of the NSX appliance.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ResetNsxCredentialsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateCloud] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L82}
  /// [google.cloud.vmwareengine.v1.ResetNsxCredentialsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1175}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
  ResetNsxCredentials(
      google::cloud::vmwareengine::v1::ResetNsxCredentialsRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Resets credentials of the Vcenter appliance.
  ///
  /// @param private_cloud  Required. The resource name of the private cloud
  ///  to reset credentials for.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateCloud] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L82}
  /// [google.cloud.vmwareengine.v1.ResetVcenterCredentialsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1208}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
  ResetVcenterCredentials(std::string const& private_cloud, Options opts = {});

  // clang-format off
  ///
  /// Resets credentials of the Vcenter appliance.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ResetVcenterCredentialsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateCloud] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.PrivateCloud]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L82}
  /// [google.cloud.vmwareengine.v1.ResetVcenterCredentialsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1208}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
  ResetVcenterCredentials(
      google::cloud::vmwareengine::v1::ResetVcenterCredentialsRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new HCX activation key in a given private cloud.
  ///
  /// @param parent  Required. The resource name of the private cloud to create the key for.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1/privateClouds/my-cloud`
  /// @param hcx_activation_key  Required. The initial description of a new HCX activation key. When
  ///  creating a new key, this field must be an empty object.
  /// @param hcx_activation_key_id  Required. The user-provided identifier of the `HcxActivationKey` to be
  ///  created. This identifier must be unique among `HcxActivationKey` resources
  ///  within the parent and becomes the final token in the name URI.
  ///  The identifier must meet the following requirements:
  ///  @n
  ///  * Only contains 1-63 alphanumeric characters and hyphens
  ///  * Begins with an alphabetical character
  ///  * Ends with a non-hyphen character
  ///  * Not formatted as a UUID
  ///  * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
  ///  (section 3.5)
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.HcxActivationKey] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.CreateHcxActivationKeyRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1302}
  /// [google.cloud.vmwareengine.v1.HcxActivationKey]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L378}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::HcxActivationKey>>
  CreateHcxActivationKey(
      std::string const& parent,
      google::cloud::vmwareengine::v1::HcxActivationKey const&
          hcx_activation_key,
      std::string const& hcx_activation_key_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new HCX activation key in a given private cloud.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.CreateHcxActivationKeyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.HcxActivationKey] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.CreateHcxActivationKeyRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1302}
  /// [google.cloud.vmwareengine.v1.HcxActivationKey]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L378}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::HcxActivationKey>>
  CreateHcxActivationKey(
      google::cloud::vmwareengine::v1::CreateHcxActivationKeyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists `HcxActivationKey` resources in a given private cloud.
  ///
  /// @param parent  Required. The resource name of the private cloud
  ///  to be queried for HCX activation keys.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1/privateClouds/my-cloud`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.HcxActivationKey], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.HcxActivationKey]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L378}
  /// [google.cloud.vmwareengine.v1.ListHcxActivationKeysRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1256}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::HcxActivationKey>
  ListHcxActivationKeys(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists `HcxActivationKey` resources in a given private cloud.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ListHcxActivationKeysRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.HcxActivationKey], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.HcxActivationKey]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L378}
  /// [google.cloud.vmwareengine.v1.ListHcxActivationKeysRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1256}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::HcxActivationKey>
  ListHcxActivationKeys(
      google::cloud::vmwareengine::v1::ListHcxActivationKeysRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves a `HcxActivationKey` resource by its resource name.
  ///
  /// @param name  Required. The resource name of the HCX activation key to retrieve.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1/privateClouds/my-cloud/hcxActivationKeys/my-key`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.HcxActivationKey])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetHcxActivationKeyRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1286}
  /// [google.cloud.vmwareengine.v1.HcxActivationKey]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L378}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::HcxActivationKey>
  GetHcxActivationKey(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieves a `HcxActivationKey` resource by its resource name.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.GetHcxActivationKeyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.HcxActivationKey])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetHcxActivationKeyRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1286}
  /// [google.cloud.vmwareengine.v1.HcxActivationKey]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L378}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::HcxActivationKey>
  GetHcxActivationKey(
      google::cloud::vmwareengine::v1::GetHcxActivationKeyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves a `NetworkPolicy` resource by its resource name.
  ///
  /// @param name  Required. The resource name of the network policy to retrieve.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1/networkPolicies/my-network-policy`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.NetworkPolicy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetNetworkPolicyRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1430}
  /// [google.cloud.vmwareengine.v1.NetworkPolicy]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L566}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy> GetNetworkPolicy(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieves a `NetworkPolicy` resource by its resource name.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.GetNetworkPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.NetworkPolicy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetNetworkPolicyRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1430}
  /// [google.cloud.vmwareengine.v1.NetworkPolicy]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L566}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy> GetNetworkPolicy(
      google::cloud::vmwareengine::v1::GetNetworkPolicyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists `NetworkPolicy` resources in a specified project and location.
  ///
  /// @param parent  Required. The resource name of the location (region) to query for
  ///  network policies. Resource names are schemeless URIs that follow the
  ///  conventions in https://cloud.google.com/apis/design/resource_names. For
  ///  example: `projects/my-project/locations/us-central1`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.NetworkPolicy], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListNetworkPoliciesRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1352}
  /// [google.cloud.vmwareengine.v1.NetworkPolicy]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L566}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::NetworkPolicy>
  ListNetworkPolicies(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists `NetworkPolicy` resources in a specified project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ListNetworkPoliciesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.NetworkPolicy], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListNetworkPoliciesRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1352}
  /// [google.cloud.vmwareengine.v1.NetworkPolicy]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L566}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::NetworkPolicy>
  ListNetworkPolicies(
      google::cloud::vmwareengine::v1::ListNetworkPoliciesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new network policy in a given VMware Engine network of a
  /// project and location (region). A new network policy cannot be created if
  /// another network policy already exists in the same scope.
  ///
  /// @param parent  Required. The resource name of the location (region)
  ///  to create the new network policy in.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///   `projects/my-project/locations/us-central1`
  /// @param network_policy  Required. The network policy configuration to use in the request.
  /// @param network_policy_id  Required. The user-provided identifier of the network policy to be created.
  ///  This identifier must be unique within parent
  ///  `projects/{my-project}/locations/{us-central1}/networkPolicies` and becomes
  ///  the final token in the name URI.
  ///  The identifier must meet the following requirements:
  ///  @n
  ///  * Only contains 1-63 alphanumeric characters and hyphens
  ///  * Begins with an alphabetical character
  ///  * Ends with a non-hyphen character
  ///  * Not formatted as a UUID
  ///  * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
  ///  (section 3.5)
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.NetworkPolicy] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.CreateNetworkPolicyRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1477}
  /// [google.cloud.vmwareengine.v1.NetworkPolicy]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L566}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>>
  CreateNetworkPolicy(
      std::string const& parent,
      google::cloud::vmwareengine::v1::NetworkPolicy const& network_policy,
      std::string const& network_policy_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new network policy in a given VMware Engine network of a
  /// project and location (region). A new network policy cannot be created if
  /// another network policy already exists in the same scope.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.CreateNetworkPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.NetworkPolicy] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.CreateNetworkPolicyRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1477}
  /// [google.cloud.vmwareengine.v1.NetworkPolicy]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L566}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>>
  CreateNetworkPolicy(
      google::cloud::vmwareengine::v1::CreateNetworkPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Modifies a `NetworkPolicy` resource. Only the following fields can be
  /// updated: `internet_access`, `external_ip`, `edge_services_cidr`.
  /// Only fields specified in `updateMask` are applied. When updating a network
  /// policy, the external IP network service can only be disabled if there are
  /// no external IP addresses present in the scope of the policy. Also, a
  /// `NetworkService` cannot be updated when `NetworkService.state` is set
  /// to `RECONCILING`.
  ///
  /// During operation processing, the resource is temporarily in the `ACTIVE`
  /// state before the operation fully completes. For that period of time, you
  /// can't update the resource. Use the operation status to determine when the
  /// processing fully completes.
  ///
  /// @param network_policy  Required. Network policy description.
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  `NetworkPolicy` resource by the update.
  ///  The fields specified in the `update_mask` are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If the
  ///  user does not provide a mask then all fields will be overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.NetworkPolicy] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.NetworkPolicy]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L566}
  /// [google.cloud.vmwareengine.v1.UpdateNetworkPolicyRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1446}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>>
  UpdateNetworkPolicy(
      google::cloud::vmwareengine::v1::NetworkPolicy const& network_policy,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Modifies a `NetworkPolicy` resource. Only the following fields can be
  /// updated: `internet_access`, `external_ip`, `edge_services_cidr`.
  /// Only fields specified in `updateMask` are applied. When updating a network
  /// policy, the external IP network service can only be disabled if there are
  /// no external IP addresses present in the scope of the policy. Also, a
  /// `NetworkService` cannot be updated when `NetworkService.state` is set
  /// to `RECONCILING`.
  ///
  /// During operation processing, the resource is temporarily in the `ACTIVE`
  /// state before the operation fully completes. For that period of time, you
  /// can't update the resource. Use the operation status to determine when the
  /// processing fully completes.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.UpdateNetworkPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.NetworkPolicy] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.NetworkPolicy]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L566}
  /// [google.cloud.vmwareengine.v1.UpdateNetworkPolicyRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1446}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>>
  UpdateNetworkPolicy(
      google::cloud::vmwareengine::v1::UpdateNetworkPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a `NetworkPolicy` resource. A network policy cannot be deleted
  /// when `NetworkService.state` is set to `RECONCILING` for either its external
  /// IP or internet access service.
  ///
  /// @param name  Required. The resource name of the network policy to delete.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1/networkPolicies/my-network-policy`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DeleteNetworkPolicyRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1527}
  /// [google.cloud.vmwareengine.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1022}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeleteNetworkPolicy(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a `NetworkPolicy` resource. A network policy cannot be deleted
  /// when `NetworkService.state` is set to `RECONCILING` for either its external
  /// IP or internet access service.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.DeleteNetworkPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DeleteNetworkPolicyRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1527}
  /// [google.cloud.vmwareengine.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1022}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeleteNetworkPolicy(
      google::cloud::vmwareengine::v1::DeleteNetworkPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new VMware Engine network that can be used by a private cloud.
  ///
  /// @param parent  Required. The resource name of the location to create the new VMware Engine
  ///  network in. A VMware Engine network of type
  ///  `LEGACY` is a regional resource, and a VMware
  ///  Engine network of type `STANDARD` is a global resource.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names. For example:
  ///  `projects/my-project/locations/global`
  /// @param vmware_engine_network  Required. The initial description of the new VMware Engine network.
  /// @param vmware_engine_network_id  Required. The user-provided identifier of the new VMware Engine network.
  ///  This identifier must be unique among VMware Engine network resources
  ///  within the parent and becomes the final token in the name URI. The
  ///  identifier must meet the following requirements:
  ///  @n
  ///  * For networks of type LEGACY, adheres to the format:
  ///  `{region-id}-default`. Replace `{region-id}` with the region where you want
  ///  to create the VMware Engine network. For example, "us-central1-default".
  ///  * Only contains 1-63 alphanumeric characters and hyphens
  ///  * Begins with an alphabetical character
  ///  * Ends with a non-hyphen character
  ///  * Not formatted as a UUID
  ///  * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
  ///  (section 3.5)
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.VmwareEngineNetwork] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.CreateVmwareEngineNetworkRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1559}
  /// [google.cloud.vmwareengine.v1.VmwareEngineNetwork]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L660}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>
  CreateVmwareEngineNetwork(
      std::string const& parent,
      google::cloud::vmwareengine::v1::VmwareEngineNetwork const&
          vmware_engine_network,
      std::string const& vmware_engine_network_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new VMware Engine network that can be used by a private cloud.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.CreateVmwareEngineNetworkRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.VmwareEngineNetwork] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.CreateVmwareEngineNetworkRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1559}
  /// [google.cloud.vmwareengine.v1.VmwareEngineNetwork]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L660}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>
  CreateVmwareEngineNetwork(
      google::cloud::vmwareengine::v1::CreateVmwareEngineNetworkRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Modifies a VMware Engine network resource. Only the following fields can be
  /// updated: `description`. Only fields specified in `updateMask` are
  /// applied.
  ///
  /// @param vmware_engine_network  Required. VMware Engine network description.
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  VMware Engine network resource by the update.
  ///  The fields specified in the `update_mask` are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If the
  ///  user does not provide a mask then all fields will be overwritten. Only the
  ///  following fields can be updated: `description`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.VmwareEngineNetwork] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.UpdateVmwareEngineNetworkRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1613}
  /// [google.cloud.vmwareengine.v1.VmwareEngineNetwork]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L660}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>
  UpdateVmwareEngineNetwork(
      google::cloud::vmwareengine::v1::VmwareEngineNetwork const&
          vmware_engine_network,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Modifies a VMware Engine network resource. Only the following fields can be
  /// updated: `description`. Only fields specified in `updateMask` are
  /// applied.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.UpdateVmwareEngineNetworkRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.VmwareEngineNetwork] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.UpdateVmwareEngineNetworkRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1613}
  /// [google.cloud.vmwareengine.v1.VmwareEngineNetwork]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L660}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>
  UpdateVmwareEngineNetwork(
      google::cloud::vmwareengine::v1::UpdateVmwareEngineNetworkRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a `VmwareEngineNetwork` resource. You can only delete a VMware
  /// Engine network after all resources that refer to it are deleted. For
  /// example, a private cloud, a network peering, and a network policy can all
  /// refer to the same VMware Engine network.
  ///
  /// @param name  Required. The resource name of the VMware Engine network to be deleted.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/global/vmwareEngineNetworks/my-network`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DeleteVmwareEngineNetworkRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1646}
  /// [google.cloud.vmwareengine.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1022}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeleteVmwareEngineNetwork(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a `VmwareEngineNetwork` resource. You can only delete a VMware
  /// Engine network after all resources that refer to it are deleted. For
  /// example, a private cloud, a network peering, and a network policy can all
  /// refer to the same VMware Engine network.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.DeleteVmwareEngineNetworkRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DeleteVmwareEngineNetworkRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1646}
  /// [google.cloud.vmwareengine.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1022}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeleteVmwareEngineNetwork(
      google::cloud::vmwareengine::v1::DeleteVmwareEngineNetworkRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves a `VmwareEngineNetwork` resource by its resource name. The
  /// resource contains details of the VMware Engine network, such as its VMware
  /// Engine network type, peered networks in a service project, and state
  /// (for example, `CREATING`, `ACTIVE`, `DELETING`).
  ///
  /// @param name  Required. The resource name of the VMware Engine network to retrieve.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/global/vmwareEngineNetworks/my-network`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.VmwareEngineNetwork])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetVmwareEngineNetworkRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1684}
  /// [google.cloud.vmwareengine.v1.VmwareEngineNetwork]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L660}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>
  GetVmwareEngineNetwork(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieves a `VmwareEngineNetwork` resource by its resource name. The
  /// resource contains details of the VMware Engine network, such as its VMware
  /// Engine network type, peered networks in a service project, and state
  /// (for example, `CREATING`, `ACTIVE`, `DELETING`).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.GetVmwareEngineNetworkRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.VmwareEngineNetwork])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetVmwareEngineNetworkRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1684}
  /// [google.cloud.vmwareengine.v1.VmwareEngineNetwork]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L660}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>
  GetVmwareEngineNetwork(
      google::cloud::vmwareengine::v1::GetVmwareEngineNetworkRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists `VmwareEngineNetwork` resources in a given project and location.
  ///
  /// @param parent  Required. The resource name of the location to query for
  ///  VMware Engine networks. Resource names are schemeless URIs that follow the
  ///  conventions in https://cloud.google.com/apis/design/resource_names. For
  ///  example: `projects/my-project/locations/global`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.VmwareEngineNetwork], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListVmwareEngineNetworksRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1700}
  /// [google.cloud.vmwareengine.v1.VmwareEngineNetwork]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L660}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::VmwareEngineNetwork>
  ListVmwareEngineNetworks(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists `VmwareEngineNetwork` resources in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ListVmwareEngineNetworksRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.VmwareEngineNetwork], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListVmwareEngineNetworksRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1700}
  /// [google.cloud.vmwareengine.v1.VmwareEngineNetwork]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L660}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::VmwareEngineNetwork>
  ListVmwareEngineNetworks(
      google::cloud::vmwareengine::v1::ListVmwareEngineNetworksRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new private connection that can be used for accessing private
  /// Clouds.
  ///
  /// @param parent  Required. The resource name of the location to create the new private
  ///  connection in. Private connection is a regional resource.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names. For example:
  ///  `projects/my-project/locations/us-central1`
  /// @param private_connection  Required. The initial description of the new private connection.
  /// @param private_connection_id  Required. The user-provided identifier of the new private connection.
  ///  This identifier must be unique among private connection resources
  ///  within the parent and becomes the final token in the name URI. The
  ///  identifier must meet the following requirements:
  ///  @n
  ///  * Only contains 1-63 alphanumeric characters and hyphens
  ///  * Begins with an alphabetical character
  ///  * Ends with a non-hyphen character
  ///  * Not formatted as a UUID
  ///  * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
  ///  (section 3.5)
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateConnection] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.CreatePrivateConnectionRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1776}
  /// [google.cloud.vmwareengine.v1.PrivateConnection]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L775}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>>
  CreatePrivateConnection(
      std::string const& parent,
      google::cloud::vmwareengine::v1::PrivateConnection const&
          private_connection,
      std::string const& private_connection_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new private connection that can be used for accessing private
  /// Clouds.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.CreatePrivateConnectionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateConnection] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.CreatePrivateConnectionRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1776}
  /// [google.cloud.vmwareengine.v1.PrivateConnection]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L775}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>>
  CreatePrivateConnection(
      google::cloud::vmwareengine::v1::CreatePrivateConnectionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves a `PrivateConnection` resource by its resource name. The resource
  /// contains details of the private connection, such as connected
  /// network, routing mode and state.
  ///
  /// @param name  Required. The resource name of the private connection to retrieve.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1/privateConnections/my-connection`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.PrivateConnection])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetPrivateConnectionRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1825}
  /// [google.cloud.vmwareengine.v1.PrivateConnection]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L775}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>
  GetPrivateConnection(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieves a `PrivateConnection` resource by its resource name. The resource
  /// contains details of the private connection, such as connected
  /// network, routing mode and state.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.GetPrivateConnectionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vmwareengine.v1.PrivateConnection])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.GetPrivateConnectionRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1825}
  /// [google.cloud.vmwareengine.v1.PrivateConnection]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L775}
  ///
  // clang-format on
  StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>
  GetPrivateConnection(
      google::cloud::vmwareengine::v1::GetPrivateConnectionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists `PrivateConnection` resources in a given project and location.
  ///
  /// @param parent  Required. The resource name of the location to query for
  ///  private connections. Resource names are schemeless URIs that follow the
  ///  conventions in https://cloud.google.com/apis/design/resource_names. For
  ///  example: `projects/my-project/locations/us-central1`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.PrivateConnection], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListPrivateConnectionsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1841}
  /// [google.cloud.vmwareengine.v1.PrivateConnection]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L775}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::PrivateConnection>
  ListPrivateConnections(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists `PrivateConnection` resources in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ListPrivateConnectionsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.PrivateConnection], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListPrivateConnectionsRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1841}
  /// [google.cloud.vmwareengine.v1.PrivateConnection]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L775}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::PrivateConnection>
  ListPrivateConnections(
      google::cloud::vmwareengine::v1::ListPrivateConnectionsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Modifies a `PrivateConnection` resource. Only `description` and
  /// `routing_mode` fields can be updated. Only fields specified in `updateMask`
  /// are applied.
  ///
  /// @param private_connection  Required. Private connection description.
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  `PrivateConnection` resource by the update.
  ///  The fields specified in the `update_mask` are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If the
  ///  user does not provide a mask then all fields will be overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateConnection] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.PrivateConnection]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L775}
  /// [google.cloud.vmwareengine.v1.UpdatePrivateConnectionRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1917}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>>
  UpdatePrivateConnection(
      google::cloud::vmwareengine::v1::PrivateConnection const&
          private_connection,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Modifies a `PrivateConnection` resource. Only `description` and
  /// `routing_mode` fields can be updated. Only fields specified in `updateMask`
  /// are applied.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.UpdatePrivateConnectionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.PrivateConnection] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.PrivateConnection]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L775}
  /// [google.cloud.vmwareengine.v1.UpdatePrivateConnectionRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1917}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>>
  UpdatePrivateConnection(
      google::cloud::vmwareengine::v1::UpdatePrivateConnectionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a `PrivateConnection` resource. When a private connection is
  /// deleted for a VMware Engine network, the connected network becomes
  /// inaccessible to that VMware Engine network.
  ///
  /// @param name  Required. The resource name of the private connection to be deleted.
  ///  Resource names are schemeless URIs that follow the conventions in
  ///  https://cloud.google.com/apis/design/resource_names.
  ///  For example:
  ///  `projects/my-project/locations/us-central1/privateConnections/my-connection`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DeletePrivateConnectionRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1949}
  /// [google.cloud.vmwareengine.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1022}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeletePrivateConnection(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a `PrivateConnection` resource. When a private connection is
  /// deleted for a VMware Engine network, the connected network becomes
  /// inaccessible to that VMware Engine network.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.DeletePrivateConnectionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vmwareengine.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.DeletePrivateConnectionRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1949}
  /// [google.cloud.vmwareengine.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1022}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
  DeletePrivateConnection(
      google::cloud::vmwareengine::v1::DeletePrivateConnectionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists the private connection routes exchanged over a peering connection.
  ///
  /// @param parent  Required. The resource name of the private connection to retrieve peering
  ///  routes from. Resource names are schemeless URIs that follow the conventions
  ///  in https://cloud.google.com/apis/design/resource_names. For example:
  ///  `projects/my-project/locations/us-west1/privateConnections/my-connection`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.PeeringRoute], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListPrivateConnectionPeeringRoutesRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1981}
  /// [google.cloud.vmwareengine.v1.PeeringRoute]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L502}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::PeeringRoute>
  ListPrivateConnectionPeeringRoutes(std::string const& parent,
                                     Options opts = {});

  // clang-format off
  ///
  /// Lists the private connection routes exchanged over a peering connection.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vmwareengine.v1.ListPrivateConnectionPeeringRoutesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vmwareengine.v1.PeeringRoute], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vmwareengine.v1.ListPrivateConnectionPeeringRoutesRequest]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine.proto#L1981}
  /// [google.cloud.vmwareengine.v1.PeeringRoute]: @googleapis_reference_link{google/cloud/vmwareengine/v1/vmwareengine_resources.proto#L502}
  ///
  // clang-format on
  StreamRange<google::cloud::vmwareengine::v1::PeeringRoute>
  ListPrivateConnectionPeeringRoutes(
      google::cloud::vmwareengine::v1::ListPrivateConnectionPeeringRoutesRequest
          request,
      Options opts = {});

 private:
  std::shared_ptr<VmwareEngineConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vmwareengine_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VMWAREENGINE_V1_VMWARE_ENGINE_CLIENT_H
