// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/video/livestream/v1/service.proto

#include "google/cloud/video/livestream/v1/livestream_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace video_livestream_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

LivestreamServiceClient::LivestreamServiceClient(
    std::shared_ptr<LivestreamServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
LivestreamServiceClient::~LivestreamServiceClient() = default;

future<StatusOr<google::cloud::video::livestream::v1::Channel>>
LivestreamServiceClient::CreateChannel(
    std::string const& parent,
    google::cloud::video::livestream::v1::Channel const& channel,
    std::string const& channel_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::video::livestream::v1::CreateChannelRequest request;
  request.set_parent(parent);
  *request.mutable_channel() = channel;
  request.set_channel_id(channel_id);
  return connection_->CreateChannel(request);
}

future<StatusOr<google::cloud::video::livestream::v1::Channel>>
LivestreamServiceClient::CreateChannel(
    google::cloud::video::livestream::v1::CreateChannelRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateChannel(request);
}

StreamRange<google::cloud::video::livestream::v1::Channel>
LivestreamServiceClient::ListChannels(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::video::livestream::v1::ListChannelsRequest request;
  request.set_parent(parent);
  return connection_->ListChannels(request);
}

StreamRange<google::cloud::video::livestream::v1::Channel>
LivestreamServiceClient::ListChannels(
    google::cloud::video::livestream::v1::ListChannelsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListChannels(std::move(request));
}

StatusOr<google::cloud::video::livestream::v1::Channel>
LivestreamServiceClient::GetChannel(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::video::livestream::v1::GetChannelRequest request;
  request.set_name(name);
  return connection_->GetChannel(request);
}

StatusOr<google::cloud::video::livestream::v1::Channel>
LivestreamServiceClient::GetChannel(
    google::cloud::video::livestream::v1::GetChannelRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetChannel(request);
}

future<StatusOr<google::cloud::video::livestream::v1::OperationMetadata>>
LivestreamServiceClient::DeleteChannel(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::video::livestream::v1::DeleteChannelRequest request;
  request.set_name(name);
  return connection_->DeleteChannel(request);
}

future<StatusOr<google::cloud::video::livestream::v1::OperationMetadata>>
LivestreamServiceClient::DeleteChannel(
    google::cloud::video::livestream::v1::DeleteChannelRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteChannel(request);
}

future<StatusOr<google::cloud::video::livestream::v1::Channel>>
LivestreamServiceClient::UpdateChannel(
    google::cloud::video::livestream::v1::Channel const& channel,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::video::livestream::v1::UpdateChannelRequest request;
  *request.mutable_channel() = channel;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateChannel(request);
}

future<StatusOr<google::cloud::video::livestream::v1::Channel>>
LivestreamServiceClient::UpdateChannel(
    google::cloud::video::livestream::v1::UpdateChannelRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateChannel(request);
}

future<StatusOr<google::cloud::video::livestream::v1::ChannelOperationResponse>>
LivestreamServiceClient::StartChannel(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::video::livestream::v1::StartChannelRequest request;
  request.set_name(name);
  return connection_->StartChannel(request);
}

future<StatusOr<google::cloud::video::livestream::v1::ChannelOperationResponse>>
LivestreamServiceClient::StartChannel(
    google::cloud::video::livestream::v1::StartChannelRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StartChannel(request);
}

future<StatusOr<google::cloud::video::livestream::v1::ChannelOperationResponse>>
LivestreamServiceClient::StopChannel(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::video::livestream::v1::StopChannelRequest request;
  request.set_name(name);
  return connection_->StopChannel(request);
}

future<StatusOr<google::cloud::video::livestream::v1::ChannelOperationResponse>>
LivestreamServiceClient::StopChannel(
    google::cloud::video::livestream::v1::StopChannelRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StopChannel(request);
}

future<StatusOr<google::cloud::video::livestream::v1::Input>>
LivestreamServiceClient::CreateInput(
    std::string const& parent,
    google::cloud::video::livestream::v1::Input const& input,
    std::string const& input_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::video::livestream::v1::CreateInputRequest request;
  request.set_parent(parent);
  *request.mutable_input() = input;
  request.set_input_id(input_id);
  return connection_->CreateInput(request);
}

future<StatusOr<google::cloud::video::livestream::v1::Input>>
LivestreamServiceClient::CreateInput(
    google::cloud::video::livestream::v1::CreateInputRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateInput(request);
}

StreamRange<google::cloud::video::livestream::v1::Input>
LivestreamServiceClient::ListInputs(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::video::livestream::v1::ListInputsRequest request;
  request.set_parent(parent);
  return connection_->ListInputs(request);
}

StreamRange<google::cloud::video::livestream::v1::Input>
LivestreamServiceClient::ListInputs(
    google::cloud::video::livestream::v1::ListInputsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListInputs(std::move(request));
}

StatusOr<google::cloud::video::livestream::v1::Input>
LivestreamServiceClient::GetInput(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::video::livestream::v1::GetInputRequest request;
  request.set_name(name);
  return connection_->GetInput(request);
}

StatusOr<google::cloud::video::livestream::v1::Input>
LivestreamServiceClient::GetInput(
    google::cloud::video::livestream::v1::GetInputRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetInput(request);
}

future<StatusOr<google::cloud::video::livestream::v1::OperationMetadata>>
LivestreamServiceClient::DeleteInput(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::video::livestream::v1::DeleteInputRequest request;
  request.set_name(name);
  return connection_->DeleteInput(request);
}

future<StatusOr<google::cloud::video::livestream::v1::OperationMetadata>>
LivestreamServiceClient::DeleteInput(
    google::cloud::video::livestream::v1::DeleteInputRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteInput(request);
}

future<StatusOr<google::cloud::video::livestream::v1::Input>>
LivestreamServiceClient::UpdateInput(
    google::cloud::video::livestream::v1::Input const& input,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::video::livestream::v1::UpdateInputRequest request;
  *request.mutable_input() = input;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateInput(request);
}

future<StatusOr<google::cloud::video::livestream::v1::Input>>
LivestreamServiceClient::UpdateInput(
    google::cloud::video::livestream::v1::UpdateInputRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateInput(request);
}

StatusOr<google::cloud::video::livestream::v1::Event>
LivestreamServiceClient::CreateEvent(
    std::string const& parent,
    google::cloud::video::livestream::v1::Event const& event,
    std::string const& event_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::video::livestream::v1::CreateEventRequest request;
  request.set_parent(parent);
  *request.mutable_event() = event;
  request.set_event_id(event_id);
  return connection_->CreateEvent(request);
}

StatusOr<google::cloud::video::livestream::v1::Event>
LivestreamServiceClient::CreateEvent(
    google::cloud::video::livestream::v1::CreateEventRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateEvent(request);
}

StreamRange<google::cloud::video::livestream::v1::Event>
LivestreamServiceClient::ListEvents(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::video::livestream::v1::ListEventsRequest request;
  request.set_parent(parent);
  return connection_->ListEvents(request);
}

StreamRange<google::cloud::video::livestream::v1::Event>
LivestreamServiceClient::ListEvents(
    google::cloud::video::livestream::v1::ListEventsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListEvents(std::move(request));
}

StatusOr<google::cloud::video::livestream::v1::Event>
LivestreamServiceClient::GetEvent(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::video::livestream::v1::GetEventRequest request;
  request.set_name(name);
  return connection_->GetEvent(request);
}

StatusOr<google::cloud::video::livestream::v1::Event>
LivestreamServiceClient::GetEvent(
    google::cloud::video::livestream::v1::GetEventRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetEvent(request);
}

Status LivestreamServiceClient::DeleteEvent(std::string const& name,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::video::livestream::v1::DeleteEventRequest request;
  request.set_name(name);
  return connection_->DeleteEvent(request);
}

Status LivestreamServiceClient::DeleteEvent(
    google::cloud::video::livestream::v1::DeleteEventRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteEvent(request);
}

future<StatusOr<google::cloud::video::livestream::v1::Asset>>
LivestreamServiceClient::CreateAsset(
    std::string const& parent,
    google::cloud::video::livestream::v1::Asset const& asset,
    std::string const& asset_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::video::livestream::v1::CreateAssetRequest request;
  request.set_parent(parent);
  *request.mutable_asset() = asset;
  request.set_asset_id(asset_id);
  return connection_->CreateAsset(request);
}

future<StatusOr<google::cloud::video::livestream::v1::Asset>>
LivestreamServiceClient::CreateAsset(
    google::cloud::video::livestream::v1::CreateAssetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateAsset(request);
}

future<StatusOr<google::cloud::video::livestream::v1::OperationMetadata>>
LivestreamServiceClient::DeleteAsset(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::video::livestream::v1::DeleteAssetRequest request;
  request.set_name(name);
  return connection_->DeleteAsset(request);
}

future<StatusOr<google::cloud::video::livestream::v1::OperationMetadata>>
LivestreamServiceClient::DeleteAsset(
    google::cloud::video::livestream::v1::DeleteAssetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteAsset(request);
}

StatusOr<google::cloud::video::livestream::v1::Asset>
LivestreamServiceClient::GetAsset(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::video::livestream::v1::GetAssetRequest request;
  request.set_name(name);
  return connection_->GetAsset(request);
}

StatusOr<google::cloud::video::livestream::v1::Asset>
LivestreamServiceClient::GetAsset(
    google::cloud::video::livestream::v1::GetAssetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetAsset(request);
}

StreamRange<google::cloud::video::livestream::v1::Asset>
LivestreamServiceClient::ListAssets(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::video::livestream::v1::ListAssetsRequest request;
  request.set_parent(parent);
  return connection_->ListAssets(request);
}

StreamRange<google::cloud::video::livestream::v1::Asset>
LivestreamServiceClient::ListAssets(
    google::cloud::video::livestream::v1::ListAssetsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListAssets(std::move(request));
}

StatusOr<google::cloud::video::livestream::v1::Pool>
LivestreamServiceClient::GetPool(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::video::livestream::v1::GetPoolRequest request;
  request.set_name(name);
  return connection_->GetPool(request);
}

StatusOr<google::cloud::video::livestream::v1::Pool>
LivestreamServiceClient::GetPool(
    google::cloud::video::livestream::v1::GetPoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetPool(request);
}

future<StatusOr<google::cloud::video::livestream::v1::Pool>>
LivestreamServiceClient::UpdatePool(
    google::cloud::video::livestream::v1::Pool const& pool,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::video::livestream::v1::UpdatePoolRequest request;
  *request.mutable_pool() = pool;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdatePool(request);
}

future<StatusOr<google::cloud::video::livestream::v1::Pool>>
LivestreamServiceClient::UpdatePool(
    google::cloud::video::livestream::v1::UpdatePoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdatePool(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace video_livestream_v1
}  // namespace cloud
}  // namespace google
