// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/resourcemanager/v3/tag_values.proto

#include "google/cloud/resourcemanager/v3/internal/tag_values_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace resourcemanager_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

TagValuesTracingConnection::TagValuesTracingConnection(
    std::shared_ptr<resourcemanager_v3::TagValuesConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::resourcemanager::v3::TagValue>
TagValuesTracingConnection::ListTagValues(
    google::cloud::resourcemanager::v3::ListTagValuesRequest request) {
  auto span = internal::MakeSpan(
      "resourcemanager_v3::TagValuesConnection::ListTagValues");
  internal::OTelScope scope(span);
  auto sr = child_->ListTagValues(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::resourcemanager::v3::TagValue>(std::move(span),
                                                    std::move(sr));
}

StatusOr<google::cloud::resourcemanager::v3::TagValue>
TagValuesTracingConnection::GetTagValue(
    google::cloud::resourcemanager::v3::GetTagValueRequest const& request) {
  auto span = internal::MakeSpan(
      "resourcemanager_v3::TagValuesConnection::GetTagValue");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetTagValue(request));
}

StatusOr<google::cloud::resourcemanager::v3::TagValue>
TagValuesTracingConnection::GetNamespacedTagValue(
    google::cloud::resourcemanager::v3::GetNamespacedTagValueRequest const&
        request) {
  auto span = internal::MakeSpan(
      "resourcemanager_v3::TagValuesConnection::GetNamespacedTagValue");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetNamespacedTagValue(request));
}

future<StatusOr<google::cloud::resourcemanager::v3::TagValue>>
TagValuesTracingConnection::CreateTagValue(
    google::cloud::resourcemanager::v3::CreateTagValueRequest const& request) {
  auto span = internal::MakeSpan(
      "resourcemanager_v3::TagValuesConnection::CreateTagValue");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateTagValue(request));
}

future<StatusOr<google::cloud::resourcemanager::v3::TagValue>>
TagValuesTracingConnection::UpdateTagValue(
    google::cloud::resourcemanager::v3::UpdateTagValueRequest const& request) {
  auto span = internal::MakeSpan(
      "resourcemanager_v3::TagValuesConnection::UpdateTagValue");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateTagValue(request));
}

future<StatusOr<google::cloud::resourcemanager::v3::TagValue>>
TagValuesTracingConnection::DeleteTagValue(
    google::cloud::resourcemanager::v3::DeleteTagValueRequest const& request) {
  auto span = internal::MakeSpan(
      "resourcemanager_v3::TagValuesConnection::DeleteTagValue");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteTagValue(request));
}

StatusOr<google::iam::v1::Policy> TagValuesTracingConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "resourcemanager_v3::TagValuesConnection::GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIamPolicy(request));
}

StatusOr<google::iam::v1::Policy> TagValuesTracingConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "resourcemanager_v3::TagValuesConnection::SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SetIamPolicy(request));
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
TagValuesTracingConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpan(
      "resourcemanager_v3::TagValuesConnection::TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->TestIamPermissions(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<resourcemanager_v3::TagValuesConnection>
MakeTagValuesTracingConnection(
    std::shared_ptr<resourcemanager_v3::TagValuesConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<TagValuesTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcemanager_v3_internal
}  // namespace cloud
}  // namespace google
