// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/pubsublite/v1/admin.proto

#include "google/cloud/pubsublite/admin_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace pubsublite {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AdminServiceClient::AdminServiceClient(
    std::shared_ptr<AdminServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
AdminServiceClient::~AdminServiceClient() = default;

StatusOr<google::cloud::pubsublite::v1::Topic> AdminServiceClient::CreateTopic(
    std::string const& parent,
    google::cloud::pubsublite::v1::Topic const& topic,
    std::string const& topic_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::pubsublite::v1::CreateTopicRequest request;
  request.set_parent(parent);
  *request.mutable_topic() = topic;
  request.set_topic_id(topic_id);
  return connection_->CreateTopic(request);
}

StatusOr<google::cloud::pubsublite::v1::Topic> AdminServiceClient::CreateTopic(
    google::cloud::pubsublite::v1::CreateTopicRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateTopic(request);
}

StatusOr<google::cloud::pubsublite::v1::Topic> AdminServiceClient::GetTopic(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::pubsublite::v1::GetTopicRequest request;
  request.set_name(name);
  return connection_->GetTopic(request);
}

StatusOr<google::cloud::pubsublite::v1::Topic> AdminServiceClient::GetTopic(
    google::cloud::pubsublite::v1::GetTopicRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetTopic(request);
}

StatusOr<google::cloud::pubsublite::v1::TopicPartitions>
AdminServiceClient::GetTopicPartitions(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::pubsublite::v1::GetTopicPartitionsRequest request;
  request.set_name(name);
  return connection_->GetTopicPartitions(request);
}

StatusOr<google::cloud::pubsublite::v1::TopicPartitions>
AdminServiceClient::GetTopicPartitions(
    google::cloud::pubsublite::v1::GetTopicPartitionsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetTopicPartitions(request);
}

StreamRange<google::cloud::pubsublite::v1::Topic>
AdminServiceClient::ListTopics(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::pubsublite::v1::ListTopicsRequest request;
  request.set_parent(parent);
  return connection_->ListTopics(request);
}

StreamRange<google::cloud::pubsublite::v1::Topic>
AdminServiceClient::ListTopics(
    google::cloud::pubsublite::v1::ListTopicsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListTopics(std::move(request));
}

StatusOr<google::cloud::pubsublite::v1::Topic> AdminServiceClient::UpdateTopic(
    google::cloud::pubsublite::v1::Topic const& topic,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::pubsublite::v1::UpdateTopicRequest request;
  *request.mutable_topic() = topic;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateTopic(request);
}

StatusOr<google::cloud::pubsublite::v1::Topic> AdminServiceClient::UpdateTopic(
    google::cloud::pubsublite::v1::UpdateTopicRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateTopic(request);
}

Status AdminServiceClient::DeleteTopic(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::pubsublite::v1::DeleteTopicRequest request;
  request.set_name(name);
  return connection_->DeleteTopic(request);
}

Status AdminServiceClient::DeleteTopic(
    google::cloud::pubsublite::v1::DeleteTopicRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTopic(request);
}

StreamRange<std::string> AdminServiceClient::ListTopicSubscriptions(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::pubsublite::v1::ListTopicSubscriptionsRequest request;
  request.set_name(name);
  return connection_->ListTopicSubscriptions(request);
}

StreamRange<std::string> AdminServiceClient::ListTopicSubscriptions(
    google::cloud::pubsublite::v1::ListTopicSubscriptionsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListTopicSubscriptions(std::move(request));
}

StatusOr<google::cloud::pubsublite::v1::Subscription>
AdminServiceClient::CreateSubscription(
    std::string const& parent,
    google::cloud::pubsublite::v1::Subscription const& subscription,
    std::string const& subscription_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::pubsublite::v1::CreateSubscriptionRequest request;
  request.set_parent(parent);
  *request.mutable_subscription() = subscription;
  request.set_subscription_id(subscription_id);
  return connection_->CreateSubscription(request);
}

StatusOr<google::cloud::pubsublite::v1::Subscription>
AdminServiceClient::CreateSubscription(
    google::cloud::pubsublite::v1::CreateSubscriptionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateSubscription(request);
}

StatusOr<google::cloud::pubsublite::v1::Subscription>
AdminServiceClient::GetSubscription(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::pubsublite::v1::GetSubscriptionRequest request;
  request.set_name(name);
  return connection_->GetSubscription(request);
}

StatusOr<google::cloud::pubsublite::v1::Subscription>
AdminServiceClient::GetSubscription(
    google::cloud::pubsublite::v1::GetSubscriptionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetSubscription(request);
}

StreamRange<google::cloud::pubsublite::v1::Subscription>
AdminServiceClient::ListSubscriptions(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::pubsublite::v1::ListSubscriptionsRequest request;
  request.set_parent(parent);
  return connection_->ListSubscriptions(request);
}

StreamRange<google::cloud::pubsublite::v1::Subscription>
AdminServiceClient::ListSubscriptions(
    google::cloud::pubsublite::v1::ListSubscriptionsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListSubscriptions(std::move(request));
}

StatusOr<google::cloud::pubsublite::v1::Subscription>
AdminServiceClient::UpdateSubscription(
    google::cloud::pubsublite::v1::Subscription const& subscription,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::pubsublite::v1::UpdateSubscriptionRequest request;
  *request.mutable_subscription() = subscription;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateSubscription(request);
}

StatusOr<google::cloud::pubsublite::v1::Subscription>
AdminServiceClient::UpdateSubscription(
    google::cloud::pubsublite::v1::UpdateSubscriptionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateSubscription(request);
}

Status AdminServiceClient::DeleteSubscription(std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::pubsublite::v1::DeleteSubscriptionRequest request;
  request.set_name(name);
  return connection_->DeleteSubscription(request);
}

Status AdminServiceClient::DeleteSubscription(
    google::cloud::pubsublite::v1::DeleteSubscriptionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteSubscription(request);
}

future<StatusOr<google::cloud::pubsublite::v1::SeekSubscriptionResponse>>
AdminServiceClient::SeekSubscription(
    google::cloud::pubsublite::v1::SeekSubscriptionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SeekSubscription(request);
}

StatusOr<google::cloud::pubsublite::v1::Reservation>
AdminServiceClient::CreateReservation(
    std::string const& parent,
    google::cloud::pubsublite::v1::Reservation const& reservation,
    std::string const& reservation_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::pubsublite::v1::CreateReservationRequest request;
  request.set_parent(parent);
  *request.mutable_reservation() = reservation;
  request.set_reservation_id(reservation_id);
  return connection_->CreateReservation(request);
}

StatusOr<google::cloud::pubsublite::v1::Reservation>
AdminServiceClient::CreateReservation(
    google::cloud::pubsublite::v1::CreateReservationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateReservation(request);
}

StatusOr<google::cloud::pubsublite::v1::Reservation>
AdminServiceClient::GetReservation(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::pubsublite::v1::GetReservationRequest request;
  request.set_name(name);
  return connection_->GetReservation(request);
}

StatusOr<google::cloud::pubsublite::v1::Reservation>
AdminServiceClient::GetReservation(
    google::cloud::pubsublite::v1::GetReservationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetReservation(request);
}

StreamRange<google::cloud::pubsublite::v1::Reservation>
AdminServiceClient::ListReservations(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::pubsublite::v1::ListReservationsRequest request;
  request.set_parent(parent);
  return connection_->ListReservations(request);
}

StreamRange<google::cloud::pubsublite::v1::Reservation>
AdminServiceClient::ListReservations(
    google::cloud::pubsublite::v1::ListReservationsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListReservations(std::move(request));
}

StatusOr<google::cloud::pubsublite::v1::Reservation>
AdminServiceClient::UpdateReservation(
    google::cloud::pubsublite::v1::Reservation const& reservation,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::pubsublite::v1::UpdateReservationRequest request;
  *request.mutable_reservation() = reservation;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateReservation(request);
}

StatusOr<google::cloud::pubsublite::v1::Reservation>
AdminServiceClient::UpdateReservation(
    google::cloud::pubsublite::v1::UpdateReservationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateReservation(request);
}

Status AdminServiceClient::DeleteReservation(std::string const& name,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::pubsublite::v1::DeleteReservationRequest request;
  request.set_name(name);
  return connection_->DeleteReservation(request);
}

Status AdminServiceClient::DeleteReservation(
    google::cloud::pubsublite::v1::DeleteReservationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteReservation(request);
}

StreamRange<std::string> AdminServiceClient::ListReservationTopics(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::pubsublite::v1::ListReservationTopicsRequest request;
  request.set_name(name);
  return connection_->ListReservationTopics(request);
}

StreamRange<std::string> AdminServiceClient::ListReservationTopics(
    google::cloud::pubsublite::v1::ListReservationTopicsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListReservationTopics(std::move(request));
}

future<StatusOr<google::cloud::pubsublite::v1::TopicPartitions>>
AdminServiceClient::AsyncGetTopicPartitions(std::string const& name,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::pubsublite::v1::GetTopicPartitionsRequest request;
  request.set_name(name);
  return connection_->AsyncGetTopicPartitions(request);
}

future<StatusOr<google::cloud::pubsublite::v1::TopicPartitions>>
AdminServiceClient::AsyncGetTopicPartitions(
    google::cloud::pubsublite::v1::GetTopicPartitionsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AsyncGetTopicPartitions(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace pubsublite
}  // namespace cloud
}  // namespace google
