// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/cloudprofiler/v2/profiler.proto

#include "google/cloud/profiler/v2/internal/profiler_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace profiler_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

ProfilerServiceTracingStub::ProfilerServiceTracingStub(
    std::shared_ptr<ProfilerServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::devtools::cloudprofiler::v2::Profile>
ProfilerServiceTracingStub::CreateProfile(
    grpc::ClientContext& context,
    google::devtools::cloudprofiler::v2::CreateProfileRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.devtools.cloudprofiler.v2.ProfilerService", "CreateProfile");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateProfile(context, request));
}

StatusOr<google::devtools::cloudprofiler::v2::Profile>
ProfilerServiceTracingStub::CreateOfflineProfile(
    grpc::ClientContext& context,
    google::devtools::cloudprofiler::v2::CreateOfflineProfileRequest const&
        request) {
  auto span =
      internal::MakeSpanGrpc("google.devtools.cloudprofiler.v2.ProfilerService",
                             "CreateOfflineProfile");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateOfflineProfile(context, request));
}

StatusOr<google::devtools::cloudprofiler::v2::Profile>
ProfilerServiceTracingStub::UpdateProfile(
    grpc::ClientContext& context,
    google::devtools::cloudprofiler::v2::UpdateProfileRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.devtools.cloudprofiler.v2.ProfilerService", "UpdateProfile");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateProfile(context, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<ProfilerServiceStub> MakeProfilerServiceTracingStub(
    std::shared_ptr<ProfilerServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<ProfilerServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace profiler_v2_internal
}  // namespace cloud
}  // namespace google
