// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/optimization/v1/fleet_routing.proto

#include "google/cloud/optimization/v1/fleet_routing_connection.h"
#include "google/cloud/optimization/v1/fleet_routing_options.h"
#include "google/cloud/optimization/v1/internal/fleet_routing_connection_impl.h"
#include "google/cloud/optimization/v1/internal/fleet_routing_option_defaults.h"
#include "google/cloud/optimization/v1/internal/fleet_routing_stub_factory.h"
#include "google/cloud/optimization/v1/internal/fleet_routing_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace optimization_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

FleetRoutingConnection::~FleetRoutingConnection() = default;

StatusOr<google::cloud::optimization::v1::OptimizeToursResponse>
FleetRoutingConnection::OptimizeTours(
    google::cloud::optimization::v1::OptimizeToursRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::optimization::v1::BatchOptimizeToursResponse>>
FleetRoutingConnection::BatchOptimizeTours(
    google::cloud::optimization::v1::BatchOptimizeToursRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::optimization::v1::BatchOptimizeToursResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<FleetRoutingConnection> MakeFleetRoutingConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 FleetRoutingPolicyOptionList>(options,
                                                               __func__);
  options =
      optimization_v1_internal::FleetRoutingDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = optimization_v1_internal::CreateDefaultFleetRoutingStub(
      background->cq(), options);
  return optimization_v1_internal::MakeFleetRoutingTracingConnection(
      std::make_shared<optimization_v1_internal::FleetRoutingConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace optimization_v1
}  // namespace cloud
}  // namespace google
