// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/language/v2/language_service.proto

#include "google/cloud/language/v2/language_connection.h"
#include "google/cloud/language/v2/internal/language_connection_impl.h"
#include "google/cloud/language/v2/internal/language_option_defaults.h"
#include "google/cloud/language/v2/internal/language_stub_factory.h"
#include "google/cloud/language/v2/internal/language_tracing_connection.h"
#include "google/cloud/language/v2/language_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace language_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

LanguageServiceConnection::~LanguageServiceConnection() = default;

StatusOr<google::cloud::language::v2::AnalyzeSentimentResponse>
LanguageServiceConnection::AnalyzeSentiment(
    google::cloud::language::v2::AnalyzeSentimentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::language::v2::AnalyzeEntitiesResponse>
LanguageServiceConnection::AnalyzeEntities(
    google::cloud::language::v2::AnalyzeEntitiesRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::language::v2::ClassifyTextResponse>
LanguageServiceConnection::ClassifyText(
    google::cloud::language::v2::ClassifyTextRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::language::v2::ModerateTextResponse>
LanguageServiceConnection::ModerateText(
    google::cloud::language::v2::ModerateTextRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::language::v2::AnnotateTextResponse>
LanguageServiceConnection::AnnotateText(
    google::cloud::language::v2::AnnotateTextRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<LanguageServiceConnection> MakeLanguageServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 LanguageServicePolicyOptionList>(options,
                                                                  __func__);
  options =
      language_v2_internal::LanguageServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = language_v2_internal::CreateDefaultLanguageServiceStub(
      background->cq(), options);
  return language_v2_internal::MakeLanguageServiceTracingConnection(
      std::make_shared<language_v2_internal::LanguageServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace language_v2
}  // namespace cloud
}  // namespace google
