// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/conversation.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_ES_CONVERSATIONS_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_ES_CONVERSATIONS_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/dialogflow/v2/conversation.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_es {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class ConversationsConnectionIdempotencyPolicy {
 public:
  virtual ~ConversationsConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<ConversationsConnectionIdempotencyPolicy> clone()
      const;

  virtual google::cloud::Idempotency CreateConversation(
      google::cloud::dialogflow::v2::CreateConversationRequest const& request);

  virtual google::cloud::Idempotency ListConversations(
      google::cloud::dialogflow::v2::ListConversationsRequest request);

  virtual google::cloud::Idempotency GetConversation(
      google::cloud::dialogflow::v2::GetConversationRequest const& request);

  virtual google::cloud::Idempotency CompleteConversation(
      google::cloud::dialogflow::v2::CompleteConversationRequest const&
          request);

  virtual google::cloud::Idempotency ListMessages(
      google::cloud::dialogflow::v2::ListMessagesRequest request);

  virtual google::cloud::Idempotency SuggestConversationSummary(
      google::cloud::dialogflow::v2::SuggestConversationSummaryRequest const&
          request);

  virtual google::cloud::Idempotency GenerateStatelessSummary(
      google::cloud::dialogflow::v2::GenerateStatelessSummaryRequest const&
          request);

  virtual google::cloud::Idempotency SearchKnowledge(
      google::cloud::dialogflow::v2::SearchKnowledgeRequest const& request);
};

std::unique_ptr<ConversationsConnectionIdempotencyPolicy>
MakeDefaultConversationsConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_ES_CONVERSATIONS_CONNECTION_IDEMPOTENCY_POLICY_H
