// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/transition_route_group.proto

#include "google/cloud/dialogflow_cx/internal/transition_route_groups_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/dialogflow/cx/v3/transition_route_group.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_cx_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TransitionRouteGroupsStub::~TransitionRouteGroupsStub() = default;

StatusOr<google::cloud::dialogflow::cx::v3::ListTransitionRouteGroupsResponse>
DefaultTransitionRouteGroupsStub::ListTransitionRouteGroups(
    grpc::ClientContext& context,
    google::cloud::dialogflow::cx::v3::ListTransitionRouteGroupsRequest const&
        request) {
  google::cloud::dialogflow::cx::v3::ListTransitionRouteGroupsResponse response;
  auto status =
      grpc_stub_->ListTransitionRouteGroups(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::dialogflow::cx::v3::TransitionRouteGroup>
DefaultTransitionRouteGroupsStub::GetTransitionRouteGroup(
    grpc::ClientContext& context,
    google::cloud::dialogflow::cx::v3::GetTransitionRouteGroupRequest const&
        request) {
  google::cloud::dialogflow::cx::v3::TransitionRouteGroup response;
  auto status =
      grpc_stub_->GetTransitionRouteGroup(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::dialogflow::cx::v3::TransitionRouteGroup>
DefaultTransitionRouteGroupsStub::CreateTransitionRouteGroup(
    grpc::ClientContext& context,
    google::cloud::dialogflow::cx::v3::CreateTransitionRouteGroupRequest const&
        request) {
  google::cloud::dialogflow::cx::v3::TransitionRouteGroup response;
  auto status =
      grpc_stub_->CreateTransitionRouteGroup(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::dialogflow::cx::v3::TransitionRouteGroup>
DefaultTransitionRouteGroupsStub::UpdateTransitionRouteGroup(
    grpc::ClientContext& context,
    google::cloud::dialogflow::cx::v3::UpdateTransitionRouteGroupRequest const&
        request) {
  google::cloud::dialogflow::cx::v3::TransitionRouteGroup response;
  auto status =
      grpc_stub_->UpdateTransitionRouteGroup(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultTransitionRouteGroupsStub::DeleteTransitionRouteGroup(
    grpc::ClientContext& context,
    google::cloud::dialogflow::cx::v3::DeleteTransitionRouteGroupRequest const&
        request) {
  google::protobuf::Empty response;
  auto status =
      grpc_stub_->DeleteTransitionRouteGroup(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx_internal
}  // namespace cloud
}  // namespace google
