// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/changelog.proto

#include "google/cloud/dialogflow_cx/changelogs_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_cx {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ChangelogsClient::ChangelogsClient(
    std::shared_ptr<ChangelogsConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
ChangelogsClient::~ChangelogsClient() = default;

StreamRange<google::cloud::dialogflow::cx::v3::Changelog>
ChangelogsClient::ListChangelogs(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::ListChangelogsRequest request;
  request.set_parent(parent);
  return connection_->ListChangelogs(request);
}

StreamRange<google::cloud::dialogflow::cx::v3::Changelog>
ChangelogsClient::ListChangelogs(
    google::cloud::dialogflow::cx::v3::ListChangelogsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListChangelogs(std::move(request));
}

StatusOr<google::cloud::dialogflow::cx::v3::Changelog>
ChangelogsClient::GetChangelog(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::GetChangelogRequest request;
  request.set_name(name);
  return connection_->GetChangelog(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Changelog>
ChangelogsClient::GetChangelog(
    google::cloud::dialogflow::cx::v3::GetChangelogRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetChangelog(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx
}  // namespace cloud
}  // namespace google
