// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataproc/v1/workflow_templates.proto

#include "google/cloud/dataproc/v1/workflow_template_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace dataproc_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

WorkflowTemplateServiceConnectionIdempotencyPolicy::
    ~WorkflowTemplateServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<WorkflowTemplateServiceConnectionIdempotencyPolicy>
WorkflowTemplateServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<WorkflowTemplateServiceConnectionIdempotencyPolicy>(
      *this);
}

Idempotency
WorkflowTemplateServiceConnectionIdempotencyPolicy::CreateWorkflowTemplate(
    google::cloud::dataproc::v1::CreateWorkflowTemplateRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
WorkflowTemplateServiceConnectionIdempotencyPolicy::GetWorkflowTemplate(
    google::cloud::dataproc::v1::GetWorkflowTemplateRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
WorkflowTemplateServiceConnectionIdempotencyPolicy::InstantiateWorkflowTemplate(
    google::cloud::dataproc::v1::InstantiateWorkflowTemplateRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency WorkflowTemplateServiceConnectionIdempotencyPolicy::
    InstantiateInlineWorkflowTemplate(
        google::cloud::dataproc::v1::
            InstantiateInlineWorkflowTemplateRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
WorkflowTemplateServiceConnectionIdempotencyPolicy::UpdateWorkflowTemplate(
    google::cloud::dataproc::v1::UpdateWorkflowTemplateRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
WorkflowTemplateServiceConnectionIdempotencyPolicy::ListWorkflowTemplates(
    google::cloud::dataproc::v1::ListWorkflowTemplatesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency
WorkflowTemplateServiceConnectionIdempotencyPolicy::DeleteWorkflowTemplate(
    google::cloud::dataproc::v1::DeleteWorkflowTemplateRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<WorkflowTemplateServiceConnectionIdempotencyPolicy>
MakeDefaultWorkflowTemplateServiceConnectionIdempotencyPolicy() {
  return std::make_unique<WorkflowTemplateServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataproc_v1
}  // namespace cloud
}  // namespace google
