// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataproc/v1/jobs.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPROC_V1_JOB_CONTROLLER_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPROC_V1_JOB_CONTROLLER_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/dataproc/v1/jobs.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace dataproc_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class JobControllerConnectionIdempotencyPolicy {
 public:
  virtual ~JobControllerConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<JobControllerConnectionIdempotencyPolicy> clone()
      const;

  virtual google::cloud::Idempotency SubmitJob(
      google::cloud::dataproc::v1::SubmitJobRequest const& request);

  virtual google::cloud::Idempotency SubmitJobAsOperation(
      google::cloud::dataproc::v1::SubmitJobRequest const& request);

  virtual google::cloud::Idempotency GetJob(
      google::cloud::dataproc::v1::GetJobRequest const& request);

  virtual google::cloud::Idempotency ListJobs(
      google::cloud::dataproc::v1::ListJobsRequest request);

  virtual google::cloud::Idempotency UpdateJob(
      google::cloud::dataproc::v1::UpdateJobRequest const& request);

  virtual google::cloud::Idempotency CancelJob(
      google::cloud::dataproc::v1::CancelJobRequest const& request);

  virtual google::cloud::Idempotency DeleteJob(
      google::cloud::dataproc::v1::DeleteJobRequest const& request);
};

std::unique_ptr<JobControllerConnectionIdempotencyPolicy>
MakeDefaultJobControllerConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataproc_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPROC_V1_JOB_CONTROLLER_CONNECTION_IDEMPOTENCY_POLICY_H
