// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/region_instance_templates/v1/region_instance_templates.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_REGION_INSTANCE_TEMPLATES_V1_INTERNAL_REGION_INSTANCE_TEMPLATES_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_REGION_INSTANCE_TEMPLATES_V1_INTERNAL_REGION_INSTANCE_TEMPLATES_TRACING_CONNECTION_H

#include "google/cloud/compute/region_instance_templates/v1/region_instance_templates_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_region_instance_templates_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class RegionInstanceTemplatesTracingConnection
    : public compute_region_instance_templates_v1::
          RegionInstanceTemplatesConnection {
 public:
  ~RegionInstanceTemplatesTracingConnection() override = default;

  explicit RegionInstanceTemplatesTracingConnection(
      std::shared_ptr<compute_region_instance_templates_v1::
                          RegionInstanceTemplatesConnection>
          child);

  Options options() override { return child_->options(); }

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DeleteInstanceTemplate(
      google::cloud::cpp::compute::region_instance_templates::v1::
          DeleteInstanceTemplateRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::InstanceTemplate>
  GetInstanceTemplate(
      google::cloud::cpp::compute::region_instance_templates::v1::
          GetInstanceTemplateRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  InsertInstanceTemplate(
      google::cloud::cpp::compute::region_instance_templates::v1::
          InsertInstanceTemplateRequest const& request) override;

  StreamRange<google::cloud::cpp::compute::v1::InstanceTemplate>
  ListRegionInstanceTemplates(
      google::cloud::cpp::compute::region_instance_templates::v1::
          ListRegionInstanceTemplatesRequest request) override;

 private:
  std::shared_ptr<
      compute_region_instance_templates_v1::RegionInstanceTemplatesConnection>
      child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<
    compute_region_instance_templates_v1::RegionInstanceTemplatesConnection>
MakeRegionInstanceTemplatesTracingConnection(
    std::shared_ptr<
        compute_region_instance_templates_v1::RegionInstanceTemplatesConnection>
        conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_region_instance_templates_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_REGION_INSTANCE_TEMPLATES_V1_INTERNAL_REGION_INSTANCE_TEMPLATES_TRACING_CONNECTION_H
