// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/machine_images/v1/machine_images.proto

#include "google/cloud/compute/machine_images/v1/machine_images_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_machine_images_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

MachineImagesClient::MachineImagesClient(
    std::shared_ptr<MachineImagesConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
MachineImagesClient::~MachineImagesClient() = default;

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
MachineImagesClient::DeleteMachineImage(std::string const& project,
                                        std::string const& machine_image,
                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::machine_images::v1::DeleteMachineImageRequest
      request;
  request.set_project(project);
  request.set_machine_image(machine_image);
  return connection_->DeleteMachineImage(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
MachineImagesClient::DeleteMachineImage(
    google::cloud::cpp::compute::machine_images::v1::
        DeleteMachineImageRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteMachineImage(request);
}

StatusOr<google::cloud::cpp::compute::v1::MachineImage>
MachineImagesClient::GetMachineImage(std::string const& project,
                                     std::string const& machine_image,
                                     Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::machine_images::v1::GetMachineImageRequest
      request;
  request.set_project(project);
  request.set_machine_image(machine_image);
  return connection_->GetMachineImage(request);
}

StatusOr<google::cloud::cpp::compute::v1::MachineImage>
MachineImagesClient::GetMachineImage(
    google::cloud::cpp::compute::machine_images::v1::
        GetMachineImageRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetMachineImage(request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
MachineImagesClient::GetIamPolicy(std::string const& project,
                                  std::string const& resource, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::machine_images::v1::GetIamPolicyRequest request;
  request.set_project(project);
  request.set_resource(resource);
  return connection_->GetIamPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
MachineImagesClient::GetIamPolicy(
    google::cloud::cpp::compute::machine_images::v1::GetIamPolicyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIamPolicy(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
MachineImagesClient::InsertMachineImage(
    std::string const& project,
    google::cloud::cpp::compute::v1::MachineImage const& machine_image_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::machine_images::v1::InsertMachineImageRequest
      request;
  request.set_project(project);
  *request.mutable_machine_image_resource() = machine_image_resource;
  return connection_->InsertMachineImage(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
MachineImagesClient::InsertMachineImage(
    google::cloud::cpp::compute::machine_images::v1::
        InsertMachineImageRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertMachineImage(request);
}

StreamRange<google::cloud::cpp::compute::v1::MachineImage>
MachineImagesClient::ListMachineImages(std::string const& project,
                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::machine_images::v1::ListMachineImagesRequest
      request;
  request.set_project(project);
  return connection_->ListMachineImages(request);
}

StreamRange<google::cloud::cpp::compute::v1::MachineImage>
MachineImagesClient::ListMachineImages(
    google::cloud::cpp::compute::machine_images::v1::ListMachineImagesRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListMachineImages(std::move(request));
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
MachineImagesClient::SetIamPolicy(
    std::string const& project, std::string const& resource,
    google::cloud::cpp::compute::v1::GlobalSetPolicyRequest const&
        global_set_policy_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::machine_images::v1::SetIamPolicyRequest request;
  request.set_project(project);
  request.set_resource(resource);
  *request.mutable_global_set_policy_request_resource() =
      global_set_policy_request_resource;
  return connection_->SetIamPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
MachineImagesClient::SetIamPolicy(
    google::cloud::cpp::compute::machine_images::v1::SetIamPolicyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetIamPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
MachineImagesClient::TestIamPermissions(
    std::string const& project, std::string const& resource,
    google::cloud::cpp::compute::v1::TestPermissionsRequest const&
        test_permissions_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::machine_images::v1::TestIamPermissionsRequest
      request;
  request.set_project(project);
  request.set_resource(resource);
  *request.mutable_test_permissions_request_resource() =
      test_permissions_request_resource;
  return connection_->TestIamPermissions(request);
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
MachineImagesClient::TestIamPermissions(
    google::cloud::cpp::compute::machine_images::v1::
        TestIamPermissionsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_machine_images_v1
}  // namespace cloud
}  // namespace google
