// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/https_health_checks/v1/https_health_checks.proto

#include "google/cloud/compute/https_health_checks/v1/https_health_checks_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_https_health_checks_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

HttpsHealthChecksClient::HttpsHealthChecksClient(
    std::shared_ptr<HttpsHealthChecksConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
HttpsHealthChecksClient::~HttpsHealthChecksClient() = default;

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HttpsHealthChecksClient::DeleteHttpsHealthCheck(
    std::string const& project, std::string const& https_health_check,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::https_health_checks::v1::
      DeleteHttpsHealthCheckRequest request;
  request.set_project(project);
  request.set_https_health_check(https_health_check);
  return connection_->DeleteHttpsHealthCheck(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HttpsHealthChecksClient::DeleteHttpsHealthCheck(
    google::cloud::cpp::compute::https_health_checks::v1::
        DeleteHttpsHealthCheckRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteHttpsHealthCheck(request);
}

StatusOr<google::cloud::cpp::compute::v1::HttpsHealthCheck>
HttpsHealthChecksClient::GetHttpsHealthCheck(
    std::string const& project, std::string const& https_health_check,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::https_health_checks::v1::
      GetHttpsHealthCheckRequest request;
  request.set_project(project);
  request.set_https_health_check(https_health_check);
  return connection_->GetHttpsHealthCheck(request);
}

StatusOr<google::cloud::cpp::compute::v1::HttpsHealthCheck>
HttpsHealthChecksClient::GetHttpsHealthCheck(
    google::cloud::cpp::compute::https_health_checks::v1::
        GetHttpsHealthCheckRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetHttpsHealthCheck(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HttpsHealthChecksClient::InsertHttpsHealthCheck(
    std::string const& project,
    google::cloud::cpp::compute::v1::HttpsHealthCheck const&
        https_health_check_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::https_health_checks::v1::
      InsertHttpsHealthCheckRequest request;
  request.set_project(project);
  *request.mutable_https_health_check_resource() = https_health_check_resource;
  return connection_->InsertHttpsHealthCheck(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HttpsHealthChecksClient::InsertHttpsHealthCheck(
    google::cloud::cpp::compute::https_health_checks::v1::
        InsertHttpsHealthCheckRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertHttpsHealthCheck(request);
}

StreamRange<google::cloud::cpp::compute::v1::HttpsHealthCheck>
HttpsHealthChecksClient::ListHttpsHealthChecks(std::string const& project,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::https_health_checks::v1::
      ListHttpsHealthChecksRequest request;
  request.set_project(project);
  return connection_->ListHttpsHealthChecks(request);
}

StreamRange<google::cloud::cpp::compute::v1::HttpsHealthCheck>
HttpsHealthChecksClient::ListHttpsHealthChecks(
    google::cloud::cpp::compute::https_health_checks::v1::
        ListHttpsHealthChecksRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListHttpsHealthChecks(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HttpsHealthChecksClient::PatchHttpsHealthCheck(
    std::string const& project, std::string const& https_health_check,
    google::cloud::cpp::compute::v1::HttpsHealthCheck const&
        https_health_check_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::https_health_checks::v1::
      PatchHttpsHealthCheckRequest request;
  request.set_project(project);
  request.set_https_health_check(https_health_check);
  *request.mutable_https_health_check_resource() = https_health_check_resource;
  return connection_->PatchHttpsHealthCheck(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HttpsHealthChecksClient::PatchHttpsHealthCheck(
    google::cloud::cpp::compute::https_health_checks::v1::
        PatchHttpsHealthCheckRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchHttpsHealthCheck(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HttpsHealthChecksClient::UpdateHttpsHealthCheck(
    std::string const& project, std::string const& https_health_check,
    google::cloud::cpp::compute::v1::HttpsHealthCheck const&
        https_health_check_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::https_health_checks::v1::
      UpdateHttpsHealthCheckRequest request;
  request.set_project(project);
  request.set_https_health_check(https_health_check);
  *request.mutable_https_health_check_resource() = https_health_check_resource;
  return connection_->UpdateHttpsHealthCheck(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HttpsHealthChecksClient::UpdateHttpsHealthCheck(
    google::cloud::cpp::compute::https_health_checks::v1::
        UpdateHttpsHealthCheckRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateHttpsHealthCheck(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_https_health_checks_v1
}  // namespace cloud
}  // namespace google
