/* stack size guarding
   Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003
   Wouter van Ooijen

This file is part of jal.

jal is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

jal is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with jal; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include "stdhdr.h"
#include "global.h"
#include "target.h"
#include "errorlh.h"
#include "stacksg.h"

/* The report in case of an error can include calls
 * which seem to be part of a recursion, but which
 * are actually just intermidiate calls which consume
 * less stack than the next big stack using call.
 */

char *initial_stack;
int max_stack_size = 0;
int stack_index = 0;
int stack_use[stack_use_depth];
int stack_line[stack_use_depth];

void stack_guard_init(void)
{
    char mark;
    initial_stack = &mark;
}

int current_stack_size(void)
{
    char mark;
#if defined(__DEBUG__)
    printf("0x%X  0x%X\n", (int) initial_stack, (int) &mark);
#endif
    return (abs(initial_stack - (&mark)));
}

boolean stack_dump_done = false;
void stack_dump(void)
{
    int i;
    if (!check_stack)
        return;
    if (stack_dump_done)
        return;
    stack_dump_done = true;
    printf("   nr   line        sp       use\n");
    for (i = 1; i <= stack_index; i++) {
        printf(" %4d   %4d  %8d  %8d\n", i, stack_line[i], stack_use[i],
               stack_use[i] - stack_use[i - 1]);
    }
}

void stack_error(char *s, int line)
{
    printf("%s in %s line %d\n", s, __FILE__, line);
    stack_dump();
    exit(-1);
}

void stack_guard_f(int line)
{
    int current = current_stack_size();
    if (current > max_stack_size)
        max_stack_size = current;

    while ((stack_index > 0) && (current <= stack_use[stack_index])) {
        stack_index--;
    }

    if (stack_index >= stack_use_depth) {
        stack_error("stack depth overflow", line);
    }

    stack_index++;
    stack_use[stack_index] = current;
    stack_line[stack_index] = line;

    if (current + stack_margin > stack_size) {
        stack_error("stack size overflow", line);
    }
}

