/* compilation driver
   Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003
   Wouter van Ooijen

This file is part of jal.

jal is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

jal is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with jal; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include "stdhdr.h"
#include "global.h"
#include "target.h"
#include "errorlh.h"
#include "treerep.h"
#include "assemble.h"
#include "stacksg.h"
#include "scanner.h"
#include "codegen.h"
#include "parser.h"
#include "regalloc.h"
#include "optimizer.h"
#include "squasher.h"
#include "treetools.h"
#include "cstringf.h"
#include "showprog.h"


boolean log_all = false;
boolean last_flag = true;
int source_files = 0;
tree temp = NULL;
tree root_block = NULL;

void main_phase(tree * p, char *name, void call(tree *), boolean flag)
{
    stack_guard;
    progress(name, -1);
    if (log_all | flag) {
        if (!last_flag) {
            log((m, "tree before %s", name));
            trace_subtree(*p);
            log((m, "end tree before %s", name));
        }
        log((m, "start of %s", name));
    }
    call(p);
    if (log_all | flag) {
        log((m, "tree after %s", name));
        trace_subtree(*p);
        log((m, "end tree after %s", name));
    }
    last_flag = log_all | flag;
}

void prepare_compilation(void)
{
    int i;
    open_list(temp);
    stack_guard;
    start_time = current_time();
    root_block = temp;
    init_types();

    /* Wouter's Dwarf patch (config words in PIC16) */
    for( i = 0; i < target_fuses_array_size; i++ ){
       target_fuses_array[ i ] = 5;
    }

        /* read internal rtl source" */
    scanner_open(rtl, "jal rtl", false);
    main_phase(&root_block, "read source", parse, verbose_parser);

    scanner_total_lines = 0;
    scanner_total_files = 0;
    scanner_total_chars = 0;

    if (result_src) {
        string s;
        sprintf(s, "%s.src", main_source_file);
        src_file = fopen(s, "w");
        if (src_file == NULL) {
            fatal(NULL, (m, "can not open %s", s));
        }
    }

}

void compile_one_file(char *arg_name, int do_compile)
{
    string name;
    stack_guard;

    /* get real file name */
    if (!find_name(name, arg_name)) {
        fatal(NULL, (m, "can not open %s", arg_name));
    }

    /* construct base name, last one will prevail */
    sprintf(main_source_file, "%s", name);
   
    chop_extension(main_source_file);
    chop_path(main_source_file);

    /* just test file existence and count files */
    if (!do_compile) {
        source_files++;
        return;
    }

    /* read and parse the input */
    scanner_open(NULL, name, true);
    main_phase(&root_block, "read source", parse, verbose_parser);
}

/* report compilation statistics */
void compilation_statistics(void)
{
    int lines;
    stack_guard;

    compilation_seconds = current_time() - start_time;
    if (compilation_seconds == 0.0) {
        lines = scanner_total_lines;
    } else {
        lines = (int) (scanner_total_lines / compilation_seconds);
        if (lines < 0)
            lines = scanner_total_lines;
    }

    printf("input        files:%d lines:%d chars:%d (%d lines/second)\n", scanner_total_files,
           scanner_total_lines, scanner_total_chars, lines);

    printf("compilation  nodes:%d stack:%dKb heap:%dKb seconds:%2.3f\n", node_nr,
           max_stack_size / 1024, total_memory / 1024, compilation_seconds);

    printf("output       code:%d file:%d stack:%d\n", assembled_code_size,
           used_byte + 1 - target_first_ram, total_stack_usage);
}

void finish_compilation(void)
{
    stack_guard;

    /* scanner_open(rtl_trailer, "jal rtl trailer", false); */
    if ( target_cpu == pic_16 )  {
      scanner_open(rtl_trailer_16, "jal rtl trailer", false) ;
    } else {
      scanner_open(rtl_trailer, "jal rtl trailer", false);
    }

    main_phase(&root_block, "read source", parse, verbose_parser);
    parse_done();
    if (src_file != NULL) {
        fclose(src_file);
        src_file = NULL;
    }

    /* optimize 1 */
    if (verbose_optimizer) {
        show_optimization_settings();
    }
    main_phase(&root_block, "optimize 1", optimize1, verbose_optimizer);

    /* squash = semantic reductions */
    main_phase(&root_block, "squash", squash, verbose_squasher);

    /* optimize 2 */
    if (verbose_optimizer) {
        show_optimization_settings();
    }
    main_phase(&root_block, "optimize 2", optimize2, verbose_optimizer);

    /* register allocation */
    main_phase(&root_block, "ralloc", ralloc, verbose_ralloc);

    indirect_stack_usage = call_depth(list_of_virtuals);
    /* indirect_stack_usage is now taken into account! */
    main_stack_usage = call_depth(root_block);

    /* int_stack_usage      = ( interrupt_service_routine == 0 ) ? 0 : 1;  *//* Start wouter's modification on 20030305 */
    if (interrupt_service_routine == NULL) {
        int_stack_usage = 0;
    } else {
        int_stack_usage = call_depth(interrupt_service_routine);
        if (target_cpu != sx_12) {
            int_stack_usage++;
        }
    }
    total_stack_usage = main_stack_usage + int_stack_usage;

/*   if( target_cpu != sx_12 ){
      total_stack_usage = main_stack_usage;
   } else {
      total_stack_usage = main_stack_usage + int_stack_usage;
                                                                                                                                           }  *//* End wouter's modification on 20030305 */
#ifdef __DEBUG__
    trace_subtree(root_block);
    log((m, "indirect=%d interrupt=%d main=%d total=%d ", indirect_stack_usage, int_stack_usage,
         main_stack_usage, total_stack_usage));
#endif

    /* code generation */
    main_phase(&root_block, "code generation", code, verbose_coder);

    /* page optimization */
    main_phase(&root_block, "bank elimination", optimize_bank, verbose_optimizer);

    /* assemble and write hex file */
    main_phase(&root_block, "assemble", assemble, verbose_assembler);

    /* check call depth */
    {
       int n = ((target_cpu == pic_12) ? 2 : 8);
       if (target_cpu == pic_16) { 
          n = 32;
	    }
       if (total_stack_usage > n) {
          fatal(NULL, (m, "%d stack levels used, only %d available", total_stack_usage, n));
       }
    }

    /* check register use */
    if (used_byte > target_last_ram + 1) {
        fatal(NULL,
              (m, "%d file registers required, only %d available", used_byte - target_first_ram,
               target_last_ram - target_first_ram + 1));
    }

    compilation_statistics();
}
