/*
 *  Copyright (C) 1999 Peter Amstutz
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */

#include "weapon.h"
#include "../gfx.h"
#include "simplegfx.h"
#include "dirtgfx.h"
#include "napalmgfx.h"
#include "blackholegfx.h"
#include "lasergfx.h"

void
wgxSetWeaponDrawFunc(char *name,
		     void (*drawshot) (struct Projectilepos_bal * prjpos,
				       void *info),
		     void (*drawexplosion) (void *info))
{
    Weapon_wep *wcur;

    wcur = wepLookupWeapon(name);
    if(wcur == NULL)
	return;
    wcur->drawshot = drawshot;
    wcur->drawexplosion = drawexplosion;
}

void wgxInit()
{
    wgxSetWeaponDrawFunc("Basic Shell", wgxDrawSimpleShot,
			 wgxDrawSimpleRedExplosion);
    wgxSetWeaponDrawFunc("Large Shell", wgxDrawSimpleShot,
			 wgxDrawSimpleRedExplosion);
    wgxSetWeaponDrawFunc("Dirt Vaporizer", wgxDrawSimpleShot, wgxDrawSimpleBlueExplosion);
    wgxSetWeaponDrawFunc("Tac Nuke", wgxDrawSimpleShot, wgxDrawSimpleBlankExplosion);
    wgxSetWeaponDrawFunc("Super Nuke", wgxDrawSimpleShot,
			 wgxDrawSimpleBlankExplosion);
    wgxSetWeaponDrawFunc("Cluster Bomb", wgxDrawSimpleShot, NULL);
    wgxSetWeaponDrawFunc("Cluster Fragment", wgxDrawSimpleShot,
			 wgxDrawSimpleCyanExplosion);
    wgxSetWeaponDrawFunc("MIRV", wgxDrawSimpleShot, wgxDrawSimpleRedExplosion);
    wgxSetWeaponDrawFunc("MIRV Shell", wgxDrawSimpleShot,
			 wgxDrawSimpleOrangeExplosion);
    wgxSetWeaponDrawFunc("Dirt Ball", wgxDrawSimpleShot, wgxDrawDirtExplosion);
    wgxSetWeaponDrawFunc("Roller", wgxDrawSimpleShot, NULL);
    wgxSetWeaponDrawFunc("Roller Ball", wgxDrawSimpleShot,
			 wgxDrawSimpleRedExplosion);
    wgxSetWeaponDrawFunc("Death From Above", wgxDrawSimpleShot,
			 wgxDrawSimplePurpleExplosion);
    wgxSetWeaponDrawFunc("Funky Bomb", wgxDrawSimpleShot,
			 wgxDrawSimpleRedExplosion);
    wgxSetWeaponDrawFunc("Funky Fragment", wgxDrawSimpleShot,
			 wgxDrawSimpleGreenExplosion);
    wgxSetWeaponDrawFunc("Tunneler", wgxDrawSimpleShot, wgxDrawSimpleRedExplosion);
    wgxSetWeaponDrawFunc("Napalm", wgxDrawSimpleShot, wgxDrawSimpleRedExplosion);
    wgxSetWeaponDrawFunc("Burning Napalm", wgxDrawBurningNapalmShot,
			 wgxDrawBurningNapalmExplosion);
    wgxSetWeaponDrawFunc("Black Hole", wgxDrawBlackHoleShot, wgxDrawBlackHoleExplosion);
    wgxSetWeaponDrawFunc("Dirt Curtain", wgxDrawSimpleShot, wgxDrawSimpleRedExplosion);
    wgxSetWeaponDrawFunc("Laser", wgxDrawLaserShot, wgxDrawLaserExplosion);
    wgxSetWeaponDrawFunc("Depth Charge", wgxDrawSimpleShot, NULL);
    wgxSetWeaponDrawFunc("Depth Charge Shell", wgxDrawSimpleShot, wgxDrawSimpleRedExplosion);
}
