/* -------------------------------
* vim:tabstop=4:shiftwidth=4
* icons.h
* Tue, 24 Aug 2004 12:05:38 +0700
* -------------------------------
* XEMBED protocol implementation
* -------------------------------*/

#ifndef _XEMBED_H_
#define _XEMBED_H_

#include <X11/X.h>

/* Internal return codes */
#define XEMBED_RESULT_OK				0
#define XEMBED_RESULT_UNSUPPORTED		1
#define XEMBED_RESULT_X11ERROR			2

/* XEMBED messages */
#define XEMBED_EMBEDDED_NOTIFY			0
#define XEMBED_WINDOW_ACTIVATE  		1
#define XEMBED_WINDOW_DEACTIVATE  		2
#define XEMBED_REQUEST_FOCUS		 	3
#define XEMBED_FOCUS_IN 	 			4
#define XEMBED_FOCUS_OUT  				5
#define XEMBED_FOCUS_NEXT 				6	
#define XEMBED_FOCUS_PREV 				7
/* 8-9 were used for XEMBED_GRAB_KEY/XEMBED_UNGRAB_KEY */
#define XEMBED_MODALITY_ON 				10
#define XEMBED_MODALITY_OFF 			11
#define XEMBED_REGISTER_ACCELERATOR     12
#define XEMBED_UNREGISTER_ACCELERATOR   13
#define XEMBED_ACTIVATE_ACCELERATOR     14

/* Details for  XEMBED_FOCUS_IN */
#define XEMBED_FOCUS_CURRENT			0
#define XEMBED_FOCUS_FIRST 				1
#define XEMBED_FOCUS_LAST				2

/* Modifiers field for XEMBED_REGISTER_ACCELERATOR */
#define XEMBED_MODIFIER_SHIFT			(1 << 0)
#define XEMBED_MODIFIER_CONTROL			(1 << 1)
#define XEMBED_MODIFIER_ALT				(1 << 2)
#define XEMBED_MODIFIER_SUPER			(1 << 3)
#define XEMBED_MODIFIER_HYPER			(1 << 4)

/* Flags for XEMBED_ACTIVATE_ACCELERATOR */
#define XEMBED_ACCELERATOR_OVERLOADED	(1 << 0)

/* Directions for focusing */
#define XEMBED_DIRECTION_DEFAULT		0
#define XEMBED_DIRECTION_UP_DOWN		1
#define XEMBED_DIRECTION_LEFT_RIGHT		2

/* Flags for _XEMBED_INFO */
#define XEMBED_MAPPED					(1 << 0)

#define xembed_send_msg(dpy, dst, timestamp, msg, detail, data1, data2) \
	x11_send_client_msg32(dpy, dst, dst, xa_xembed, timestamp, msg, detail, data1, data2)

#define xembed_send_embedded_notify(dpy, src, dst, timestamp) \
	xembed_send_msg(dpy, dst, timestamp, XEMBED_EMBEDDED_NOTIFY, 0, src, 0)

#define xembed_send_window_activate(dpy, dst, timestamp) \
	xembed_send_msg(dpy, dst, timestamp, XEMBED_WINDOW_ACTIVATE, 0, 0, 0)

#define xembed_send_window_deactivate(dpy, dst, timestamp) \
	xembed_send_msg(dpy, dst, timestamp, XEMBED_WINDOW_DEACTIVATE, 0, 0, 0)

#define xembed_send_request_focus(dpy, dst, timestamp) \
	xembed_send_msg(dpy, dst, timestamp, XEMBED_REQUEST_FOCUS, 0, 0, 0)

#define xembed_send_focus_in(dpy, dst, focus, timestamp) \
	xembed_send_msg(dpy, dst, timestamp, XEMBED_FOCUS_IN, focus, 0, 0)

#define xembed_send_focus_out(dpy, dst, timestamp) \
	xembed_send_msg(dpy, dst, timestamp, XEMBED_FOCUS_OUT, 0, 0, 0)

#define xembed_send_focus_next(dpy, dst, timestamp) \
	xembed_send_msg(dpy, dst, timestamp, XEMBED_FOCUS_NEXT, 0, 0, 0)

#define xembed_send_focus_prev(dpy, dst, timestamp) \
	xembed_send_msg(dpy, dst, timestamp, XEMBED_FOCUS_PREV, 0, 0, 0)

#define xembed_send_register_accelerator(dpy, dst, timestamp, id, sym, mods) \
	xembed_send_msg(dpy, dst, timestamp, XEMBED_REGISTER_ACCELERATOR, id, sym, mods)

#define xembed_send_activate_accelerator(dpy, dst, timestamp, id, overloaded) \
	xembed_send_msg(dpy, dst, timestamp, XEMBED_ACTIVATE_ACCELERATOR, id, overloaded, 0)


int xembed_retrive_data(Display *dpy, Window w, CARD32 *data);
int xembed_post_data(Display *dpy, Window w, CARD32 *data);


#endif
