/*
Copyright 2024 Keyfactor

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

EJBCA REST Interface

API reference documentation.

API version: 1.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ejbca

import (
	"encoding/json"
)

// checks if the EndEntityRestResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &EndEntityRestResponse{}

// EndEntityRestResponse struct for EndEntityRestResponse
type EndEntityRestResponse struct {
	// Username
	Username *string `json:"username,omitempty"`
	// Subject Distinguished Name
	Dn *string `json:"dn,omitempty"`
	// Subject Alternative Name (SAN)
	SubjectAltName *string `json:"subject_alt_name,omitempty"`
	// Email
	Email *string `json:"email,omitempty"`
	// End Entity status
	Status *string `json:"status,omitempty"`
	// Token type
	Token *string `json:"token,omitempty"`
	// Extended Information
	ExtensionData        []ExtendedInformationRestResponseComponent `json:"extension_data,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _EndEntityRestResponse EndEntityRestResponse

// NewEndEntityRestResponse instantiates a new EndEntityRestResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewEndEntityRestResponse() *EndEntityRestResponse {
	this := EndEntityRestResponse{}
	return &this
}

// NewEndEntityRestResponseWithDefaults instantiates a new EndEntityRestResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewEndEntityRestResponseWithDefaults() *EndEntityRestResponse {
	this := EndEntityRestResponse{}
	return &this
}

// GetUsername returns the Username field value if set, zero value otherwise.
func (o *EndEntityRestResponse) GetUsername() string {
	if o == nil || isNil(o.Username) {
		var ret string
		return ret
	}
	return *o.Username
}

// GetUsernameOk returns a tuple with the Username field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndEntityRestResponse) GetUsernameOk() (*string, bool) {
	if o == nil || isNil(o.Username) {
		return nil, false
	}
	return o.Username, true
}

// HasUsername returns a boolean if a field has been set.
func (o *EndEntityRestResponse) HasUsername() bool {
	if o != nil && !isNil(o.Username) {
		return true
	}

	return false
}

// SetUsername gets a reference to the given string and assigns it to the Username field.
func (o *EndEntityRestResponse) SetUsername(v string) {
	o.Username = &v
}

// GetDn returns the Dn field value if set, zero value otherwise.
func (o *EndEntityRestResponse) GetDn() string {
	if o == nil || isNil(o.Dn) {
		var ret string
		return ret
	}
	return *o.Dn
}

// GetDnOk returns a tuple with the Dn field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndEntityRestResponse) GetDnOk() (*string, bool) {
	if o == nil || isNil(o.Dn) {
		return nil, false
	}
	return o.Dn, true
}

// HasDn returns a boolean if a field has been set.
func (o *EndEntityRestResponse) HasDn() bool {
	if o != nil && !isNil(o.Dn) {
		return true
	}

	return false
}

// SetDn gets a reference to the given string and assigns it to the Dn field.
func (o *EndEntityRestResponse) SetDn(v string) {
	o.Dn = &v
}

// GetSubjectAltName returns the SubjectAltName field value if set, zero value otherwise.
func (o *EndEntityRestResponse) GetSubjectAltName() string {
	if o == nil || isNil(o.SubjectAltName) {
		var ret string
		return ret
	}
	return *o.SubjectAltName
}

// GetSubjectAltNameOk returns a tuple with the SubjectAltName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndEntityRestResponse) GetSubjectAltNameOk() (*string, bool) {
	if o == nil || isNil(o.SubjectAltName) {
		return nil, false
	}
	return o.SubjectAltName, true
}

// HasSubjectAltName returns a boolean if a field has been set.
func (o *EndEntityRestResponse) HasSubjectAltName() bool {
	if o != nil && !isNil(o.SubjectAltName) {
		return true
	}

	return false
}

// SetSubjectAltName gets a reference to the given string and assigns it to the SubjectAltName field.
func (o *EndEntityRestResponse) SetSubjectAltName(v string) {
	o.SubjectAltName = &v
}

// GetEmail returns the Email field value if set, zero value otherwise.
func (o *EndEntityRestResponse) GetEmail() string {
	if o == nil || isNil(o.Email) {
		var ret string
		return ret
	}
	return *o.Email
}

// GetEmailOk returns a tuple with the Email field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndEntityRestResponse) GetEmailOk() (*string, bool) {
	if o == nil || isNil(o.Email) {
		return nil, false
	}
	return o.Email, true
}

// HasEmail returns a boolean if a field has been set.
func (o *EndEntityRestResponse) HasEmail() bool {
	if o != nil && !isNil(o.Email) {
		return true
	}

	return false
}

// SetEmail gets a reference to the given string and assigns it to the Email field.
func (o *EndEntityRestResponse) SetEmail(v string) {
	o.Email = &v
}

// GetStatus returns the Status field value if set, zero value otherwise.
func (o *EndEntityRestResponse) GetStatus() string {
	if o == nil || isNil(o.Status) {
		var ret string
		return ret
	}
	return *o.Status
}

// GetStatusOk returns a tuple with the Status field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndEntityRestResponse) GetStatusOk() (*string, bool) {
	if o == nil || isNil(o.Status) {
		return nil, false
	}
	return o.Status, true
}

// HasStatus returns a boolean if a field has been set.
func (o *EndEntityRestResponse) HasStatus() bool {
	if o != nil && !isNil(o.Status) {
		return true
	}

	return false
}

// SetStatus gets a reference to the given string and assigns it to the Status field.
func (o *EndEntityRestResponse) SetStatus(v string) {
	o.Status = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *EndEntityRestResponse) GetToken() string {
	if o == nil || isNil(o.Token) {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndEntityRestResponse) GetTokenOk() (*string, bool) {
	if o == nil || isNil(o.Token) {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *EndEntityRestResponse) HasToken() bool {
	if o != nil && !isNil(o.Token) {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *EndEntityRestResponse) SetToken(v string) {
	o.Token = &v
}

// GetExtensionData returns the ExtensionData field value if set, zero value otherwise.
func (o *EndEntityRestResponse) GetExtensionData() []ExtendedInformationRestResponseComponent {
	if o == nil || isNil(o.ExtensionData) {
		var ret []ExtendedInformationRestResponseComponent
		return ret
	}
	return o.ExtensionData
}

// GetExtensionDataOk returns a tuple with the ExtensionData field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndEntityRestResponse) GetExtensionDataOk() ([]ExtendedInformationRestResponseComponent, bool) {
	if o == nil || isNil(o.ExtensionData) {
		return nil, false
	}
	return o.ExtensionData, true
}

// HasExtensionData returns a boolean if a field has been set.
func (o *EndEntityRestResponse) HasExtensionData() bool {
	if o != nil && !isNil(o.ExtensionData) {
		return true
	}

	return false
}

// SetExtensionData gets a reference to the given []ExtendedInformationRestResponseComponent and assigns it to the ExtensionData field.
func (o *EndEntityRestResponse) SetExtensionData(v []ExtendedInformationRestResponseComponent) {
	o.ExtensionData = v
}

func (o EndEntityRestResponse) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o EndEntityRestResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !isNil(o.Username) {
		toSerialize["username"] = o.Username
	}
	if !isNil(o.Dn) {
		toSerialize["dn"] = o.Dn
	}
	if !isNil(o.SubjectAltName) {
		toSerialize["subject_alt_name"] = o.SubjectAltName
	}
	if !isNil(o.Email) {
		toSerialize["email"] = o.Email
	}
	if !isNil(o.Status) {
		toSerialize["status"] = o.Status
	}
	if !isNil(o.Token) {
		toSerialize["token"] = o.Token
	}
	if !isNil(o.ExtensionData) {
		toSerialize["extension_data"] = o.ExtensionData
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *EndEntityRestResponse) UnmarshalJSON(bytes []byte) (err error) {
	varEndEntityRestResponse := _EndEntityRestResponse{}

	if err = json.Unmarshal(bytes, &varEndEntityRestResponse); err == nil {
		*o = EndEntityRestResponse(varEndEntityRestResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "username")
		delete(additionalProperties, "dn")
		delete(additionalProperties, "subject_alt_name")
		delete(additionalProperties, "email")
		delete(additionalProperties, "status")
		delete(additionalProperties, "token")
		delete(additionalProperties, "extension_data")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableEndEntityRestResponse struct {
	value *EndEntityRestResponse
	isSet bool
}

func (v NullableEndEntityRestResponse) Get() *EndEntityRestResponse {
	return v.value
}

func (v *NullableEndEntityRestResponse) Set(val *EndEntityRestResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableEndEntityRestResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableEndEntityRestResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableEndEntityRestResponse(val *EndEntityRestResponse) *NullableEndEntityRestResponse {
	return &NullableEndEntityRestResponse{value: val, isSet: true}
}

func (v NullableEndEntityRestResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableEndEntityRestResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
