/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.stream;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.eso.util.stream.Message;
import org.eso.util.stream.RoutingTask;

public class HoldingTask
extends RoutingTask {
    static final Logger logger = Logger.getLogger(HoldingTask.class);
    private static final String classLogName = "HoldingTask";
    private final LinkedBlockingQueue<Message> msgQueue = new LinkedBlockingQueue();

    public HoldingTask() {
        super(classLogName);
        String methodLogName = "HoldingTask::HoldingTask() [for task HoldingTask]";
        logger.trace("HoldingTask::HoldingTask() [for task HoldingTask]");
    }

    public HoldingTask(String taskName) {
        super(taskName);
        String methodLogName = "HoldingTask::HoldingTask(String) [for task " + taskName + "]";
        logger.trace(methodLogName);
    }

    @Override
    public final Message get() {
        String methodLogName = "HoldingTask::get() [for task " + this.getTaskName() + "]";
        logger.trace(methodLogName);
        return this.get(0L);
    }

    @Override
    public final Message get(long timeout) {
        String methodLogName = "HoldingTask::get(long) [for task " + this.getTaskName() + "]";
        logger.trace(methodLogName);
        Message message = null;
        try {
            message = timeout == 0L ? this.msgQueue.take() : this.msgQueue.poll(timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            logger.debug(methodLogName + " - interrupt received whilst waiting for message.");
            Thread.currentThread().interrupt();
        }
        if (message == null) {
            logger.debug(methodLogName + " - no message retrieved.");
        } else {
            logger.debug(methodLogName + " - message retrieved.");
        }
        return message;
    }

    @Override
    public final void put(Message message) {
        String methodLogName = "HoldingTask::put() [for task " + this.getTaskName() + "]";
        logger.trace(methodLogName);
        boolean interruptDetected = Thread.interrupted();
        while (true) {
            try {
                this.msgQueue.put(message);
                logger.debug(methodLogName + " - added message to queue.");
            }
            catch (InterruptedException ie) {
                logger.debug(methodLogName + " - interrupt received whilst waiting" + " to queue a message.");
                interruptDetected = true;
                continue;
            }
            break;
        }
        if (interruptDetected) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public final void putNext(Message message) {
        String methodLogName = "HoldingTask::putNext() [for task " + this.getTaskName() + "]";
        logger.trace(methodLogName);
        logger.debug(methodLogName + " - delegating to put().");
        this.put(message);
    }
}

