/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.filesystem;

import java.io.File;
import java.io.FilenameFilter;
import org.apache.log4j.Logger;

public class FileExtensionFilter
implements FilenameFilter {
    static final Logger logger = Logger.getLogger(FileExtensionFilter.class);
    private static final String classLogName = "FileExtensionFilter";
    private final String fileExtension;

    public FileExtensionFilter(String fileExtension) throws NullPointerException {
        String methodLogName = "FileExtensionFilter::FileExtensionFilter()";
        logger.trace("FileExtensionFilter::FileExtensionFilter()");
        if (fileExtension == null) {
            String message = "FileExtensionFilter::FileExtensionFilter() - fileExtension must not be null.";
            logger.fatal("FileExtensionFilter::FileExtensionFilter() - fileExtension must not be null.");
            throw new NullPointerException("FileExtensionFilter::FileExtensionFilter() - fileExtension must not be null.");
        }
        this.fileExtension = fileExtension;
    }

    public String getFileExtension() {
        String methodLogName = "FileExtensionFilter::getFileExtension()";
        logger.trace("FileExtensionFilter::getFileExtension()");
        return this.fileExtension;
    }

    @Override
    public boolean accept(File directory, String filename) throws NullPointerException {
        String methodLogName = "FileExtensionFilter::accept()";
        logger.trace("FileExtensionFilter::accept()");
        if (filename == null) {
            String message = "FileExtensionFilter::accept() - filename must not be null.";
            logger.fatal("FileExtensionFilter::accept() - filename must not be null.");
            throw new NullPointerException("FileExtensionFilter::accept() - filename must not be null.");
        }
        return filename.endsWith(this.fileExtension);
    }
}

