/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.archive;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eso.util.archive.ArchiveException;
import org.eso.util.archive.NgasActiveNodesService;
import org.eso.util.archive.NgasHost;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class DbTableNgasActiveNodesService
implements NgasActiveNodesService {
    private static final String HOST_COLUMN = "ngas_host";
    private static final String PORT_COLUMN = "ngas_port";
    private final String table;
    private final String filter;
    private JdbcTemplate jdbcTemplate;

    public DbTableNgasActiveNodesService(JdbcTemplate jdbcTemplate, String table) {
        this.jdbcTemplate = jdbcTemplate;
        this.table = table;
        this.filter = null;
    }

    public DbTableNgasActiveNodesService(JdbcTemplate jdbcTemplate, String table, String filter) {
        this.jdbcTemplate = jdbcTemplate;
        this.table = table;
        this.filter = filter;
    }

    @Override
    public List<NgasHost> getActiveNodes() throws ArchiveException {
        String query = "SELECT ngas_host,ngas_port FROM " + this.table;
        if (this.filter != null) {
            query = query + " WHERE ngas_host LIKE '" + this.filter + "%'";
        }
        try {
            List<Map<String, Object>> res = this.jdbcTemplate.queryForList(query);
            ArrayList<NgasHost> retValue = new ArrayList<NgasHost>();
            Iterator<Map<String, Object>> i$ = res.iterator();
            while (i$.hasNext()) {
                Map<String, Object> row;
                Map<String, Object> map = row = i$.next();
                NgasHost ngasHost = new NgasHost(map.get(HOST_COLUMN).toString(), Integer.valueOf(map.get(PORT_COLUMN).toString()));
                retValue.add(ngasHost);
            }
            return retValue;
        }
        catch (DataAccessException e2) {
            throw new ArchiveException(e2);
        }
    }
}

