/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.gui;

import java.util.Vector;
import javax.swing.tree.TreePath;
import org.eso.gasgano.gui.TreeTableModel;

public class TreeModelIterator {
    private TreeTableModel tm = null;
    private Vector currentPath = null;
    private boolean hasIterated = false;

    public TreeModelIterator(TreeTableModel t, TreePath start) {
        this.tm = t;
        this.currentPath = new Vector();
        if (start == null || start.getPathCount() <= 0) {
            this.currentPath.addElement(this.tm.getRoot());
        } else {
            Object[] startPath = start.getPath();
            for (int i = 0; i < startPath.length; ++i) {
                this.currentPath.addElement(startPath[i]);
            }
        }
    }

    public Vector getCurrentPath() {
        return this.currentPath;
    }

    public void iteratePath() {
        int pathLength = this.currentPath.size();
        Object me = this.currentPath.elementAt(pathLength - 1);
        if (pathLength > 1) {
            Object myParent = this.currentPath.elementAt(pathLength - 2);
            int myIndex = this.tm.getIndexOfChild(myParent, me);
            if (myIndex + 1 < this.tm.getChildCount(myParent)) {
                Object parent = this.tm.getChild(myParent, myIndex + 1);
                this.currentPath.setElementAt(parent, pathLength - 1);
                while (this.tm.getChildCount(parent) > 0) {
                    parent = this.tm.getChild(parent, 0);
                    this.currentPath.addElement(parent);
                }
            } else {
                this.currentPath.removeElementAt(pathLength - 1);
            }
        } else {
            Object parent = me;
            while (this.tm.getChildCount(parent) > 0) {
                parent = this.tm.getChild(parent, 0);
                this.currentPath.addElement(parent);
            }
        }
    }
}

