/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.eso.dfs.gui.RecallingComboBox;
import org.eso.dfs.services.ServiceException;
import org.eso.dfs.services.gui.FileImageDisplayHandler;
import org.eso.gasgano.GasganoDisplay;
import org.eso.gasgano.ResultsTreeTable;
import org.eso.gasgano.datamodel.gui.OBComponent;
import org.eso.gasgano.dfspipeline.DFSPipelineEnvironment;
import org.eso.gasgano.dfspipeline.DFSPipelineStatusListener;
import org.eso.gasgano.gui.DFSFileTreeTable;
import org.eso.gasgano.gui.DFSFileTreeTableModel;
import org.eso.gasgano.gui.GUIUtils;
import org.eso.gasgano.gui.JTreeTable;
import org.eso.gasgano.gui.TreeModelIterator;
import org.eso.gasgano.gui.TreeTableModel;
import org.eso.gasgano.properties.PropertyDB;
import org.eso.gasgano.viewers.ExternalViewer;
import org.eso.gasgano.viewers.ExternalViewerException;
import org.eso.gasgano.viewers.ExternalViewerFactory;

public class TreeControlPanel
extends JPanel
implements ActionListener,
TreeSelectionListener,
DFSPipelineStatusListener,
FileImageDisplayHandler {
    private JComboBox groupSelector;
    private JButton expandTree;
    private RecallingComboBox findEntry;
    private JButton findButton;
    private JTreeTable treeTable;
    private TreeTableModel model;
    private static final String groupByProgLabel = "Default grouping";
    private static final String groupByDirLabel = "Group by Directory";
    private static final String groupByTelLabel = "Group by Telescope";
    private static final String expandLabel = "expand";
    private static final String collapseLabel = "collapse";
    private static final String findLabel = "find";
    private JLabel rbsLabel;
    private JLabel doLabel;
    private JLabel selectedNumber;
    private JToolBar toolBar;
    private JButton displayButton;
    private JButton reportButton;
    private JButton scriptBoardButton;
    private GasganoDisplay mainDisplay;

    public TreeControlPanel(JTreeTable t, TreeTableModel m, GasganoDisplay gd) {
        this.treeTable = t;
        this.model = m;
        this.mainDisplay = gd;
        this.init();
    }

    private void init() {
        Vector<String> items = new Vector<String>(2);
        this.setLayout(new BorderLayout());
        items.addElement(groupByProgLabel);
        items.addElement(groupByDirLabel);
        items.addElement(groupByTelLabel);
        this.groupSelector = new JComboBox(items);
        this.groupSelector.addActionListener(this);
        this.expandTree = new JButton(expandLabel);
        this.expandTree.addActionListener(this);
        JPanel searchPanel = new JPanel();
        searchPanel.add(new JLabel("Find entry:"));
        this.findEntry = new RecallingComboBox(true, 20);
        this.findEntry.addActionListener(this);
        searchPanel.add(this.findEntry);
        this.findButton = new JButton(findLabel);
        this.findButton.addActionListener(this);
        searchPanel.add(this.findButton);
        searchPanel.setBorder(new LineBorder(Color.black, 1));
        JPanel centerPanel = new JPanel();
        centerPanel.add(this.groupSelector);
        centerPanel.add(this.expandTree);
        centerPanel.add(searchPanel);
        this.add((Component)centerPanel, "Center");
        JPanel eastPanel = new JPanel(new BorderLayout());
        this.selectedNumber = new JLabel("0");
        this.selectedNumber.setBorder(new EmptyBorder(3, 1, 10, 6));
        this.treeTable.getTree().addTreeSelectionListener(this);
        eastPanel.add((Component)this.selectedNumber, "West");
        if (DFSPipelineEnvironment.getInstance().isPipelineEnvironment()) {
            Font tmpFont = null;
            this.doLabel = new JLabel("DO");
            this.doLabel.setHorizontalTextPosition(2);
            tmpFont = new Font(this.doLabel.getFont().getName(), 1, this.doLabel.getFont().getSize());
            this.rbsLabel = new JLabel("RBS");
            this.rbsLabel.setHorizontalTextPosition(2);
            this.doLabel.setFont(tmpFont);
            this.rbsLabel.setFont(tmpFont);
            JPanel infrastructurePanel = new JPanel();
            infrastructurePanel.setBorder(new CompoundBorder(new EmptyBorder(2, 2, 2, 5), new CompoundBorder(new LineBorder(Color.blue), new EmptyBorder(1, 5, 1, 5))));
            infrastructurePanel.setLayout(new GridLayout(2, 1));
            infrastructurePanel.add(this.rbsLabel);
            infrastructurePanel.add(this.doLabel);
            eastPanel.add((Component)infrastructurePanel, "East");
        }
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.toolBar.setBorder(new EmptyBorder(1, 10, 1, 1));
        ToolTipManager.sharedInstance().setInitialDelay(50);
        ImageIcon tmpIcon = new ImageIcon(this.getClass().getResource("/org/eso/gasgano/gui/icons/video.gif"));
        this.displayButton = new JButton(tmpIcon);
        tmpIcon = new ImageIcon(this.getClass().getResource("/org/eso/gasgano/gui/icons/document.gif"));
        this.reportButton = new JButton(tmpIcon);
        tmpIcon = new ImageIcon(this.getClass().getResource("/org/eso/gasgano/gui/icons/kdisknav.gif"));
        this.scriptBoardButton = new JButton(tmpIcon);
        this.displayButton.addActionListener(this);
        this.scriptBoardButton.addActionListener(this);
        this.reportButton.addActionListener(this);
        this.displayButton.setToolTipText("External Viewer");
        this.scriptBoardButton.setToolTipText("Script Board");
        this.reportButton.setToolTipText("Frames Report");
        this.toolBar.add(this.displayButton);
        this.toolBar.add(this.reportButton);
        this.toolBar.add(this.scriptBoardButton);
        this.add((Component)this.toolBar, "West");
        this.add((Component)eastPanel, "East");
    }

    @Override
    public void notifyDORunning(boolean status) {
        Color activeColor = Color.blue;
        if (status) {
            this.doLabel.setForeground(activeColor);
        } else {
            this.doLabel.setForeground(Color.white);
        }
    }

    @Override
    public void notifyRBSRunning(boolean status) {
        Color activeColor = Color.blue;
        if (status) {
            this.rbsLabel.setForeground(activeColor);
        } else {
            this.rbsLabel.setForeground(Color.white);
        }
    }

    @Override
    public void actionPerformed(ActionEvent a2) {
        if (a2.getSource() == this.groupSelector) {
            String item = this.groupSelector.getSelectedItem().toString();
            if (item == groupByProgLabel) {
                this.groupBy(0);
                this.expandTree.setText(expandLabel);
            }
            if (item == groupByDirLabel) {
                this.groupBy(1);
                this.expandTree.setText(expandLabel);
            }
            if (item == groupByTelLabel) {
                this.groupBy(2);
                this.expandTree.setText(expandLabel);
            }
        } else if (a2.getActionCommand() == expandLabel) {
            this.expandTree.setText(collapseLabel);
            this.expandTree();
        } else if (a2.getActionCommand() == collapseLabel) {
            this.expandTree.setText(expandLabel);
            this.collapseTree();
        } else if (a2.getSource() == this.findButton) {
            if (this.findEntry.getSelectedIndex() > -1) {
                URL loc;
                String text = this.findEntry.getSelectedItem().toString();
                ImageIcon showPic = null;
                if (text.equalsIgnoreCase("gasgano")) {
                    loc = Object.class.getResource("/org/eso/gasgano/gui/icons/Gasgano2.gif");
                    if (loc != null) {
                        showPic = new ImageIcon(loc);
                    }
                } else if (text.equalsIgnoreCase("podrace") && (loc = Object.class.getResource("/org/eso/gasgano/gui/icons/podrace_bg.jpg")) != null) {
                    showPic = new ImageIcon(loc);
                }
                if (showPic != null && this.getTopLevelAncestor() instanceof JFrame) {
                    JFrame parent = (JFrame)this.getTopLevelAncestor();
                    JOptionPane pane = new JOptionPane("", 1, -1, showPic);
                    JDialog dialog = pane.createDialog(parent, "Gasgano");
                    dialog.show();
                }
                if (!this.searchTree(text)) {
                    this.userMessage("'" + text + "' not located.");
                }
            }
        } else if (a2.getSource() == this.displayButton) {
            this.callExternalViewer();
        } else if (a2.getSource() == this.scriptBoardButton) {
            this.mainDisplay.toggleScriptBoard();
        } else if (a2.getSource() == this.reportButton) {
            this.mainDisplay.generateReport();
        }
    }

    public boolean searchTreeForOBComponent(String obcId) {
        Object currentNode;
        Object endSearchNode = null;
        boolean rc = false;
        TreePath selPath = this.treeTable.getTree().getLeadSelectionPath();
        boolean found = false;
        TreeModelIterator iterator = null;
        int columnCount = this.model.getColumnCount();
        endSearchNode = selPath != null ? selPath.getLastPathComponent() : this.model.getRoot();
        iterator = new TreeModelIterator(this.model, selPath);
        do {
            iterator.iteratePath();
            currentNode = iterator.getCurrentPath().lastElement();
            if (!(currentNode instanceof OBComponent)) continue;
            found = ((OBComponent)currentNode).getId().equals(obcId);
        } while (currentNode != endSearchNode && !found);
        if (found) {
            Vector pathVector = iterator.getCurrentPath();
            Object[] path = new Object[pathVector.size()];
            for (int i = 0; i < path.length; ++i) {
                path[i] = pathVector.elementAt(i);
            }
            TreePath tp = new TreePath(path);
            this.treeTable.getTree().setSelectionPath(tp);
            this.treeTable.getTree().setSelectionPath(tp);
            Rectangle r = this.treeTable.getCellRect(this.treeTable.getSelectedRow(), 0, true);
            this.treeTable.scrollRectToVisible(r);
        }
        return found;
    }

    public boolean searchTree(String findString) {
        Object currentNode;
        Object endSearchNode = null;
        boolean rc = false;
        TreePath selPath = this.treeTable.getTree().getLeadSelectionPath();
        boolean found = false;
        TreeModelIterator iterator = null;
        int columnCount = this.model.getColumnCount();
        findString = findString.toUpperCase();
        endSearchNode = selPath != null ? selPath.getLastPathComponent() : this.model.getRoot();
        iterator = new TreeModelIterator(this.model, selPath);
        do {
            iterator.iteratePath();
            currentNode = iterator.getCurrentPath().lastElement();
            for (int i = 0; i < columnCount && !found; ++i) {
                String nodeVal;
                Object cellValue = this.model.getValueAt(currentNode, i);
                if (cellValue == null || (nodeVal = cellValue.toString().toUpperCase()).indexOf(findString) == -1) continue;
                found = true;
            }
        } while (currentNode != endSearchNode && !found);
        if (found) {
            Vector pathVector = iterator.getCurrentPath();
            Object[] path = new Object[pathVector.size()];
            for (int i = 0; i < path.length; ++i) {
                path[i] = pathVector.elementAt(i);
            }
            TreePath tp = new TreePath(path);
            this.treeTable.getTree().setSelectionPath(tp);
            this.treeTable.getTree().setSelectionPath(tp);
            Rectangle r = this.treeTable.getCellRect(this.treeTable.getSelectedRow(), 0, true);
            this.treeTable.scrollRectToVisible(r);
        }
        return found;
    }

    private void userMessage(String msg) {
        GUIUtils.userMessage(this, msg);
    }

    public void groupBy(int gbLevel) {
        if (this.model instanceof DFSFileTreeTableModel) {
            this.treeTable.getTree().clearSelection();
            this.mainDisplay.showBlankDetail(true);
            ((DFSFileTreeTableModel)this.model).setGroupDataByLevel(gbLevel);
        }
    }

    public void collapseTree() {
        int rows;
        for (int i = rows = this.treeTable.getRowCount() - 1; i > 0; --i) {
            this.treeTable.getTree().collapseRow(i);
        }
    }

    public void expandTree() {
        for (int i = 0; i < this.treeTable.getTree().getRowCount(); ++i) {
            this.treeTable.getTree().expandRow(i);
        }
    }

    public Component getFindEntryComponent() {
        return this.findEntry;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e2) {
        Vector files = null;
        if (this.treeTable instanceof DFSFileTreeTable) {
            files = ((DFSFileTreeTable)this.treeTable).getSelectedOBComponents();
        }
        if (this.treeTable instanceof ResultsTreeTable) {
            files = ((ResultsTreeTable)this.treeTable).getSelectedOBComponents();
        }
        if (files == null) {
            this.selectedNumber.setText("0");
        } else {
            this.selectedNumber.setText(String.valueOf(files.size()));
        }
    }

    public boolean callExternalViewer() {
        DFSFileTreeTable tree = (DFSFileTreeTable)this.treeTable;
        Vector obcomp = tree.getSelectedOBComponents();
        ArrayList<String> files = new ArrayList<String>();
        for (OBComponent obc : obcomp) {
            files.add(obc.getId());
        }
        return this.callExternalViewer(files);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean callExternalViewer(List files) {
        String displayCommand = null;
        String displayCommandType = null;
        Vector<String> displayArguments = new Vector<String>();
        if (files.size() == 0) {
            this.userMessage("No files have been selected.");
            return false;
        }
        if (files.size() <= 1) {
            String ffoc = (String)files.get(0);
            if (ffoc.endsWith(".fits")) {
                displayCommand = PropertyDB.getInstance().getProperty("FITS_TO_VIEWER");
                displayCommandType = PropertyDB.getInstance().getProperty("FITS_VIEWER_TYPE");
                if (displayCommand.equals("") || displayCommandType.equals("")) {
                    this.userMessage("The viewer for fits files\nhas not been specified");
                    return false;
                }
                displayArguments.addElement(ffoc);
            }
            if (ffoc.endsWith(".tfits")) {
                displayCommand = PropertyDB.getInstance().getProperty("TFITS_TO_VIEWER");
                displayCommandType = PropertyDB.getInstance().getProperty("TFITS_VIEWER_TYPE");
                if (displayCommand.equals("") || displayCommandType.equals("")) {
                    this.userMessage("The viewer for binary tables\nhas not been specified");
                    return false;
                }
                displayArguments.addElement(ffoc);
            }
        } else {
            boolean valid = true;
            for (int i = 0; i < files.size(); ++i) {
                String ffoc = (String)files.get(i);
                if (!ffoc.endsWith(".fits")) {
                    valid = false;
                    break;
                }
                displayArguments.addElement(ffoc + " ");
            }
            if (!valid) {
                this.userMessage("Sorry - I wouldn't know how to display that!\nFor a cube to be displayed all files must be FITS files");
                return false;
            }
            displayCommand = PropertyDB.getInstance().getProperty("CUBE_TO_VIEWER");
            displayCommandType = PropertyDB.getInstance().getProperty("CUBE_VIEWER_TYPE");
            if (displayCommand.equals("") || displayCommandType.equals("")) {
                this.userMessage("The viewer for cubes\nhas not been specified");
                return false;
            }
        }
        boolean rc = false;
        if (displayCommand == null || displayCommandType == null || displayArguments.size() == 0) {
            this.userMessage("Sorry - I wouldn't know\nhow to display that!");
            return rc;
        }
        ExternalViewer viewer = null;
        try {
            viewer = ExternalViewerFactory.getInstance().getExternalViewer(displayCommandType);
            viewer.setCommand(displayCommand);
            viewer.displayFiles(displayArguments);
            return true;
        }
        catch (ExternalViewerException e2) {
            this.userMessage("Error with viewer: " + e2.getMessage());
        }
        return rc;
    }

    @Override
    public boolean displayFileImages(String[] fileIds, boolean showImage) throws ServiceException {
        boolean rc = false;
        ArrayList<String> files = new ArrayList<String>();
        if (fileIds != null && fileIds.length > 0) {
            for (int i = 0; i < fileIds.length; ++i) {
                files.add(fileIds[i]);
            }
            if (fileIds.length > 0) {
                this.searchTreeForOBComponent(fileIds[fileIds.length - 1]);
                if (!showImage) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Container frame = TreeControlPanel.this.getTopLevelAncestor();
                            if (frame != null && frame instanceof JFrame) {
                                ((JFrame)frame).setState(0);
                                ((JFrame)frame).toFront();
                            }
                        }
                    });
                }
            }
            rc = true;
            if (showImage) {
                rc = this.callExternalViewer(files);
            }
        }
        return true;
    }
}

