/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;

class WrapperDoubleMatrix1D
extends DoubleMatrix1D {
    protected DoubleMatrix1D content;

    public WrapperDoubleMatrix1D(DoubleMatrix1D doubleMatrix1D) {
        if (doubleMatrix1D != null) {
            this.setUp(doubleMatrix1D.size());
        }
        this.content = doubleMatrix1D;
    }

    protected DoubleMatrix1D getContent() {
        return this.content;
    }

    public double getQuick(int n) {
        return this.content.getQuick(n);
    }

    public DoubleMatrix1D like(int n) {
        return this.content.like(n);
    }

    public DoubleMatrix2D like2D(int n, int n2) {
        return this.content.like2D(n, n2);
    }

    public void setQuick(int n, double d2) {
        this.content.setQuick(n, d2);
    }

    public DoubleMatrix1D viewFlip() {
        WrapperDoubleMatrix1D wrapperDoubleMatrix1D = new WrapperDoubleMatrix1D(this){

            public double getQuick(int n) {
                return this.content.get(this.size - 1 - n);
            }

            public void setQuick(int n, double d2) {
                this.content.set(this.size - 1 - n, d2);
            }
        };
        return wrapperDoubleMatrix1D;
    }

    public DoubleMatrix1D viewPart(final int n, int n2) {
        this.checkRange(n, n2);
        WrapperDoubleMatrix1D wrapperDoubleMatrix1D = new WrapperDoubleMatrix1D(this){

            public double getQuick(int n2) {
                return this.content.get(n + n2);
            }

            public void setQuick(int n2, double d2) {
                this.content.set(n + n2, d2);
            }
        };
        wrapperDoubleMatrix1D.size = n2;
        return wrapperDoubleMatrix1D;
    }

    public DoubleMatrix1D viewSelection(int[] nArray) {
        if (nArray == null) {
            nArray = new int[this.size];
            int n = this.size;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        this.checkIndexes(nArray);
        final int[] nArray2 = nArray;
        WrapperDoubleMatrix1D wrapperDoubleMatrix1D = new WrapperDoubleMatrix1D(this){

            public double getQuick(int n) {
                return this.content.get(nArray2[n]);
            }

            public void setQuick(int n, double d2) {
                this.content.set(nArray2[n], d2);
            }
        };
        wrapperDoubleMatrix1D.size = nArray.length;
        return wrapperDoubleMatrix1D;
    }

    protected DoubleMatrix1D viewSelectionLike(int[] nArray) {
        throw new InternalError();
    }

    public DoubleMatrix1D viewStrides(final int n) {
        if (this.stride <= 0) {
            throw new IndexOutOfBoundsException("illegal stride: " + this.stride);
        }
        WrapperDoubleMatrix1D wrapperDoubleMatrix1D = new WrapperDoubleMatrix1D(this){

            public double getQuick(int n2) {
                return this.content.get(n2 * n);
            }

            public void setQuick(int n2, double d2) {
                this.content.set(n2 * n, d2);
            }
        };
        wrapperDoubleMatrix1D.size = this.size;
        if (this.size != 0) {
            wrapperDoubleMatrix1D.size = (this.size - 1) / n + 1;
        }
        return wrapperDoubleMatrix1D;
    }
}

