/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer;

import cern.colt.PersistentObject;
import cern.colt.buffer.DoubleBuffer3DConsumer;
import cern.colt.list.DoubleArrayList;

public class DoubleBuffer3D
extends PersistentObject
implements DoubleBuffer3DConsumer {
    protected DoubleBuffer3DConsumer target;
    protected double[] xElements;
    protected double[] yElements;
    protected double[] zElements;
    protected DoubleArrayList xList;
    protected DoubleArrayList yList;
    protected DoubleArrayList zList;
    protected int capacity;
    protected int size;

    public DoubleBuffer3D(DoubleBuffer3DConsumer doubleBuffer3DConsumer, int n) {
        this.target = doubleBuffer3DConsumer;
        this.capacity = n;
        this.xElements = new double[n];
        this.yElements = new double[n];
        this.zElements = new double[n];
        this.xList = new DoubleArrayList(this.xElements);
        this.yList = new DoubleArrayList(this.yElements);
        this.zList = new DoubleArrayList(this.zElements);
        this.size = 0;
    }

    public void add(double d2, double d3, double d4) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = d2;
        this.yElements[this.size] = d3;
        this.zElements[this.size++] = d4;
    }

    public void addAllOf(DoubleArrayList doubleArrayList, DoubleArrayList doubleArrayList2, DoubleArrayList doubleArrayList3) {
        int n = doubleArrayList.size();
        if (this.size + n >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(doubleArrayList, doubleArrayList2, doubleArrayList3);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.zList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList, this.zList);
            this.size = 0;
        }
    }
}

