#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#ifndef isblank
#define isblank(x)      ((x) == ' ' || (x) == '\t')
#endif

#include "sa.h"
#include "utils.h"


sa * split_line(char *in)
{
	char end = 0;
	char *dummy;
	sa *out;
	char *copy = mystrdup(in);

	out = new sa;
	if (!out)
	{
		free(copy);
		return NULL;
	}

	dummy = &copy[16];
	do
	{
		char *start = dummy;

		/* find end of word */
		while(!isblank(*dummy) && *dummy != 0x00)
			dummy++;
		end = *dummy == 0x00;
		*dummy=0x00;

		out -> add(start);

		/* skip blanks */
		dummy++;
		while(!end && isblank(*dummy))
		{
			end = *dummy == 0x00;
			dummy++;
		}
	}
	while(!end);

	free(copy);

	return out;
}
