/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery.plan;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.repositories.IndexId;

public class ShardRecoveryPlan {
    private final Store.MetadataSnapshot sourceMetadataSnapshot;
    private final SnapshotFilesToRecover snapshotFilesToRecover;
    private final List<StoreFileMetadata> sourceFilesToRecover;
    private final List<StoreFileMetadata> filesPresentInTarget;
    private final long startingSeqNo;
    private final int translogOps;
    @Nullable
    private final ShardRecoveryPlan fallbackPlan;

    public ShardRecoveryPlan(SnapshotFilesToRecover snapshotFilesToRecover, List<StoreFileMetadata> sourceFilesToRecover, List<StoreFileMetadata> filesPresentInTarget, long startingSeqNo, int translogOps, Store.MetadataSnapshot sourceMetadataSnapshot) {
        this(snapshotFilesToRecover, sourceFilesToRecover, filesPresentInTarget, startingSeqNo, translogOps, sourceMetadataSnapshot, null);
    }

    public ShardRecoveryPlan(SnapshotFilesToRecover snapshotFilesToRecover, List<StoreFileMetadata> sourceFilesToRecover, List<StoreFileMetadata> filesPresentInTarget, long startingSeqNo, int translogOps, Store.MetadataSnapshot sourceMetadataSnapshot, @Nullable ShardRecoveryPlan fallbackPlan) {
        this.snapshotFilesToRecover = snapshotFilesToRecover;
        this.sourceFilesToRecover = sourceFilesToRecover;
        this.filesPresentInTarget = filesPresentInTarget;
        this.sourceMetadataSnapshot = sourceMetadataSnapshot;
        this.startingSeqNo = startingSeqNo;
        this.translogOps = translogOps;
        this.fallbackPlan = fallbackPlan;
    }

    public List<StoreFileMetadata> getFilesPresentInTarget() {
        return this.filesPresentInTarget;
    }

    public List<String> getFilesPresentInTargetNames() {
        return this.filesPresentInTarget.stream().map(StoreFileMetadata::name).collect(Collectors.toList());
    }

    public List<Long> getFilesPresentInTargetSizes() {
        return this.filesPresentInTarget.stream().map(StoreFileMetadata::length).collect(Collectors.toList());
    }

    public List<StoreFileMetadata> getSourceFilesToRecover() {
        return this.sourceFilesToRecover;
    }

    public List<String> getFilesToRecoverNames() {
        return this.getFilesToRecoverStream().map(StoreFileMetadata::name).collect(Collectors.toList());
    }

    public List<Long> getFilesToRecoverSizes() {
        return this.getFilesToRecoverStream().map(StoreFileMetadata::length).collect(Collectors.toList());
    }

    public SnapshotFilesToRecover getSnapshotFilesToRecover() {
        return this.snapshotFilesToRecover;
    }

    public Store.MetadataSnapshot getSourceMetadataSnapshot() {
        return this.sourceMetadataSnapshot;
    }

    public long getTotalSize() {
        return Stream.concat(this.getFilesToRecoverStream(), this.filesPresentInTarget.stream()).mapToLong(StoreFileMetadata::length).sum();
    }

    public long getExistingSize() {
        return this.filesPresentInTarget.stream().mapToLong(StoreFileMetadata::length).sum();
    }

    public long getStartingSeqNo() {
        return this.startingSeqNo;
    }

    public int getTranslogOps() {
        return this.translogOps;
    }

    public boolean canRecoverSnapshotFilesFromSourceNode() {
        return this.fallbackPlan == null;
    }

    @Nullable
    public ShardRecoveryPlan getFallbackPlan() {
        return this.fallbackPlan;
    }

    private Stream<StoreFileMetadata> getFilesToRecoverStream() {
        return Stream.concat(this.snapshotFilesToRecover.snapshotFiles.stream().map(BlobStoreIndexShardSnapshot.FileInfo::metadata), this.sourceFilesToRecover.stream());
    }

    public static class SnapshotFilesToRecover
    implements Iterable<BlobStoreIndexShardSnapshot.FileInfo> {
        public static final SnapshotFilesToRecover EMPTY = new SnapshotFilesToRecover(null, null, Collections.emptyList());
        private final IndexId indexId;
        private final String repository;
        private final List<BlobStoreIndexShardSnapshot.FileInfo> snapshotFiles;

        public SnapshotFilesToRecover(IndexId indexId, String repository, List<BlobStoreIndexShardSnapshot.FileInfo> snapshotFiles) {
            this.indexId = indexId;
            this.repository = repository;
            this.snapshotFiles = snapshotFiles;
        }

        public IndexId getIndexId() {
            return this.indexId;
        }

        public String getRepository() {
            return this.repository;
        }

        public int size() {
            return this.snapshotFiles.size();
        }

        public boolean isEmpty() {
            return this.snapshotFiles.isEmpty();
        }

        public List<BlobStoreIndexShardSnapshot.FileInfo> getSnapshotFiles() {
            return this.snapshotFiles;
        }

        @Override
        public Iterator<BlobStoreIndexShardSnapshot.FileInfo> iterator() {
            return this.snapshotFiles.iterator();
        }
    }
}

