/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport.filter;

import io.netty.handler.ipfilter.IpFilterRule;
import io.netty.handler.ipfilter.IpFilterRuleType;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.regex.Pattern;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.core.SuppressForbidden;

final class PatternRule
implements IpFilterRule {
    private final Pattern ipPattern;
    private final Pattern namePattern;
    private final IpFilterRuleType ruleType;
    private final boolean localhost;
    private final String pattern;

    PatternRule(IpFilterRuleType ruleType, String pattern) {
        this.ruleType = ruleType;
        this.pattern = pattern;
        Pattern namePattern = null;
        Pattern ipPattern = null;
        boolean localhost = false;
        if (pattern != null) {
            String[] acls = pattern.split(",");
            String ip = "";
            String name = "";
            for (String c : acls) {
                if ("n:localhost".equals(c = c.trim())) {
                    localhost = true;
                    continue;
                }
                if (c.startsWith("n:")) {
                    name = PatternRule.addRule(name, c.substring(2));
                    continue;
                }
                if (!c.startsWith("i:")) continue;
                ip = PatternRule.addRule(ip, c.substring(2));
            }
            if (ip.length() != 0) {
                ipPattern = Pattern.compile(ip);
            }
            if (name.length() != 0) {
                namePattern = Pattern.compile(name);
            }
        }
        this.ipPattern = ipPattern;
        this.namePattern = namePattern;
        this.localhost = localhost;
    }

    String getPattern() {
        return this.pattern;
    }

    private static String addRule(String pattern, String rule) {
        if (rule == null || rule.length() == 0) {
            return pattern;
        }
        if (pattern.length() != 0) {
            pattern = pattern + "|";
        }
        rule = rule.replaceAll("\\.", "\\\\.");
        rule = rule.replaceAll("\\*", ".*");
        rule = rule.replaceAll("\\?", ".");
        pattern = pattern + '(' + rule + ')';
        return pattern;
    }

    private boolean isLocalhost(InetAddress address) {
        try {
            return address.isAnyLocalAddress() || address.isLoopbackAddress() || NetworkInterface.getByInetAddress(address) != null;
        }
        catch (SocketException e) {
            return false;
        }
    }

    public boolean matches(InetSocketAddress remoteAddress) {
        String format;
        InetAddress inetAddress = remoteAddress.getAddress();
        if (this.localhost && this.isLocalhost(inetAddress)) {
            return true;
        }
        if (this.ipPattern != null && this.ipPattern.matcher(format = NetworkAddress.format((InetAddress)inetAddress)).matches()) {
            return true;
        }
        return this.checkHostName(inetAddress);
    }

    @SuppressForbidden(reason="we compare the hostname of the address this is how netty3 did it and we keep it for BWC")
    private boolean checkHostName(InetAddress address) {
        return this.namePattern != null && this.namePattern.matcher(address.getHostName()).matches();
    }

    public IpFilterRuleType ruleType() {
        return this.ruleType;
    }

    boolean isLocalhost() {
        return this.localhost;
    }
}

