/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class UpgradeTransformsAction
extends ActionType<Response> {
    public static final UpgradeTransformsAction INSTANCE = new UpgradeTransformsAction();
    public static final String NAME = "cluster:admin/transform/upgrade";

    private UpgradeTransformsAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements Writeable,
    ToXContentObject {
        private final long updated;
        private final long noAction;
        private final long needsUpdate;

        public Response(StreamInput in) throws IOException {
            this.updated = in.readVLong();
            this.noAction = in.readVLong();
            this.needsUpdate = in.readVLong();
        }

        public Response(long updated, long noAction, long needsUpdate) {
            if (updated < 0L || noAction < 0L || needsUpdate < 0L) {
                throw new IllegalArgumentException("response counters must be > 0");
            }
            this.updated = updated;
            this.noAction = noAction;
            this.needsUpdate = needsUpdate;
        }

        public long getUpdated() {
            return this.updated;
        }

        public long getNoAction() {
            return this.noAction;
        }

        public long getNeedsUpdate() {
            return this.needsUpdate;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.updated);
            out.writeVLong(this.noAction);
            out.writeVLong(this.needsUpdate);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("updated", this.updated);
            builder.field("no_action", this.noAction);
            builder.field("needs_update", this.needsUpdate);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return this.updated == other.updated && this.noAction == other.noAction && this.needsUpdate == other.needsUpdate;
        }

        public int hashCode() {
            return Objects.hash(this.updated, this.noAction, this.needsUpdate);
        }

        public String toString() {
            return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final boolean dryRun;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.dryRun = in.readBoolean();
        }

        public Request(boolean dryRun, TimeValue timeout) {
            super(timeout);
            this.dryRun = dryRun;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public boolean isDryRun() {
            return this.dryRun;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.dryRun);
        }

        public int hashCode() {
            return Objects.hash(this.timeout(), this.dryRun);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return this.dryRun == other.dryRun && this.timeout().equals((Object)other.timeout());
        }
    }
}

