/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivilegesMap;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.core.security.support.Automatons;

public final class ApplicationPermission {
    public static final ApplicationPermission NONE = new ApplicationPermission(Collections.emptyList());
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final List<PermissionEntry> permissions;

    ApplicationPermission(List<Tuple<ApplicationPrivilege, Set<String>>> privilegesAndResources) {
        HashMap permissionsByPrivilege = new HashMap();
        privilegesAndResources.forEach(tup -> permissionsByPrivilege.compute((ApplicationPrivilege)tup.v1(), (appPriv, existing) -> {
            Set resourceNames = (Set)tup.v2();
            Automaton patterns = Automatons.patterns(resourceNames);
            if (existing == null) {
                return new PermissionEntry((ApplicationPrivilege)appPriv, resourceNames, patterns);
            }
            return new PermissionEntry((ApplicationPrivilege)appPriv, Sets.union((Set)((PermissionEntry)existing).resourceNames, (Set)resourceNames), Automatons.unionAndMinimize(Arrays.asList(((PermissionEntry)existing).resourceAutomaton, patterns)));
        }));
        this.permissions = Collections.unmodifiableList(new ArrayList(permissionsByPrivilege.values()));
    }

    public boolean grants(ApplicationPrivilege other, String resource) {
        Automaton resourceAutomaton = Automatons.patterns(resource);
        boolean matched = this.permissions.stream().anyMatch(e -> ((PermissionEntry)e).grants(other, resourceAutomaton));
        this.logger.trace("Permission [{}] {} grant [{} , {}]", (Object)this, (Object)(matched ? "does" : "does not"), (Object)other, (Object)resource);
        return matched;
    }

    public ResourcePrivilegesMap checkResourcePrivileges(String applicationName, Set<String> checkForResources, Set<String> checkForPrivilegeNames, Collection<ApplicationPrivilegeDescriptor> storedPrivileges) {
        ResourcePrivilegesMap.Builder resourcePrivilegesMapBuilder = ResourcePrivilegesMap.builder();
        for (String checkResource : checkForResources) {
            for (String checkPrivilegeName : checkForPrivilegeNames) {
                Set<String> nameSet = Collections.singleton(checkPrivilegeName);
                Set<ApplicationPrivilege> checkPrivileges = ApplicationPrivilege.get(applicationName, nameSet, storedPrivileges);
                this.logger.trace("Resolved privileges [{}] for [{},{}]", checkPrivileges, (Object)applicationName, nameSet);
                for (ApplicationPrivilege checkPrivilege : checkPrivileges) {
                    assert (Automatons.predicate(applicationName).test(checkPrivilege.getApplication())) : "Privilege " + checkPrivilege + " should have application " + applicationName;
                    assert (checkPrivilege.name().equals(nameSet)) : "Privilege " + checkPrivilege + " should have name " + nameSet;
                    if (this.grants(checkPrivilege, checkResource)) {
                        resourcePrivilegesMapBuilder.addResourcePrivilege(checkResource, checkPrivilegeName, Boolean.TRUE);
                        continue;
                    }
                    resourcePrivilegesMapBuilder.addResourcePrivilege(checkResource, checkPrivilegeName, Boolean.FALSE);
                }
            }
        }
        return resourcePrivilegesMapBuilder.build();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{privileges=" + this.permissions + "}";
    }

    public Set<String> getApplicationNames() {
        return this.permissions.stream().map(e -> ((PermissionEntry)e).privilege.getApplication()).collect(Collectors.toSet());
    }

    public Set<ApplicationPrivilege> getPrivileges(String application) {
        return this.permissions.stream().filter(e -> application.equals(((PermissionEntry)e).privilege.getApplication())).map(e -> ((PermissionEntry)e).privilege).collect(Collectors.toSet());
    }

    public Set<String> getResourcePatterns(ApplicationPrivilege privilege) {
        return this.permissions.stream().filter(e -> ((PermissionEntry)e).matchesPrivilege(privilege)).map(e -> ((PermissionEntry)e).resourceNames).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static class PermissionEntry {
        private final ApplicationPrivilege privilege;
        private final Predicate<String> application;
        private final Set<String> resourceNames;
        private final Automaton resourceAutomaton;

        private PermissionEntry(ApplicationPrivilege privilege, Set<String> resourceNames, Automaton resourceAutomaton) {
            this.privilege = privilege;
            this.application = Automatons.predicate(privilege.getApplication());
            this.resourceNames = resourceNames;
            this.resourceAutomaton = resourceAutomaton;
        }

        private boolean grants(ApplicationPrivilege other, Automaton resource) {
            return this.matchesPrivilege(other) && Operations.subsetOf((Automaton)resource, (Automaton)this.resourceAutomaton);
        }

        private boolean matchesPrivilege(ApplicationPrivilege other) {
            if (this.privilege.equals(other)) {
                return true;
            }
            if (!this.application.test(other.getApplication())) {
                return false;
            }
            if (Operations.isTotal((Automaton)this.privilege.getAutomaton())) {
                return true;
            }
            return !Operations.isEmpty((Automaton)this.privilege.getAutomaton()) && !Operations.isEmpty((Automaton)other.getAutomaton()) && Operations.subsetOf((Automaton)other.getAutomaton(), (Automaton)this.privilege.getAutomaton());
        }

        public String toString() {
            return this.privilege.toString() + ":" + this.resourceNames;
        }
    }
}

