/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.async;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;

public class GetAsyncResultRequest
extends ActionRequest {
    private final String id;
    private TimeValue waitForCompletionTimeout = TimeValue.MINUS_ONE;
    private TimeValue keepAlive = TimeValue.MINUS_ONE;

    public GetAsyncResultRequest(String id) {
        this.id = id;
    }

    public GetAsyncResultRequest(StreamInput in) throws IOException {
        super(in);
        this.id = in.readString();
        this.waitForCompletionTimeout = TimeValue.timeValueMillis((long)in.readLong());
        this.keepAlive = in.readTimeValue();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.id);
        out.writeLong(this.waitForCompletionTimeout.millis());
        out.writeTimeValue(this.keepAlive);
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public String getId() {
        return this.id;
    }

    public GetAsyncResultRequest setWaitForCompletionTimeout(TimeValue timeValue) {
        this.waitForCompletionTimeout = timeValue;
        return this;
    }

    public TimeValue getWaitForCompletionTimeout() {
        return this.waitForCompletionTimeout;
    }

    public GetAsyncResultRequest setKeepAlive(TimeValue timeValue) {
        this.keepAlive = timeValue;
        return this;
    }

    public TimeValue getKeepAlive() {
        return this.keepAlive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GetAsyncResultRequest request = (GetAsyncResultRequest)((Object)o);
        return Objects.equals(this.id, request.id) && this.waitForCompletionTimeout.equals((Object)request.waitForCompletionTimeout) && this.keepAlive.equals((Object)request.keepAlive);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.waitForCompletionTimeout, this.keepAlive);
    }
}

