/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.elasticsearch.Assertions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.set.Sets;

public final class ClientHelper {
    private static Pattern authorizationHeaderPattern = Pattern.compile("\\s*" + Pattern.quote("Authorization") + "\\s*", 2);
    public static final Set<String> SECURITY_HEADER_FILTERS = Sets.newHashSet((Object[])new String[]{"es-security-runas-user", "_xpack_security_authentication", "_xpack_security_secondary_authc"});
    @Deprecated
    public static final String ACTION_ORIGIN_TRANSIENT_NAME = "action.origin";
    public static final String SECURITY_ORIGIN = "security";
    public static final String WATCHER_ORIGIN = "watcher";
    public static final String ML_ORIGIN = "ml";
    public static final String INDEX_LIFECYCLE_ORIGIN = "index_lifecycle";
    public static final String MONITORING_ORIGIN = "monitoring";
    public static final String DEPRECATION_ORIGIN = "deprecation";
    public static final String PERSISTENT_TASK_ORIGIN = "persistent_tasks";
    public static final String ROLLUP_ORIGIN = "rollup";
    public static final String ENRICH_ORIGIN = "enrich";
    public static final String TRANSFORM_ORIGIN = "transform";
    public static final String ASYNC_SEARCH_ORIGIN = "async_search";
    public static final String IDP_ORIGIN = "idp";
    public static final String STACK_ORIGIN = "stack";
    public static final String SEARCHABLE_SNAPSHOTS_ORIGIN = "searchable_snapshots";
    public static final String LOGSTASH_MANAGEMENT_ORIGIN = "logstash_management";
    public static final String FLEET_ORIGIN = "fleet";

    public static void assertNoAuthorizationHeader(Map<String, String> headers) {
        if (Assertions.ENABLED) {
            for (String header : headers.keySet()) {
                if (authorizationHeaderPattern.matcher(header).find()) assert (false) : "headers contain \"Authorization\"";
            }
        }
    }

    public static Map<String, String> filterSecurityHeaders(Map<String, String> headers) {
        if (SECURITY_HEADER_FILTERS.containsAll(headers.keySet())) {
            return headers;
        }
        return Objects.requireNonNull(headers).entrySet().stream().filter(e -> SECURITY_HEADER_FILTERS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private ClientHelper() {
    }

    @Deprecated
    public static Client clientWithOrigin(Client client, String origin) {
        return new OriginSettingClient(client, origin);
    }

    public static <Request extends ActionRequest, Response extends ActionResponse> void executeAsyncWithOrigin(ThreadContext threadContext, String origin, Request request, ActionListener<Response> listener, BiConsumer<Request, ActionListener<Response>> consumer) {
        Supplier supplier = threadContext.newRestorableContext(false);
        try (ThreadContext.StoredContext ignore = threadContext.stashWithOrigin(origin);){
            consumer.accept(request, (ActionListener<Response>)new ContextPreservingActionListener(supplier, listener));
        }
    }

    public static <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response>> void executeAsyncWithOrigin(Client client, String origin, ActionType<Response> action, Request request, ActionListener<Response> listener) {
        ThreadContext threadContext = client.threadPool().getThreadContext();
        Supplier supplier = threadContext.newRestorableContext(false);
        try (ThreadContext.StoredContext ignore = threadContext.stashWithOrigin(origin);){
            client.execute(action, request, (ActionListener)new ContextPreservingActionListener(supplier, listener));
        }
    }

    public static <T extends ActionResponse> T executeWithHeaders(Map<String, String> headers, String origin, Client client, Supplier<T> supplier) {
        Map<String, String> filteredHeaders = ClientHelper.filterSecurityHeaders(headers);
        if (filteredHeaders.isEmpty()) {
            try (ThreadContext.StoredContext ignore = client.threadPool().getThreadContext().stashWithOrigin(origin);){
                ActionResponse actionResponse = (ActionResponse)supplier.get();
                return (T)actionResponse;
            }
        }
        try (ThreadContext.StoredContext ignore = client.threadPool().getThreadContext().stashContext();){
            client.threadPool().getThreadContext().copyHeaders(filteredHeaders.entrySet());
            ActionResponse actionResponse = (ActionResponse)supplier.get();
            return (T)actionResponse;
        }
    }

    public static <Request extends ActionRequest, Response extends ActionResponse> void executeWithHeadersAsync(Map<String, String> headers, String origin, Client client, ActionType<Response> action, Request request, ActionListener<Response> listener) {
        ClientHelper.executeWithHeadersAsync(headers, origin, client, action, false, request, listener);
    }

    public static <Request extends ActionRequest, Response extends ActionResponse> void executeWithHeadersAsync(Map<String, String> headers, String origin, Client client, ActionType<Response> action, boolean preserveResponseHeaders, Request request, ActionListener<Response> listener) {
        Map<String, String> filteredHeaders = ClientHelper.filterSecurityHeaders(headers);
        ThreadContext threadContext = client.threadPool().getThreadContext();
        Supplier supplier = threadContext.newRestorableContext(preserveResponseHeaders);
        if (filteredHeaders.isEmpty()) {
            try (ThreadContext.StoredContext ignore = threadContext.stashWithOrigin(origin);){
                client.execute(action, request, (ActionListener)new ContextPreservingActionListener(supplier, listener));
            }
        }
        try (ThreadContext.StoredContext ignore = ClientHelper.stashWithHeaders(threadContext, filteredHeaders);){
            client.execute(action, request, (ActionListener)new ContextPreservingActionListener(supplier, listener));
        }
    }

    private static ThreadContext.StoredContext stashWithHeaders(ThreadContext threadContext, Map<String, String> headers) {
        ThreadContext.StoredContext storedContext = threadContext.stashContext();
        ClientHelper.assertNoAuthorizationHeader(headers);
        threadContext.copyHeaders(headers.entrySet());
        return storedContext;
    }
}

