/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.agg;

import java.util.Objects;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.HistogramValuesSourceBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.querydsl.container.Sort;
import org.elasticsearch.xpack.sql.querydsl.agg.AggSource;
import org.elasticsearch.xpack.sql.querydsl.agg.GroupByKey;

public class GroupByNumericHistogram
extends GroupByKey {
    private final double interval;

    public GroupByNumericHistogram(String id, String fieldName, double interval) {
        this(id, AggSource.of(fieldName), null, null, interval);
    }

    public GroupByNumericHistogram(String id, ScriptTemplate script, double interval) {
        this(id, AggSource.of(script), null, null, interval);
    }

    private GroupByNumericHistogram(String id, AggSource aggSource, Sort.Direction direction, Sort.Missing missing, double interval) {
        super(id, aggSource, direction, missing);
        this.interval = interval;
    }

    @Override
    protected CompositeValuesSourceBuilder<?> createSourceBuilder() {
        return new HistogramValuesSourceBuilder(this.id()).interval(this.interval);
    }

    @Override
    protected GroupByKey copy(String id, AggSource source, Sort.Direction direction, Sort.Missing missing) {
        return new GroupByNumericHistogram(id, this.source(), direction, missing, this.interval);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.interval);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            GroupByNumericHistogram other = (GroupByNumericHistogram)obj;
            return this.interval == other.interval;
        }
        return false;
    }
}

