/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.tests.perftests;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.el.Expression;
import javax.servlet.jsp.el.VariableResolver;
import ognl.Ognl;
import org.apache.commons.el.ExpressionEvaluatorImpl;
import org.mvel.MVEL;
import org.mvel.tests.main.res.Base;
import org.mvel.tests.main.res.Foo;
import org.mvel.tests.perftests.JSPMapVariableResolver;
import org.mvel.tests.perftests.NativeTest;
import org.mvel.tests.perftests.PerfTest;

public class ELComparisons
implements Runnable {
    private final Base baseClass = new Base();
    public static int RUN_MVEL = 1;
    public static int RUN_OGNL = 2;
    public static int RUN_COMMONS_EL = 4;
    public static int RUN_JAVA_NATIVE = 8;
    private static int COMPILED = 0x40000000;
    private static int INTERPRETED = Integer.MIN_VALUE;
    private static int ALL = RUN_MVEL + RUN_OGNL + RUN_COMMONS_EL + RUN_JAVA_NATIVE;
    private static final int TESTNUM = 100;
    private static final int TESTITER = 2;
    private long ognlTotal = 0L;
    private long mvelTotal = 0L;
    private long commonElTotal = 0L;
    private long javaNativeTotal = 0L;
    private long groovyTotal = 0L;
    private int testFlags = 0;
    private boolean silent = false;
    private static List<PerfTest> tests = new ArrayList<PerfTest>();
    private static final Map<String, Object> variables = new HashMap<String, Object>();

    public ELComparisons() {
        variables.put("data", this.baseClass.data);
        variables.put("foo", this.baseClass.foo);
        variables.put("funMap", this.baseClass.funMap);
    }

    public void setTestFlags(int testFlags) {
        this.testFlags = testFlags;
    }

    public static void main(String[] args) throws Exception {
        ELComparisons omc = new ELComparisons();
        boolean multithreaded = false;
        boolean compiled = true;
        boolean interpreted = true;
        boolean continuous = false;
        boolean silent = false;
        long totaltime = 0L;
        int threadMax = 1;
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-continuous")) {
                    continuous = true;
                    continue;
                }
                if (args[i].equals("-threaded")) {
                    if (i + 1 == args.length) {
                        throw new RuntimeException("expected parameter for -threaded (number of threads)");
                    }
                    multithreaded = true;
                    threadMax = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-nocompiled")) {
                    compiled = false;
                    continue;
                }
                if (args[i].equals("-nointerpret")) {
                    interpreted = false;
                    continue;
                }
                if (!args[i].equals("-silent")) continue;
                silent = true;
            }
        }
        int flags = (compiled ? COMPILED : 0) + (interpreted ? INTERPRETED : 0);
        ELComparisons ognlTests = new ELComparisons();
        ognlTests.setTestFlags(flags + RUN_OGNL);
        ognlTests.setSilent(true);
        ELComparisons mvelTests = new ELComparisons();
        mvelTests.setTestFlags(flags + RUN_MVEL);
        mvelTests.setSilent(silent);
        ELComparisons commonsELTests = new ELComparisons();
        commonsELTests.setTestFlags(flags + RUN_COMMONS_EL);
        commonsELTests.setSilent(silent);
        ELComparisons nativeJavaTests = new ELComparisons();
        nativeJavaTests.setTestFlags(flags + RUN_JAVA_NATIVE);
        nativeJavaTests.setSilent(silent);
        if (multithreaded) {
            System.out.println("THREADS\tOGNL\tMVEL\tCommons-EL\tNative Java");
            for (int threadNumber = 1; threadNumber < 100; threadNumber += 5) {
                totaltime = System.currentTimeMillis();
                ognlTests.reset();
                Thread[] threads = new Thread[threadNumber];
                for (int i = 0; i < threads.length; ++i) {
                    threads[i] = new Thread(ognlTests);
                }
                for (Thread thread : threads) {
                    thread.run();
                }
                for (Thread thread : threads) {
                    thread.join();
                }
                long ognlTotals = ognlTests.getOgnlTotal();
                mvelTests.reset();
                for (int i = 0; i < threads.length; ++i) {
                    threads[i] = new Thread(mvelTests);
                }
                for (Thread thread : threads) {
                    thread.run();
                }
                for (Thread thread : threads) {
                    thread.join();
                }
                long mvelTotals = mvelTests.getMvelTotal();
                commonsELTests.reset();
                for (int i = 0; i < threads.length; ++i) {
                    threads[i] = new Thread(commonsELTests);
                }
                for (Thread thread : threads) {
                    thread.run();
                }
                for (Thread thread : threads) {
                    thread.join();
                }
                long commonsElTotals = commonsELTests.getCommonElTotal();
                nativeJavaTests.reset();
                for (int i = 0; i < threads.length; ++i) {
                    threads[i] = new Thread(nativeJavaTests);
                }
                for (Thread thread : threads) {
                    thread.run();
                }
                for (Thread thread : threads) {
                    thread.join();
                }
                long javaNativeTotals = nativeJavaTests.getJavaNativeTotal();
                totaltime = System.currentTimeMillis() - totaltime;
                System.out.println(threadNumber + "\t" + ognlTotals + "\t" + mvelTotals + "\t" + commonsElTotals + "\t" + javaNativeTotals);
            }
            System.out.println("Done.");
        } else {
            omc.setTestFlags(ALL + INTERPRETED + COMPILED);
            omc.run();
        }
    }

    @Override
    public void run() {
        try {
            for (PerfTest test : tests) {
                this.runTest(test, 100);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(PerfTest test, int count) throws Exception {
        long total;
        block52: {
            long mem;
            long time;
            int exFlags = test.getRunFlags();
            String expression = test.getExpression();
            String name = test.getName();
            if (!this.silent) {
                System.out.println("Test Name            : " + test.getName());
                System.out.println("Expression           : " + test.getExpression());
                System.out.println("Iterations           : " + count);
            }
            total = 0L;
            long[] res = new long[2];
            if ((this.testFlags & INTERPRETED) != 0) {
                Object vars;
                block51: {
                    block50: {
                        int i;
                        block49: {
                            if (!this.silent) {
                                System.out.println("Interpreted Results  :");
                            }
                            if ((this.testFlags & RUN_OGNL) != 0 && (exFlags & RUN_OGNL) != 0) {
                                try {
                                    for (int i2 = 0; i2 < count; ++i2) {
                                        Ognl.getValue((String)expression, (Object)this.baseClass);
                                    }
                                    time = System.currentTimeMillis();
                                    mem = Runtime.getRuntime().freeMemory();
                                    for (int reps = 0; reps < 2; ++reps) {
                                        for (i = 0; i < count; ++i) {
                                            Ognl.getValue((String)expression, (Object)this.baseClass);
                                        }
                                        if (reps == 0) {
                                            res[0] = total += System.currentTimeMillis() - time;
                                            continue;
                                        }
                                        long l = total * -1L;
                                        total += System.currentTimeMillis() - time - total;
                                        res[reps] = l + total;
                                    }
                                    if (!this.silent) {
                                        System.out.println("(OGNL)               : " + new BigDecimal(System.currentTimeMillis() - time).divide(new BigDecimal(2), 2, RoundingMode.HALF_UP) + "ms avg.  (mem delta: " + (Runtime.getRuntime().freeMemory() - mem) / 1024L + "kb) " + ELComparisons.resultsToString(res));
                                    }
                                }
                                catch (Exception e) {
                                    if (this.silent) break block49;
                                    System.out.println("(OGNL)               : <<COULD NOT EXECUTE>>");
                                }
                            }
                        }
                        ELComparisons e = this;
                        synchronized (e) {
                            this.ognlTotal += total;
                        }
                        total = 0L;
                        if ((this.testFlags & RUN_MVEL) != 0 && (exFlags & RUN_MVEL) != 0) {
                            try {
                                for (int i3 = 0; i3 < count; ++i3) {
                                    MVEL.eval(expression, this.baseClass);
                                }
                                time = System.currentTimeMillis();
                                mem = Runtime.getRuntime().freeMemory();
                                for (int reps = 0; reps < 2; ++reps) {
                                    for (i = 0; i < count; ++i) {
                                        MVEL.eval(expression, this.baseClass);
                                    }
                                    if (reps == 0) {
                                        res[0] = total += System.currentTimeMillis() - time;
                                        continue;
                                    }
                                    long l = total * -1L;
                                    total += System.currentTimeMillis() - time - total;
                                    res[reps] = l + total;
                                }
                                if (!this.silent) {
                                    System.out.println("(MVEL)               : " + new BigDecimal(System.currentTimeMillis() - time).divide(new BigDecimal(2), 2, RoundingMode.HALF_UP) + "ms avg.  (mem delta: " + (Runtime.getRuntime().freeMemory() - mem) / 1024L + "kb) " + ELComparisons.resultsToString(res));
                                }
                            }
                            catch (Exception e2) {
                                e2.printStackTrace();
                                if (this.silent) break block50;
                                System.out.println("(MVEL)               : <<COULD NOT EXECUTE>>");
                            }
                        }
                    }
                    ELComparisons e2 = this;
                    synchronized (e2) {
                        this.mvelTotal += total;
                    }
                    total = 0L;
                    if ((this.testFlags & RUN_COMMONS_EL) != 0 && (exFlags & RUN_COMMONS_EL) != 0) {
                        vars = new JSPMapVariableResolver(variables);
                        String commonsEx = "${" + expression + "}";
                        try {
                            for (int i = 0; i < count; ++i) {
                                new ExpressionEvaluatorImpl(true).parseExpression(commonsEx, Object.class, null).evaluate((VariableResolver)vars);
                            }
                            time = System.currentTimeMillis();
                            mem = Runtime.getRuntime().freeMemory();
                            for (int reps = 0; reps < 2; ++reps) {
                                for (int i = 0; i < count; ++i) {
                                    new ExpressionEvaluatorImpl(true).parseExpression(commonsEx, Object.class, null).evaluate((VariableResolver)vars);
                                }
                                if (reps == 0) {
                                    res[0] = total += System.currentTimeMillis() - time;
                                    continue;
                                }
                                long l = total * -1L;
                                total += System.currentTimeMillis() - time - total;
                                res[reps] = l + total;
                            }
                            if (!this.silent) {
                                System.out.println("(CommonsEL)          : " + new BigDecimal(System.currentTimeMillis() - time).divide(new BigDecimal(2), 2, RoundingMode.HALF_UP) + "ms avg.  (mem delta: " + (Runtime.getRuntime().freeMemory() - mem) / 1024L + "kb) " + ELComparisons.resultsToString(res));
                            }
                        }
                        catch (Exception e) {
                            if (this.silent) break block51;
                            System.out.println("(CommonsEL)          : <<COULD NOT EXECUTE>>");
                        }
                    }
                }
                vars = this;
                synchronized (vars) {
                    this.commonElTotal += total;
                }
            }
            if ((this.testFlags & COMPILED) != 0) {
                this.runTestCompiled(name, test.getOgnlCompiled(), test.getMvelCompiled(), test.getGroovyCompiled(), test.getElCompiled(), count, exFlags);
            }
            total = 0L;
            if ((this.testFlags & RUN_JAVA_NATIVE) != 0 && (exFlags & RUN_JAVA_NATIVE) != 0) {
                NativeTest nt = test.getJavaNative();
                try {
                    for (int i = 0; i < count; ++i) {
                        nt.run(this.baseClass, variables);
                    }
                    time = System.currentTimeMillis();
                    mem = Runtime.getRuntime().freeMemory();
                    for (int reps = 0; reps < 2; ++reps) {
                        for (int i = 0; i < count; ++i) {
                            nt.run(this.baseClass, variables);
                        }
                        if (reps == 0) {
                            res[0] = total += System.currentTimeMillis() - time;
                            continue;
                        }
                        long l = total * -1L;
                        total += System.currentTimeMillis() - time - total;
                        res[reps] = l + total;
                    }
                    if (!this.silent) {
                        System.out.println("(JavaNative)         : " + new BigDecimal(System.currentTimeMillis() - time).divide(new BigDecimal(2), 2, RoundingMode.HALF_UP) + "ms avg.  (mem delta: " + (Runtime.getRuntime().freeMemory() - mem) / 1024L + "kb) " + ELComparisons.resultsToString(res));
                    }
                }
                catch (Exception e) {
                    if (this.silent) break block52;
                    System.out.println("(JavaNative)         : <<COULD NOT EXECUTE>>");
                }
            }
        }
        ELComparisons eLComparisons = this;
        synchronized (eLComparisons) {
            this.javaNativeTotal += total;
        }
        if (!this.silent) {
            System.out.println("------------------------------------------------");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTestCompiled(String name, Object compiledOgnl, Object compiledMvel, Object compiledGroovy, Expression compiledEl, int count, int exFlags) throws Exception {
        long total;
        block36: {
            int i;
            long mem;
            long time;
            long[] res;
            block34: {
                total = 0L;
                res = new long[2];
                if (!this.silent) {
                    System.out.println("Compiled Results     :");
                }
                if ((this.testFlags & RUN_OGNL) != 0 && (exFlags & RUN_OGNL) != 0) {
                    try {
                        for (int i2 = 0; i2 < count; ++i2) {
                            Ognl.getValue((Object)compiledOgnl, (Object)this.baseClass);
                        }
                        time = System.currentTimeMillis();
                        mem = Runtime.getRuntime().freeMemory();
                        for (int reps = 0; reps < 2; ++reps) {
                            for (i = 0; i < count; ++i) {
                                Ognl.getValue((Object)compiledOgnl, (Object)this.baseClass);
                            }
                            if (reps == 0) {
                                res[0] = total += System.currentTimeMillis() - time;
                                continue;
                            }
                            long l = total * -1L;
                            total += System.currentTimeMillis() - time - total;
                            res[reps] = l + total;
                        }
                        if (!this.silent) {
                            System.out.println("(OGNL Compiled)      : " + new BigDecimal(System.currentTimeMillis() - time).divide(new BigDecimal(2), 2, RoundingMode.HALF_UP) + "ms avg.  (mem delta: " + (Runtime.getRuntime().freeMemory() - mem) / 1024L + "kb) " + ELComparisons.resultsToString(res));
                        }
                    }
                    catch (Exception e) {
                        if (this.silent) break block34;
                        System.out.println("(OGNL)               : <<COULD NOT EXECUTE>>");
                    }
                }
            }
            ELComparisons e = this;
            synchronized (e) {
                this.ognlTotal += total;
            }
            total = 0L;
            if ((this.testFlags & RUN_MVEL) != 0 && (exFlags & RUN_MVEL) != 0) {
                block35: {
                    try {
                        for (int i3 = 0; i3 < count; ++i3) {
                            MVEL.executeExpression(compiledMvel, this.baseClass);
                        }
                        time = System.currentTimeMillis();
                        mem = Runtime.getRuntime().freeMemory();
                        for (int reps = 0; reps < 2; ++reps) {
                            for (i = 0; i < count; ++i) {
                                MVEL.executeExpression(compiledMvel, this.baseClass);
                            }
                            if (reps == 0) {
                                res[0] = total += System.currentTimeMillis() - time;
                                continue;
                            }
                            long l = total * -1L;
                            total += System.currentTimeMillis() - time - total;
                            res[reps] = l + total;
                        }
                        if (!this.silent) {
                            System.out.println("(MVEL Compiled)      : " + new BigDecimal(System.currentTimeMillis() - time).divide(new BigDecimal(2), 2, RoundingMode.HALF_UP) + "ms avg.  (mem delta: " + (Runtime.getRuntime().freeMemory() - mem) / 1024L + "kb) " + ELComparisons.resultsToString(res));
                        }
                    }
                    catch (Exception e2) {
                        if (this.silent) break block35;
                        System.out.println("(MVEL)               : <<COULD NOT EXECUTE>>");
                    }
                }
                e = this;
                synchronized (e) {
                    this.mvelTotal += total;
                }
                total = 0L;
            }
            if ((this.testFlags & RUN_COMMONS_EL) != 0 && (exFlags & RUN_COMMONS_EL) != 0) {
                JSPMapVariableResolver vars = new JSPMapVariableResolver(variables);
                try {
                    for (i = 0; i < count; ++i) {
                        compiledEl.evaluate((VariableResolver)vars);
                    }
                    time = System.currentTimeMillis();
                    mem = Runtime.getRuntime().freeMemory();
                    for (int reps = 0; reps < 2; ++reps) {
                        for (int i4 = 0; i4 < count; ++i4) {
                            compiledEl.evaluate((VariableResolver)vars);
                        }
                        if (reps == 0) {
                            res[0] = total += System.currentTimeMillis() - time;
                            continue;
                        }
                        long l = total * -1L;
                        total += System.currentTimeMillis() - time - total;
                        res[reps] = l + total;
                    }
                    if (!this.silent) {
                        System.out.println("(CommonsEL Compiled) : " + new BigDecimal(System.currentTimeMillis() - time).divide(new BigDecimal(2), 2, RoundingMode.HALF_UP) + "ms avg.  (mem delta: " + (Runtime.getRuntime().freeMemory() - mem) / 1024L + "kb) " + ELComparisons.resultsToString(res));
                    }
                }
                catch (Exception e3) {
                    if (this.silent) break block36;
                    System.out.println("(CommonsEL Compiled) : <<COULD NOT EXECUTE>>");
                }
            }
        }
        ELComparisons eLComparisons = this;
        synchronized (eLComparisons) {
            this.commonElTotal += total;
        }
    }

    private static String resultsToString(long[] res) {
        StringBuffer sbuf = new StringBuffer("[");
        for (int i = 0; i < res.length; ++i) {
            sbuf.append(res[i]);
            if (i + 1 >= res.length) continue;
            sbuf.append(",");
        }
        sbuf.append("]");
        return sbuf.toString();
    }

    public long getOgnlTotal() {
        return this.ognlTotal;
    }

    public void setOgnlTotal(long ognlTotal) {
        this.ognlTotal = ognlTotal;
    }

    public long getMvelTotal() {
        return this.mvelTotal;
    }

    public void setMvelTotal(long mvelTotal) {
        this.mvelTotal = mvelTotal;
    }

    public long getCommonElTotal() {
        return this.commonElTotal;
    }

    public void setCommonElTotal(long commonElTotal) {
        this.commonElTotal = commonElTotal;
    }

    public long getJavaNativeTotal() {
        return this.javaNativeTotal;
    }

    public void setJavaNativeTotal(long javaNativeTotal) {
        this.javaNativeTotal = javaNativeTotal;
    }

    public long getGroovyTotal() {
        return this.groovyTotal;
    }

    public void setGroovyTotal(long groovyTotal) {
        this.groovyTotal = groovyTotal;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public void reset() {
        this.ognlTotal = 0L;
        this.mvelTotal = 0L;
        this.javaNativeTotal = 0L;
        this.commonElTotal = 0L;
    }

    static {
        NativeTest nt = new NativeTest(){

            @Override
            public Object run(Object baseClass, Map vars) {
                return vars.get("data");
            }
        };
        nt = new NativeTest(){

            @Override
            public Object run(Object baseClass, Map vars) {
                return ((Base)baseClass).getFoo().getBar().getName();
            }
        };
        tests.add(new PerfTest("Deep Property", "foo.bar.name", ALL, nt));
        nt = new NativeTest(){

            @Override
            public Object run(Object baseClass, Map vars) {
                return ((Foo)((Base)baseClass).funMap.get("foo")).happy();
            }
        };
        NativeTest nativeTest = new NativeTest(){

            @Override
            public Object run(Object baseClass, Map vars) {
                return 10;
            }
        };
    }
}

