/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr.uploader;

import com.flickr4java.flickr.FlickrException;
import com.flickr4java.flickr.FlickrRuntimeException;
import com.flickr4java.flickr.REST;
import com.flickr4java.flickr.Transport;
import com.flickr4java.flickr.uploader.UploadMetaData;
import com.flickr4java.flickr.uploader.UploaderResponse;
import com.flickr4java.flickr.util.IOUtilities;
import com.flickr4java.flickr.util.StringUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class Uploader {
    private static final String SERVICES_REPLACE_PATH = "/services/replace/";
    private static final String SERVICES_UPLOAD_PATH = "/services/upload/";
    private final String apiKey;
    private final String sharedSecret;
    private final Transport transport;

    public Uploader(String apiKey, String sharedSecret) {
        this.apiKey = apiKey;
        this.sharedSecret = sharedSecret;
        this.transport = new REST("up.flickr.com");
        this.transport.setResponseClass(UploaderResponse.class);
    }

    public String upload(byte[] data, UploadMetaData metaData) throws FlickrException {
        Map<String, Object> parameters = this.setUploadParameters(metaData);
        parameters.put("photo", data);
        UploaderResponse response = this.postPhoto(parameters, SERVICES_UPLOAD_PATH);
        return this.getResponseString(metaData.isAsync(), response);
    }

    public String upload(File file, UploadMetaData metaData) throws FlickrException {
        String string;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            string = this.upload(in, metaData);
        }
        catch (IOException e) {
            try {
                throw new FlickrRuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtilities.close(in);
                throw throwable;
            }
        }
        IOUtilities.close(in);
        return string;
    }

    public String upload(InputStream in, UploadMetaData metaData) throws FlickrException {
        Map<String, Object> parameters = this.setUploadParameters(metaData);
        parameters.put("photo", in);
        UploaderResponse response = this.postPhoto(parameters, SERVICES_UPLOAD_PATH);
        return this.getResponseString(metaData.isAsync(), response);
    }

    public String replace(InputStream in, String flickrId, boolean async) throws FlickrException {
        Map<String, Object> parameters = this.setReplaceParameters(flickrId, async);
        parameters.put("photo", in);
        UploaderResponse response = this.postPhoto(parameters, SERVICES_REPLACE_PATH);
        return this.getResponseString(async, response);
    }

    public String replace(byte[] data, String flickrId, boolean async) throws FlickrException {
        Map<String, Object> parameters = this.setReplaceParameters(flickrId, async);
        parameters.put("photo", data);
        UploaderResponse response = this.postPhoto(parameters, SERVICES_REPLACE_PATH);
        return this.getResponseString(async, response);
    }

    public String replace(File file, String flickrId, boolean async) throws FlickrException {
        String string;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            string = this.replace(in, flickrId, async);
        }
        catch (FileNotFoundException e) {
            try {
                throw new FlickrRuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtilities.close(in);
                throw throwable;
            }
        }
        IOUtilities.close(in);
        return string;
    }

    private UploaderResponse postPhoto(Map<String, Object> parameters, String path) throws FlickrException {
        UploaderResponse response = (UploaderResponse)this.transport.post(path, parameters, this.apiKey, this.sharedSecret, true);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        return response;
    }

    private String getResponseString(boolean async, UploaderResponse response) {
        String id = "";
        id = async ? response.getTicketId() : response.getPhotoId();
        return id;
    }

    private Map<String, Object> setUploadParameters(UploadMetaData metaData) {
        Collection<String> tags;
        String description;
        TreeMap<String, Object> parameters = new TreeMap<String, Object>();
        String filename = metaData.getFilename();
        if (filename == null || filename.equals("")) {
            filename = "image.jpg";
        }
        parameters.put("filename", filename);
        String fileMimeType = metaData.getFilemimetype();
        if (fileMimeType == null || fileMimeType.equals("")) {
            fileMimeType = "image/jpeg";
        }
        parameters.put("filemimetype", fileMimeType);
        String title = metaData.getTitle();
        if (title != null) {
            parameters.put("title", title);
        }
        if ((description = metaData.getDescription()) != null) {
            parameters.put("description", description);
        }
        if ((tags = metaData.getTags()) != null) {
            parameters.put("tags", StringUtilities.join(tags, " "));
        }
        if (metaData.isHidden() != null) {
            parameters.put("hidden", metaData.isHidden() != false ? "1" : "0");
        }
        if (metaData.getSafetyLevel() != null) {
            parameters.put("safety_level", metaData.getSafetyLevel());
        }
        if (metaData.getContentType() != null) {
            parameters.put("content_type", metaData.getContentType());
        }
        parameters.put("is_public", metaData.isPublicFlag() ? "1" : "0");
        parameters.put("is_family", metaData.isFamilyFlag() ? "1" : "0");
        parameters.put("is_friend", metaData.isFriendFlag() ? "1" : "0");
        parameters.put("async", metaData.isAsync() ? "1" : "0");
        return parameters;
    }

    private Map<String, Object> setReplaceParameters(String flickrId, boolean async) {
        TreeMap<String, Object> parameters = new TreeMap<String, Object>();
        parameters.put("async", async ? "1" : "0");
        parameters.put("photo_id", flickrId);
        return parameters;
    }

    public REST getTransport() {
        return (REST)this.transport;
    }
}

