/*
 * Decompiled with CFR 0.152.
 */
package view25d.view;

import com.jogamp.opengl.GL2;
import org.nlogo.api.Constants;
import view25d.view.VarviewWindow;

public class Observer {
    double heading;
    double pitch;
    double roll;
    double x;
    double y;
    double z;
    double rotx;
    double roty;
    double rotz;

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public Observer(double xv, double yv, double zv) {
        this.x = xv;
        this.y = yv;
        this.z = zv;
        this.heading = 0.0;
        this.pitch = 90.0;
        this.roll = 0.0;
        this.rotx = 0.0;
        this.roty = 0.0;
        this.rotz = 0.0;
    }

    public void goHome(VarviewWindow world) {
        this.x = (double)world.minPxcor + (double)(world.maxPxcor - world.minPxcor) / 2.0;
        this.y = (double)world.minPycor + (double)(world.maxPycor - world.minPycor) / 2.0;
        this.z = (double)StrictMath.max(world.worldWidth, world.worldHeight) * 1.5;
        this.heading = 0.0;
        this.pitch = 90.0;
        this.roll = 0.0;
        this.rotx = this.x;
        this.roty = this.y;
        this.rotz = 0.0;
    }

    public void applyPerspective(GL2 gl) {
        gl.glRotated(90.0, -1.0, 0.0, 0.0);
        gl.glRotated(this.heading, 0.0, 0.0, 1.0);
        gl.glRotated(this.pitch, Math.cos(Math.toRadians(this.heading)), -Math.sin(Math.toRadians(this.heading)), 0.0);
        gl.glTranslated(-1.0 * this.x, -1.0 * this.y, -1.0 * this.z);
    }

    public void applyNormal(GL2 gl) {
        gl.glRotated(-this.heading, this.x, this.y, this.z);
        double xp = this.y;
        double yp = -this.x;
        double zp = 0.0;
        gl.glRotated(this.pitch - 90.0, xp, yp, zp);
    }

    public void updatePerspectiveAngles(double delthetax, double delthetay) {
        this.orbitRight(delthetax);
        this.orbitUp(delthetay);
    }

    private void orbitRight(double delta) {
        this.heading += delta;
        if (this.heading > 360.0) {
            this.heading -= 360.0;
        }
        if (this.heading < 0.0) {
            this.heading += 360.0;
        }
        double dxy = this.dist() * StrictMath.cos(StrictMath.toRadians(this.pitch));
        double xn = -dxy * StrictMath.sin(StrictMath.toRadians(this.heading));
        double yn = -dxy * StrictMath.cos(StrictMath.toRadians(this.heading));
        this.x = this.rotx + xn;
        this.y = this.roty + yn;
    }

    private void orbitUp(double delta) {
        double newpitch = this.pitch - delta;
        double zn = this.dist() * StrictMath.sin(StrictMath.toRadians(newpitch));
        double dxy = this.dist() * StrictMath.cos(StrictMath.toRadians(newpitch));
        double xn = -dxy * StrictMath.sin(StrictMath.toRadians(this.heading));
        double yn = -dxy * StrictMath.cos(StrictMath.toRadians(this.heading));
        if (zn + this.rotz > -1.0 * this.dist() / 4.0 && newpitch < 90.0) {
            this.x = xn + this.rotx;
            this.y = yn + this.roty;
            this.z = zn + this.rotz;
            this.pitch = newpitch;
        }
    }

    public void shift(double deltax, double deltay) {
        double headingR = StrictMath.toRadians(this.heading);
        double sinH = StrictMath.sin(headingR);
        double cosH = StrictMath.cos(headingR);
        double delx = -((cosH * deltax + sinH * deltay) * 0.1);
        double dely = (sinH * deltax - cosH * deltay) * 0.1;
        this.objectiveShift(delx, dely);
    }

    public void objectiveShift(double delx, double dely) {
        this.x += delx;
        this.y += dely;
        this.rotx += delx;
        this.roty += dely;
    }

    public void zoomToDistance(double distance) {
        double odist = this.dist();
        double ratio = distance / odist;
        double xlen = this.x - this.rotx;
        double ylen = this.y - this.roty;
        double zlen = this.z - this.rotz;
        this.x = this.rotx + ratio * xlen;
        this.y = this.roty + ratio * ylen;
        this.z = this.rotz + ratio * zlen;
    }

    public void zoomby(double deltavert) {
        if (deltavert < this.dist()) {
            this.x += deltavert * this.dx();
            this.y += deltavert * this.dy();
            this.z -= deltavert * this.dz();
        }
    }

    public double dist() {
        return StrictMath.sqrt((this.rotx - this.x) * (this.rotx - this.x) + (this.roty - this.y) * (this.roty - this.y) + (this.rotz - this.z) * (this.rotz - this.z));
    }

    public double dx() {
        double value = StrictMath.cos(StrictMath.toRadians(this.pitch)) * StrictMath.sin(StrictMath.toRadians(this.heading));
        if (StrictMath.abs(value) < Constants.Infinitesimal()) {
            value = 0.0;
        }
        return value;
    }

    public double dy() {
        double value = StrictMath.cos(StrictMath.toRadians(this.pitch)) * StrictMath.cos(StrictMath.toRadians(this.heading));
        if (StrictMath.abs(value) < Constants.Infinitesimal()) {
            value = 0.0;
        }
        return value;
    }

    public double dz() {
        double value = StrictMath.sin(StrictMath.toRadians(this.pitch));
        if (StrictMath.abs(value) < Constants.Infinitesimal()) {
            value = 0.0;
        }
        return value;
    }
}

