/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.rnd;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public final class AliasMethod {
    private final Random random;
    private final int[] alias;
    private final double[] probability;

    public AliasMethod(List<Double> list) {
        this(list, new Random());
    }

    public AliasMethod(List<Double> list, Random random) {
        int n;
        if (list == null || random == null) {
            throw new NullPointerException();
        }
        if (list.size() == 0) {
            throw new IllegalArgumentException("Probability vector must be nonempty.");
        }
        this.probability = new double[list.size()];
        this.alias = new int[list.size()];
        this.random = random;
        double d = 1.0 / (double)list.size();
        list = new ArrayList<Double>(list);
        ArrayDeque<Integer> arrayDeque = new ArrayDeque<Integer>();
        ArrayDeque<Integer> arrayDeque2 = new ArrayDeque<Integer>();
        for (n = 0; n < list.size(); ++n) {
            if (list.get(n) >= d) {
                arrayDeque2.add(n);
                continue;
            }
            arrayDeque.add(n);
        }
        while (!arrayDeque.isEmpty() && !arrayDeque2.isEmpty()) {
            n = (Integer)arrayDeque.removeLast();
            int n2 = (Integer)arrayDeque2.removeLast();
            this.probability[n] = list.get(n) * (double)list.size();
            this.alias[n] = n2;
            list.set(n2, list.get(n2) + list.get(n) - d);
            if (list.get(n2) >= 1.0 / (double)list.size()) {
                arrayDeque2.add(n2);
                continue;
            }
            arrayDeque.add(n2);
        }
        while (!arrayDeque.isEmpty()) {
            this.probability[((Integer)arrayDeque.removeLast()).intValue()] = 1.0;
        }
        while (!arrayDeque2.isEmpty()) {
            this.probability[((Integer)arrayDeque2.removeLast()).intValue()] = 1.0;
        }
    }

    public int next() {
        int n = this.random.nextInt(this.probability.length);
        boolean bl = this.random.nextDouble() < this.probability[n];
        return bl ? n : this.alias[n];
    }
}

