%%
%% %CopyrightBegin%
%%
%% SPDX-License-Identifier: Apache-2.0
%%
%% Copyright Ericsson AB 2008-2025. All Rights Reserved.
%%
%% Licensed under the Apache License, Version 2.0 (the "License");
%% you may not use this file except in compliance with the License.
%% You may obtain a copy of the License at
%%
%%     http://www.apache.org/licenses/LICENSE-2.0
%%
%% Unless required by applicable law or agreed to in writing, software
%% distributed under the License is distributed on an "AS IS" BASIS,
%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%% See the License for the specific language governing permissions and
%% limitations under the License.
%%
%% %CopyrightEnd%
%% This file is generated DO NOT EDIT

-module(wxBookCtrlEvent).
-moduledoc """
This class represents the events generated by book controls (`m:wxNotebook`, `m:wxListbook`, `m:wxChoicebook`, `m:wxTreebook`, `m:wxAuiNotebook`).

The PAGE_CHANGING events are sent before the current page is changed. It allows the
program to examine the current page (which can be retrieved with `getOldSelection/1`) and to veto the page
change by calling `wxNotifyEvent:veto/1` if, for example, the current values in the controls of the old page are invalid.

The PAGE_CHANGED events are sent after the page has been changed and the program cannot
veto it any more, it just informs it about the page change.

To summarize, if the program is interested in validating the page values before allowing
the user to change it, it should process the PAGE_CHANGING event, otherwise PAGE_CHANGED
is probably enough. In any case, it is probably unnecessary to process both events at once.

See:
* `m:wxNotebook`

* `m:wxListbook`

* `m:wxChoicebook`

* `m:wxTreebook`

* `m:wxToolbook`

* `m:wxAuiNotebook`

This class is derived, and can use functions, from:

* `m:wxNotifyEvent`

* `m:wxCommandEvent`

* `m:wxEvent`

wxWidgets docs: [wxBookCtrlEvent](https://docs.wxwidgets.org/3.2/classwx_book_ctrl_event.html)
""".
-include("wxe.hrl").
-export([getOldSelection/1,getSelection/1,setOldSelection/2,setSelection/2]).

%% inherited exports
-export([allow/1,getClientData/1,getExtraLong/1,getId/1,getInt/1,getSkipped/1,
  getString/1,getTimestamp/1,isAllowed/1,isChecked/1,isCommandEvent/1,
  isSelection/1,parent_class/1,resumePropagation/2,setInt/2,setString/2,
  shouldPropagate/1,skip/1,skip/2,stopPropagation/1,veto/1]).

-type wxBookCtrlEvent() :: wx:wx_object().
-include("wx.hrl").
-type wxBookCtrlEventType() :: 'command_notebook_page_changed' | 'command_notebook_page_changing' | 'choicebook_page_changed' | 'choicebook_page_changing' | 'treebook_page_changed' | 'treebook_page_changing' | 'toolbook_page_changed' | 'toolbook_page_changing' | 'listbook_page_changed' | 'listbook_page_changing'.
-export_type([wxBookCtrlEvent/0, wxBookCtrl/0, wxBookCtrlEventType/0]).
-doc false.
parent_class(wxNotifyEvent) -> true;
parent_class(wxCommandEvent) -> true;
parent_class(wxEvent) -> true;
parent_class(_Class) -> erlang:error({badtype, ?MODULE}).

-doc """
Returns the page that was selected before the change, `wxNOT\_FOUND` if none was
selected.
""".
-spec getOldSelection(This) -> integer() when
	This::wxBookCtrlEvent().
getOldSelection(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxBookCtrlEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxBookCtrlEvent_GetOldSelection),
  wxe_util:rec(?wxBookCtrlEvent_GetOldSelection).

-doc """
Returns the currently selected page, or `wxNOT\_FOUND` if none was selected.

Note: under Windows, `getSelection/1` will return the same value as `getOldSelection/1` when called from the `EVT_BOOKCTRL_PAGE_CHANGING`
handler and not the page which is going to be selected.
""".
-spec getSelection(This) -> integer() when
	This::wxBookCtrlEvent().
getSelection(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxBookCtrlEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxBookCtrlEvent_GetSelection),
  wxe_util:rec(?wxBookCtrlEvent_GetSelection).

-doc "Sets the id of the page selected before the change.".
-spec setOldSelection(This, Page) -> 'ok' when
	This::wxBookCtrlEvent(), Page::integer().
setOldSelection(#wx_ref{type=ThisT}=This,Page)
 when is_integer(Page) ->
  ?CLASS(ThisT,wxBookCtrlEvent),
  wxe_util:queue_cmd(This,Page,?get_env(),?wxBookCtrlEvent_SetOldSelection).

-doc "Sets the selection member variable.".
-spec setSelection(This, Page) -> 'ok' when
	This::wxBookCtrlEvent(), Page::integer().
setSelection(#wx_ref{type=ThisT}=This,Page)
 when is_integer(Page) ->
  ?CLASS(ThisT,wxBookCtrlEvent),
  wxe_util:queue_cmd(This,Page,?get_env(),?wxBookCtrlEvent_SetSelection).

 %% From wxNotifyEvent
-doc false.
veto(This) -> wxNotifyEvent:veto(This).
-doc false.
isAllowed(This) -> wxNotifyEvent:isAllowed(This).
-doc false.
allow(This) -> wxNotifyEvent:allow(This).
 %% From wxCommandEvent
-doc false.
setString(This,String) -> wxCommandEvent:setString(This,String).
-doc false.
setInt(This,IntCommand) -> wxCommandEvent:setInt(This,IntCommand).
-doc false.
isSelection(This) -> wxCommandEvent:isSelection(This).
-doc false.
isChecked(This) -> wxCommandEvent:isChecked(This).
-doc false.
getString(This) -> wxCommandEvent:getString(This).
-doc false.
getInt(This) -> wxCommandEvent:getInt(This).
-doc false.
getExtraLong(This) -> wxCommandEvent:getExtraLong(This).
-doc false.
getClientData(This) -> wxCommandEvent:getClientData(This).
 %% From wxEvent
-doc false.
stopPropagation(This) -> wxEvent:stopPropagation(This).
-doc false.
skip(This, Options) -> wxEvent:skip(This, Options).
-doc false.
skip(This) -> wxEvent:skip(This).
-doc false.
shouldPropagate(This) -> wxEvent:shouldPropagate(This).
-doc false.
resumePropagation(This,PropagationLevel) -> wxEvent:resumePropagation(This,PropagationLevel).
-doc false.
isCommandEvent(This) -> wxEvent:isCommandEvent(This).
-doc false.
getTimestamp(This) -> wxEvent:getTimestamp(This).
-doc false.
getSkipped(This) -> wxEvent:getSkipped(This).
-doc false.
getId(This) -> wxEvent:getId(This).
