/*
    Copyright 2016-2022 melonDS team

    This file is part of melonDS.

    melonDS is free software: you can redistribute it and/or modify it under
    the terms of the GNU General Public License as published by the Free
    Software Foundation, either version 3 of the License, or (at your option)
    any later version.

    melonDS is distributed in the hope that it will be useful, but WITHOUT ANY
    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
    FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with melonDS. If not, see http://www.gnu.org/licenses/.
*/

INSTRFUNC_PROTO(ARMInstrTable[4096]) =
{
    // 0000 0000 0000
    A_AND_REG_LSL_IMM, A_AND_REG_LSL_REG, A_AND_REG_LSR_IMM, A_AND_REG_LSR_REG,
    A_AND_REG_ASR_IMM, A_AND_REG_ASR_REG, A_AND_REG_ROR_IMM, A_AND_REG_ROR_REG,
    A_AND_REG_LSL_IMM, A_MUL, A_AND_REG_LSR_IMM, A_STRH_POST_REG,
    A_AND_REG_ASR_IMM, A_LDRD_POST_REG, A_AND_REG_ROR_IMM, A_STRD_POST_REG,

    // 0000 0001 0000
    A_AND_REG_LSL_IMM_S, A_AND_REG_LSL_REG_S, A_AND_REG_LSR_IMM_S, A_AND_REG_LSR_REG_S,
    A_AND_REG_ASR_IMM_S, A_AND_REG_ASR_REG_S, A_AND_REG_ROR_IMM_S, A_AND_REG_ROR_REG_S,
    A_AND_REG_LSL_IMM_S, A_MUL, A_AND_REG_LSR_IMM_S, A_LDRH_POST_REG,
    A_AND_REG_ASR_IMM_S, A_LDRSB_POST_REG, A_AND_REG_ROR_IMM_S, A_LDRSH_POST_REG,

    // 0000 0010 0000
    A_EOR_REG_LSL_IMM, A_EOR_REG_LSL_REG, A_EOR_REG_LSR_IMM, A_EOR_REG_LSR_REG,
    A_EOR_REG_ASR_IMM, A_EOR_REG_ASR_REG, A_EOR_REG_ROR_IMM, A_EOR_REG_ROR_REG,
    A_EOR_REG_LSL_IMM, A_MLA, A_EOR_REG_LSR_IMM, A_UNK,
    A_EOR_REG_ASR_IMM, A_UNK, A_EOR_REG_ROR_IMM, A_UNK,

    // 0000 0011 0000
    A_EOR_REG_LSL_IMM_S, A_EOR_REG_LSL_REG_S, A_EOR_REG_LSR_IMM_S, A_EOR_REG_LSR_REG_S,
    A_EOR_REG_ASR_IMM_S, A_EOR_REG_ASR_REG_S, A_EOR_REG_ROR_IMM_S, A_EOR_REG_ROR_REG_S,
    A_EOR_REG_LSL_IMM_S, A_MLA, A_EOR_REG_ROR_IMM_S, A_UNK,
    A_EOR_REG_ASR_IMM_S, A_UNK, A_EOR_REG_ROR_IMM_S, A_UNK,

    // 0000 0100 0000
    A_SUB_REG_LSL_IMM, A_SUB_REG_LSL_REG, A_SUB_REG_LSR_IMM, A_SUB_REG_LSR_REG,
    A_SUB_REG_ASR_IMM, A_SUB_REG_ASR_REG, A_SUB_REG_ROR_IMM, A_SUB_REG_ROR_REG,
    A_SUB_REG_LSL_IMM, A_UNK, A_SUB_REG_LSR_IMM, A_STRH_POST_IMM,
    A_SUB_REG_ASR_IMM, A_LDRD_POST_IMM, A_SUB_REG_ROR_IMM, A_STRD_POST_IMM,

    // 0000 0101 0000
    A_SUB_REG_LSL_IMM_S, A_SUB_REG_LSL_REG_S, A_SUB_REG_LSR_IMM_S, A_SUB_REG_LSR_REG_S,
    A_SUB_REG_ASR_IMM_S, A_SUB_REG_ASR_REG_S, A_SUB_REG_ROR_IMM_S, A_SUB_REG_ROR_REG_S,
    A_SUB_REG_LSL_IMM_S, A_UNK, A_SUB_REG_LSR_IMM_S, A_LDRH_POST_IMM,
    A_SUB_REG_ASR_IMM_S, A_LDRSB_POST_IMM, A_SUB_REG_ROR_IMM_S, A_LDRSH_POST_IMM,

    // 0000 0110 0000
    A_RSB_REG_LSL_IMM, A_RSB_REG_LSL_REG, A_RSB_REG_LSR_IMM, A_RSB_REG_LSR_REG,
    A_RSB_REG_ASR_IMM, A_RSB_REG_ASR_REG, A_RSB_REG_ROR_IMM, A_RSB_REG_ROR_REG,
    A_RSB_REG_LSL_IMM, A_UNK, A_RSB_REG_LSR_IMM, A_UNK,
    A_RSB_REG_ASR_IMM, A_UNK, A_RSB_REG_ROR_IMM, A_UNK,

    // 0000 0111 0000
    A_RSB_REG_LSL_IMM_S, A_RSB_REG_LSL_REG_S, A_RSB_REG_LSR_IMM_S, A_RSB_REG_LSR_REG_S,
    A_RSB_REG_ASR_IMM_S, A_RSB_REG_ASR_REG_S, A_RSB_REG_ROR_IMM_S, A_RSB_REG_ROR_REG_S,
    A_RSB_REG_LSL_IMM_S, A_UNK, A_RSB_REG_LSR_IMM_S, A_UNK,
    A_RSB_REG_ASR_IMM_S, A_UNK, A_RSB_REG_ROR_IMM_S, A_UNK,

    // 0000 1000 0000
    A_ADD_REG_LSL_IMM, A_ADD_REG_LSL_REG, A_ADD_REG_LSR_IMM, A_ADD_REG_LSR_REG,
    A_ADD_REG_ASR_IMM, A_ADD_REG_ASR_REG, A_ADD_REG_ROR_IMM, A_ADD_REG_ROR_REG,
    A_ADD_REG_LSL_IMM, A_UMULL, A_ADD_REG_LSR_IMM, A_STRH_POST_REG,
    A_ADD_REG_ASR_IMM, A_LDRD_POST_REG, A_ADD_REG_ROR_IMM, A_STRD_POST_REG,

    // 0000 1001 0000
    A_ADD_REG_LSL_IMM_S, A_ADD_REG_LSL_REG_S, A_ADD_REG_LSR_IMM_S, A_ADD_REG_LSR_REG_S,
    A_ADD_REG_ASR_IMM_S, A_ADD_REG_ASR_REG_S, A_ADD_REG_ROR_IMM_S, A_ADD_REG_ROR_REG_S,
    A_ADD_REG_LSL_IMM_S, A_UMULL, A_ADD_REG_LSR_IMM_S, A_LDRH_POST_REG,
    A_ADD_REG_ASR_IMM_S, A_LDRSB_POST_REG, A_ADD_REG_ROR_IMM_S, A_LDRSH_POST_REG,

    // 0000 1010 0000
    A_ADC_REG_LSL_IMM, A_ADC_REG_LSL_REG, A_ADC_REG_LSR_IMM, A_ADC_REG_LSR_REG,
    A_ADC_REG_ASR_IMM, A_ADC_REG_ASR_REG, A_ADC_REG_ROR_IMM, A_ADC_REG_ROR_REG,
    A_ADC_REG_LSL_IMM, A_UMLAL, A_ADC_REG_LSR_IMM, A_UNK,
    A_ADC_REG_ASR_IMM, A_UNK, A_ADC_REG_ROR_IMM, A_UNK,

    // 0000 1011 0000
    A_ADC_REG_LSL_IMM_S, A_ADC_REG_LSL_REG_S, A_ADC_REG_LSR_IMM_S, A_ADC_REG_LSR_REG_S,
    A_ADC_REG_ASR_IMM_S, A_ADC_REG_ASR_REG_S, A_ADC_REG_ROR_IMM_S, A_ADC_REG_ROR_REG_S,
    A_ADC_REG_LSL_IMM_S, A_UMLAL, A_ADC_REG_LSR_IMM_S, A_UNK,
    A_ADC_REG_ASR_IMM_S, A_UNK, A_ADC_REG_ROR_IMM_S, A_UNK,

    // 0000 1100 0000
    A_SBC_REG_LSL_IMM, A_SBC_REG_LSL_REG, A_SBC_REG_LSR_IMM, A_SBC_REG_LSR_REG,
    A_SBC_REG_ASR_IMM, A_SBC_REG_ASR_REG, A_SBC_REG_ROR_IMM, A_SBC_REG_ROR_REG,
    A_SBC_REG_LSL_IMM, A_SMULL, A_SBC_REG_LSR_IMM, A_STRH_POST_IMM,
    A_SBC_REG_ASR_IMM, A_LDRD_POST_IMM, A_SBC_REG_ROR_IMM, A_STRD_POST_IMM,

    // 0000 1101 0000
    A_SBC_REG_LSL_IMM_S, A_SBC_REG_LSL_REG_S, A_SBC_REG_LSR_IMM_S, A_SBC_REG_LSR_REG_S,
    A_SBC_REG_ASR_IMM_S, A_SBC_REG_ASR_REG_S, A_SBC_REG_ROR_IMM_S, A_SBC_REG_ROR_REG_S,
    A_SBC_REG_LSL_IMM_S, A_SMULL, A_SBC_REG_LSR_IMM_S, A_LDRH_POST_IMM,
    A_SBC_REG_ASR_IMM_S, A_LDRSB_POST_IMM, A_SBC_REG_ROR_IMM_S, A_LDRSH_POST_IMM,

    // 0000 1110 0000
    A_RSC_REG_LSL_IMM, A_RSC_REG_LSL_REG, A_RSC_REG_LSR_IMM, A_RSC_REG_LSR_REG,
    A_RSC_REG_ASR_IMM, A_RSC_REG_ASR_REG, A_RSC_REG_ROR_IMM, A_RSC_REG_ROR_REG,
    A_RSC_REG_LSL_IMM, A_SMLAL, A_RSC_REG_LSR_IMM, A_UNK,
    A_RSC_REG_ASR_IMM, A_UNK, A_RSC_REG_ROR_IMM, A_UNK,

    // 0000 1111 0000
    A_RSC_REG_LSL_IMM_S, A_RSC_REG_LSL_REG_S, A_RSC_REG_LSR_IMM_S, A_RSC_REG_LSR_REG_S,
    A_RSC_REG_ASR_IMM_S, A_RSC_REG_ASR_REG_S, A_RSC_REG_ROR_IMM_S, A_RSC_REG_ROR_REG_S,
    A_RSC_REG_LSL_IMM_S, A_SMLAL, A_RSC_REG_LSR_IMM_S, A_UNK,
    A_RSC_REG_ASR_IMM_S, A_UNK, A_RSC_REG_ROR_IMM_S, A_UNK,



    // 0001 0000 0000
    A_MRS, A_UNK, A_UNK, A_UNK,
    A_UNK, A_QADD, A_UNK, A_UNK,
    A_SMLAxy, A_SWP, A_SMLAxy, A_STRH_REG,
    A_SMLAxy, A_LDRD_REG, A_SMLAxy, A_STRD_REG,

    // 0001 0001 0000
    A_TST_REG_LSL_IMM, A_TST_REG_LSL_REG, A_TST_REG_LSR_IMM, A_TST_REG_LSR_REG,
    A_TST_REG_ASR_IMM, A_TST_REG_ASR_REG, A_TST_REG_ROR_IMM, A_TST_REG_ROR_REG,
    A_TST_REG_LSL_IMM, A_UNK, A_TST_REG_LSR_IMM, A_LDRH_REG,
    A_TST_REG_ASR_IMM, A_LDRSB_REG, A_TST_REG_ROR_IMM, A_LDRSH_REG,

    // 0001 0010 0000
    A_MSR_REG, A_BX, A_UNK, A_BLX_REG,
    A_UNK, A_QSUB, A_UNK, A_UNK,
    A_SMLAWy, A_UNK, A_SMULWy, A_STRH_REG,
    A_SMLAWy, A_LDRD_REG, A_SMULWy, A_STRD_REG,

    // 0001 0011 0000
    A_TEQ_REG_LSL_IMM, A_TEQ_REG_LSL_REG, A_TEQ_REG_LSR_IMM, A_TEQ_REG_LSR_REG,
    A_TEQ_REG_ASR_IMM, A_TEQ_REG_ASR_REG, A_TEQ_REG_ROR_IMM, A_TEQ_REG_ROR_REG,
    A_TEQ_REG_LSL_IMM, A_UNK, A_TEQ_REG_LSR_IMM, A_LDRH_REG,
    A_TEQ_REG_ASR_IMM, A_LDRSB_REG, A_TEQ_REG_ROR_IMM, A_LDRSH_REG,

    // 0001 0100 0000
    A_MRS, A_UNK, A_UNK, A_UNK,
    A_UNK, A_QDADD, A_UNK, A_UNK,
    A_SMLALxy, A_SWPB, A_SMLALxy, A_STRH_IMM,
    A_SMLALxy, A_LDRD_IMM, A_SMLALxy, A_STRD_IMM,

    // 0001 0101 0000
    A_CMP_REG_LSL_IMM, A_CMP_REG_LSL_REG, A_CMP_REG_LSR_IMM, A_CMP_REG_LSR_REG,
    A_CMP_REG_ASR_IMM, A_CMP_REG_ASR_REG, A_CMP_REG_ROR_IMM, A_CMP_REG_ROR_REG,
    A_CMP_REG_LSL_IMM, A_UNK, A_CMP_REG_LSR_IMM, A_LDRH_IMM,
    A_CMP_REG_ASR_IMM, A_LDRSB_IMM, A_CMP_REG_ROR_IMM, A_LDRSH_IMM,

    // 0001 0110 0000
    A_MSR_REG, A_CLZ, A_UNK, A_UNK,
    A_UNK, A_QDSUB, A_UNK, A_UNK,
    A_SMULxy, A_UNK, A_SMULxy, A_STRH_IMM,
    A_SMULxy, A_LDRD_IMM, A_SMULxy, A_STRD_IMM,

    // 0001 0111 0000
    A_CMN_REG_LSL_IMM, A_CMN_REG_LSL_REG, A_CMN_REG_LSR_IMM, A_CMN_REG_LSR_REG,
    A_CMN_REG_ASR_IMM, A_CMN_REG_ASR_REG, A_CMN_REG_ROR_IMM, A_CMN_REG_ROR_REG,
    A_CMN_REG_LSL_IMM, A_UNK, A_CMN_REG_LSR_IMM, A_LDRH_IMM,
    A_CMN_REG_ASR_IMM, A_LDRSB_IMM, A_CMN_REG_ROR_IMM, A_LDRSH_IMM,

    // 0001 1000 0000
    A_ORR_REG_LSL_IMM, A_ORR_REG_LSL_REG, A_ORR_REG_LSR_IMM, A_ORR_REG_LSR_REG,
    A_ORR_REG_ASR_IMM, A_ORR_REG_ASR_REG, A_ORR_REG_ROR_IMM, A_ORR_REG_ROR_REG,
    A_ORR_REG_LSL_IMM, A_UNK, A_ORR_REG_LSR_IMM, A_STRH_REG,
    A_ORR_REG_ASR_IMM, A_LDRD_REG, A_ORR_REG_ROR_IMM, A_STRD_REG,

    // 0001 1001 0000
    A_ORR_REG_LSL_IMM_S, A_ORR_REG_LSL_REG_S, A_ORR_REG_LSR_IMM_S, A_ORR_REG_LSR_REG_S,
    A_ORR_REG_ASR_IMM_S, A_ORR_REG_ASR_REG_S, A_ORR_REG_ROR_IMM_S, A_ORR_REG_ROR_REG_S,
    A_ORR_REG_LSL_IMM_S, A_UNK, A_ORR_REG_LSR_IMM_S, A_LDRH_REG,
    A_ORR_REG_ASR_IMM_S, A_LDRSB_REG, A_ORR_REG_ROR_IMM_S, A_LDRSH_REG,

    // 0001 1010 0000
    A_MOV_REG_LSL_IMM_DBG, A_MOV_REG_LSL_REG, A_MOV_REG_LSR_IMM, A_MOV_REG_LSR_REG,
    A_MOV_REG_ASR_IMM, A_MOV_REG_ASR_REG, A_MOV_REG_ROR_IMM, A_MOV_REG_ROR_REG,
    A_MOV_REG_LSL_IMM, A_UNK, A_MOV_REG_LSR_IMM, A_STRH_REG,
    A_MOV_REG_ASR_IMM, A_LDRD_REG, A_MOV_REG_ROR_IMM, A_STRD_REG,

    // 0001 1011 0000
    A_MOV_REG_LSL_IMM_S, A_MOV_REG_LSL_REG_S, A_MOV_REG_LSR_IMM_S, A_MOV_REG_LSR_REG_S,
    A_MOV_REG_ASR_IMM_S, A_MOV_REG_ASR_REG_S, A_MOV_REG_ROR_IMM_S, A_MOV_REG_ROR_REG_S,
    A_MOV_REG_LSL_IMM_S, A_UNK, A_MOV_REG_LSR_IMM_S, A_LDRH_REG,
    A_MOV_REG_ASR_IMM_S, A_LDRSB_REG, A_MOV_REG_ROR_IMM_S, A_LDRSH_REG,

    // 0001 1100 0000
    A_BIC_REG_LSL_IMM, A_BIC_REG_LSL_REG, A_BIC_REG_LSR_IMM, A_BIC_REG_LSR_REG,
    A_BIC_REG_ASR_IMM, A_BIC_REG_ASR_REG, A_BIC_REG_ROR_IMM, A_BIC_REG_ROR_REG,
    A_BIC_REG_LSL_IMM, A_UNK, A_BIC_REG_LSR_IMM, A_STRH_IMM,
    A_BIC_REG_ASR_IMM, A_LDRD_IMM, A_BIC_REG_ROR_IMM, A_STRD_IMM,

    // 0001 1101 0000
    A_BIC_REG_LSL_IMM_S, A_BIC_REG_LSL_REG_S, A_BIC_REG_LSR_IMM_S, A_BIC_REG_LSR_REG_S,
    A_BIC_REG_ASR_IMM_S, A_BIC_REG_ASR_REG_S, A_BIC_REG_ROR_IMM_S, A_BIC_REG_ROR_REG_S,
    A_BIC_REG_LSL_IMM_S, A_UNK, A_BIC_REG_LSR_IMM_S, A_LDRH_IMM,
    A_BIC_REG_ASR_IMM_S, A_LDRSB_IMM, A_BIC_REG_ROR_IMM_S, A_LDRSH_IMM,

    // 0001 1110 0000
    A_MVN_REG_LSL_IMM, A_MVN_REG_LSL_REG, A_MVN_REG_LSR_IMM, A_MVN_REG_LSR_REG,
    A_MVN_REG_ASR_IMM, A_MVN_REG_ASR_REG, A_MVN_REG_ROR_IMM, A_MVN_REG_ROR_REG,
    A_MVN_REG_LSL_IMM, A_UNK, A_MVN_REG_LSR_IMM, A_STRH_IMM,
    A_MVN_REG_ASR_IMM, A_LDRD_IMM, A_MVN_REG_ROR_IMM, A_STRD_IMM,

    // 0001 1111 0000
    A_MVN_REG_LSL_IMM_S, A_MVN_REG_LSL_REG_S, A_MVN_REG_LSR_IMM_S, A_MVN_REG_LSR_REG_S,
    A_MVN_REG_ASR_IMM_S, A_MVN_REG_ASR_REG_S, A_MVN_REG_ROR_IMM_S, A_MVN_REG_ROR_REG_S,
    A_MVN_REG_LSL_IMM_S, A_UNK, A_MVN_REG_LSR_IMM_S, A_LDRH_IMM,
    A_MVN_REG_ASR_IMM_S, A_LDRSB_IMM, A_MVN_REG_ROR_IMM_S, A_LDRSH_IMM,



    // 0010 0000 0000
    A_AND_IMM, A_AND_IMM, A_AND_IMM, A_AND_IMM,
    A_AND_IMM, A_AND_IMM, A_AND_IMM, A_AND_IMM,
    A_AND_IMM, A_AND_IMM, A_AND_IMM, A_AND_IMM,
    A_AND_IMM, A_AND_IMM, A_AND_IMM, A_AND_IMM,

    // 0010 0001 0000
    A_AND_IMM_S, A_AND_IMM_S, A_AND_IMM_S, A_AND_IMM_S,
    A_AND_IMM_S, A_AND_IMM_S, A_AND_IMM_S, A_AND_IMM_S,
    A_AND_IMM_S, A_AND_IMM_S, A_AND_IMM_S, A_AND_IMM_S,
    A_AND_IMM_S, A_AND_IMM_S, A_AND_IMM_S, A_AND_IMM_S,

    // 0010 0010 0000
    A_EOR_IMM, A_EOR_IMM, A_EOR_IMM, A_EOR_IMM,
    A_EOR_IMM, A_EOR_IMM, A_EOR_IMM, A_EOR_IMM,
    A_EOR_IMM, A_EOR_IMM, A_EOR_IMM, A_EOR_IMM,
    A_EOR_IMM, A_EOR_IMM, A_EOR_IMM, A_EOR_IMM,

    // 0010 0011 0000
    A_EOR_IMM_S, A_EOR_IMM_S, A_EOR_IMM_S, A_EOR_IMM_S,
    A_EOR_IMM_S, A_EOR_IMM_S, A_EOR_IMM_S, A_EOR_IMM_S,
    A_EOR_IMM_S, A_EOR_IMM_S, A_EOR_IMM_S, A_EOR_IMM_S,
    A_EOR_IMM_S, A_EOR_IMM_S, A_EOR_IMM_S, A_EOR_IMM_S,

    // 0010 0100 0000
    A_SUB_IMM, A_SUB_IMM, A_SUB_IMM, A_SUB_IMM,
    A_SUB_IMM, A_SUB_IMM, A_SUB_IMM, A_SUB_IMM,
    A_SUB_IMM, A_SUB_IMM, A_SUB_IMM, A_SUB_IMM,
    A_SUB_IMM, A_SUB_IMM, A_SUB_IMM, A_SUB_IMM,

    // 0010 0101 0000
    A_SUB_IMM_S, A_SUB_IMM_S, A_SUB_IMM_S, A_SUB_IMM_S,
    A_SUB_IMM_S, A_SUB_IMM_S, A_SUB_IMM_S, A_SUB_IMM_S,
    A_SUB_IMM_S, A_SUB_IMM_S, A_SUB_IMM_S, A_SUB_IMM_S,
    A_SUB_IMM_S, A_SUB_IMM_S, A_SUB_IMM_S, A_SUB_IMM_S,

    // 0010 0110 0000
    A_RSB_IMM, A_RSB_IMM, A_RSB_IMM, A_RSB_IMM,
    A_RSB_IMM, A_RSB_IMM, A_RSB_IMM, A_RSB_IMM,
    A_RSB_IMM, A_RSB_IMM, A_RSB_IMM, A_RSB_IMM,
    A_RSB_IMM, A_RSB_IMM, A_RSB_IMM, A_RSB_IMM,

    // 0010 0111 0000
    A_RSB_IMM_S, A_RSB_IMM_S, A_RSB_IMM_S, A_RSB_IMM_S,
    A_RSB_IMM_S, A_RSB_IMM_S, A_RSB_IMM_S, A_RSB_IMM_S,
    A_RSB_IMM_S, A_RSB_IMM_S, A_RSB_IMM_S, A_RSB_IMM_S,
    A_RSB_IMM_S, A_RSB_IMM_S, A_RSB_IMM_S, A_RSB_IMM_S,

    // 0010 1000 0000
    A_ADD_IMM, A_ADD_IMM, A_ADD_IMM, A_ADD_IMM,
    A_ADD_IMM, A_ADD_IMM, A_ADD_IMM, A_ADD_IMM,
    A_ADD_IMM, A_ADD_IMM, A_ADD_IMM, A_ADD_IMM,
    A_ADD_IMM, A_ADD_IMM, A_ADD_IMM, A_ADD_IMM,

    // 0010 1001 0000
    A_ADD_IMM_S, A_ADD_IMM_S, A_ADD_IMM_S, A_ADD_IMM_S,
    A_ADD_IMM_S, A_ADD_IMM_S, A_ADD_IMM_S, A_ADD_IMM_S,
    A_ADD_IMM_S, A_ADD_IMM_S, A_ADD_IMM_S, A_ADD_IMM_S,
    A_ADD_IMM_S, A_ADD_IMM_S, A_ADD_IMM_S, A_ADD_IMM_S,

    // 0010 1010 0000
    A_ADC_IMM, A_ADC_IMM, A_ADC_IMM, A_ADC_IMM,
    A_ADC_IMM, A_ADC_IMM, A_ADC_IMM, A_ADC_IMM,
    A_ADC_IMM, A_ADC_IMM, A_ADC_IMM, A_ADC_IMM,
    A_ADC_IMM, A_ADC_IMM, A_ADC_IMM, A_ADC_IMM,

    // 0010 1011 0000
    A_ADC_IMM_S, A_ADC_IMM_S, A_ADC_IMM_S, A_ADC_IMM_S,
    A_ADC_IMM_S, A_ADC_IMM_S, A_ADC_IMM_S, A_ADC_IMM_S,
    A_ADC_IMM_S, A_ADC_IMM_S, A_ADC_IMM_S, A_ADC_IMM_S,
    A_ADC_IMM_S, A_ADC_IMM_S, A_ADC_IMM_S, A_ADC_IMM_S,

    // 0010 1100 0000
    A_SBC_IMM, A_SBC_IMM, A_SBC_IMM, A_SBC_IMM,
    A_SBC_IMM, A_SBC_IMM, A_SBC_IMM, A_SBC_IMM,
    A_SBC_IMM, A_SBC_IMM, A_SBC_IMM, A_SBC_IMM,
    A_SBC_IMM, A_SBC_IMM, A_SBC_IMM, A_SBC_IMM,

    // 0010 1101 0000
    A_SBC_IMM_S, A_SBC_IMM_S, A_SBC_IMM_S, A_SBC_IMM_S,
    A_SBC_IMM_S, A_SBC_IMM_S, A_SBC_IMM_S, A_SBC_IMM_S,
    A_SBC_IMM_S, A_SBC_IMM_S, A_SBC_IMM_S, A_SBC_IMM_S,
    A_SBC_IMM_S, A_SBC_IMM_S, A_SBC_IMM_S, A_SBC_IMM_S,

    // 0010 1110 0000
    A_RSC_IMM, A_RSC_IMM, A_RSC_IMM, A_RSC_IMM,
    A_RSC_IMM, A_RSC_IMM, A_RSC_IMM, A_RSC_IMM,
    A_RSC_IMM, A_RSC_IMM, A_RSC_IMM, A_RSC_IMM,
    A_RSC_IMM, A_RSC_IMM, A_RSC_IMM, A_RSC_IMM,

    // 0010 1111 0000
    A_RSC_IMM_S, A_RSC_IMM_S, A_RSC_IMM_S, A_RSC_IMM_S,
    A_RSC_IMM_S, A_RSC_IMM_S, A_RSC_IMM_S, A_RSC_IMM_S,
    A_RSC_IMM_S, A_RSC_IMM_S, A_RSC_IMM_S, A_RSC_IMM_S,
    A_RSC_IMM_S, A_RSC_IMM_S, A_RSC_IMM_S, A_RSC_IMM_S,



    // 0011 0000 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 0011 0001 0000
    A_TST_IMM, A_TST_IMM, A_TST_IMM, A_TST_IMM,
    A_TST_IMM, A_TST_IMM, A_TST_IMM, A_TST_IMM,
    A_TST_IMM, A_TST_IMM, A_TST_IMM, A_TST_IMM,
    A_TST_IMM, A_TST_IMM, A_TST_IMM, A_TST_IMM,

    // 0011 0010 0000
    A_MSR_IMM, A_MSR_IMM, A_MSR_IMM, A_MSR_IMM,
    A_MSR_IMM, A_MSR_IMM, A_MSR_IMM, A_MSR_IMM,
    A_MSR_IMM, A_MSR_IMM, A_MSR_IMM, A_MSR_IMM,
    A_MSR_IMM, A_MSR_IMM, A_MSR_IMM, A_MSR_IMM,

    // 0011 0011 0000
    A_TEQ_IMM, A_TEQ_IMM, A_TEQ_IMM, A_TEQ_IMM,
    A_TEQ_IMM, A_TEQ_IMM, A_TEQ_IMM, A_TEQ_IMM,
    A_TEQ_IMM, A_TEQ_IMM, A_TEQ_IMM, A_TEQ_IMM,
    A_TEQ_IMM, A_TEQ_IMM, A_TEQ_IMM, A_TEQ_IMM,

    // 0011 0100 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 0011 0101 0000
    A_CMP_IMM, A_CMP_IMM, A_CMP_IMM, A_CMP_IMM,
    A_CMP_IMM, A_CMP_IMM, A_CMP_IMM, A_CMP_IMM,
    A_CMP_IMM, A_CMP_IMM, A_CMP_IMM, A_CMP_IMM,
    A_CMP_IMM, A_CMP_IMM, A_CMP_IMM, A_CMP_IMM,

    // 0011 0110 0000
    A_MSR_IMM, A_MSR_IMM, A_MSR_IMM, A_MSR_IMM,
    A_MSR_IMM, A_MSR_IMM, A_MSR_IMM, A_MSR_IMM,
    A_MSR_IMM, A_MSR_IMM, A_MSR_IMM, A_MSR_IMM,
    A_MSR_IMM, A_MSR_IMM, A_MSR_IMM, A_MSR_IMM,

    // 0011 0111 0000
    A_CMN_IMM, A_CMN_IMM, A_CMN_IMM, A_CMN_IMM,
    A_CMN_IMM, A_CMN_IMM, A_CMN_IMM, A_CMN_IMM,
    A_CMN_IMM, A_CMN_IMM, A_CMN_IMM, A_CMN_IMM,
    A_CMN_IMM, A_CMN_IMM, A_CMN_IMM, A_CMN_IMM,

    // 0011 1000 0000
    A_ORR_IMM, A_ORR_IMM, A_ORR_IMM, A_ORR_IMM,
    A_ORR_IMM, A_ORR_IMM, A_ORR_IMM, A_ORR_IMM,
    A_ORR_IMM, A_ORR_IMM, A_ORR_IMM, A_ORR_IMM,
    A_ORR_IMM, A_ORR_IMM, A_ORR_IMM, A_ORR_IMM,

    // 0011 1001 0000
    A_ORR_IMM_S, A_ORR_IMM_S, A_ORR_IMM_S, A_ORR_IMM_S,
    A_ORR_IMM_S, A_ORR_IMM_S, A_ORR_IMM_S, A_ORR_IMM_S,
    A_ORR_IMM_S, A_ORR_IMM_S, A_ORR_IMM_S, A_ORR_IMM_S,
    A_ORR_IMM_S, A_ORR_IMM_S, A_ORR_IMM_S, A_ORR_IMM_S,

    // 0011 1010 0000
    A_MOV_IMM, A_MOV_IMM, A_MOV_IMM, A_MOV_IMM,
    A_MOV_IMM, A_MOV_IMM, A_MOV_IMM, A_MOV_IMM,
    A_MOV_IMM, A_MOV_IMM, A_MOV_IMM, A_MOV_IMM,
    A_MOV_IMM, A_MOV_IMM, A_MOV_IMM, A_MOV_IMM,

    // 0011 1011 0000
    A_MOV_IMM_S, A_MOV_IMM_S, A_MOV_IMM_S, A_MOV_IMM_S,
    A_MOV_IMM_S, A_MOV_IMM_S, A_MOV_IMM_S, A_MOV_IMM_S,
    A_MOV_IMM_S, A_MOV_IMM_S, A_MOV_IMM_S, A_MOV_IMM_S,
    A_MOV_IMM_S, A_MOV_IMM_S, A_MOV_IMM_S, A_MOV_IMM_S,

    // 0011 1100 0000
    A_BIC_IMM, A_BIC_IMM, A_BIC_IMM, A_BIC_IMM,
    A_BIC_IMM, A_BIC_IMM, A_BIC_IMM, A_BIC_IMM,
    A_BIC_IMM, A_BIC_IMM, A_BIC_IMM, A_BIC_IMM,
    A_BIC_IMM, A_BIC_IMM, A_BIC_IMM, A_BIC_IMM,

    // 0011 1101 0000
    A_BIC_IMM_S, A_BIC_IMM_S, A_BIC_IMM_S, A_BIC_IMM_S,
    A_BIC_IMM_S, A_BIC_IMM_S, A_BIC_IMM_S, A_BIC_IMM_S,
    A_BIC_IMM_S, A_BIC_IMM_S, A_BIC_IMM_S, A_BIC_IMM_S,
    A_BIC_IMM_S, A_BIC_IMM_S, A_BIC_IMM_S, A_BIC_IMM_S,

    // 0011 1110 0000
    A_MVN_IMM, A_MVN_IMM, A_MVN_IMM, A_MVN_IMM,
    A_MVN_IMM, A_MVN_IMM, A_MVN_IMM, A_MVN_IMM,
    A_MVN_IMM, A_MVN_IMM, A_MVN_IMM, A_MVN_IMM,
    A_MVN_IMM, A_MVN_IMM, A_MVN_IMM, A_MVN_IMM,

    // 0011 1111 0000
    A_MVN_IMM_S, A_MVN_IMM_S, A_MVN_IMM_S, A_MVN_IMM_S,
    A_MVN_IMM_S, A_MVN_IMM_S, A_MVN_IMM_S, A_MVN_IMM_S,
    A_MVN_IMM_S, A_MVN_IMM_S, A_MVN_IMM_S, A_MVN_IMM_S,
    A_MVN_IMM_S, A_MVN_IMM_S, A_MVN_IMM_S, A_MVN_IMM_S,



    // 0100 0000 0000
    A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM,
    A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM,
    A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM,
    A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM,

    // 0100 0001 0000
    A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM,
    A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM,
    A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM,
    A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM,

    // 0100 0010 0000
    A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM,
    A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM,
    A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM,
    A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM,

    // 0100 0011 0000
    A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM,
    A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM,
    A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM,
    A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM,

    // 0100 0100 0000
    A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM,
    A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM,
    A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM,
    A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM,

    // 0100 0101 0000
    A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM,
    A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM,
    A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM,
    A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM,

    // 0100 0110 0000
    A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM,
    A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM,
    A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM,
    A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM,

    // 0100 0111 0000
    A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM,
    A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM,
    A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM,
    A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM,

    // 0100 1000 0000
    A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM,
    A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM,
    A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM,
    A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM,

    // 0100 1001 0000
    A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM,
    A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM,
    A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM,
    A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM,

    // 0100 1010 0000
    A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM,
    A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM,
    A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM,
    A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM, A_STR_POST_IMM,

    // 0100 1011 0000
    A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM,
    A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM,
    A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM,
    A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM, A_LDR_POST_IMM,

    // 0100 1100 0000
    A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM,
    A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM,
    A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM,
    A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM,

    // 0100 1101 0000
    A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM,
    A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM,
    A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM,
    A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM,

    // 0100 1110 0000
    A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM,
    A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM,
    A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM,
    A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM, A_STRB_POST_IMM,

    // 0100 1111 0000
    A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM,
    A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM,
    A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM,
    A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM, A_LDRB_POST_IMM,



    // 0101 0000 0000
    A_STR_IMM, A_STR_IMM, A_STR_IMM, A_STR_IMM,
    A_STR_IMM, A_STR_IMM, A_STR_IMM, A_STR_IMM,
    A_STR_IMM, A_STR_IMM, A_STR_IMM, A_STR_IMM,
    A_STR_IMM, A_STR_IMM, A_STR_IMM, A_STR_IMM,

    // 0101 0001 0000
    A_LDR_IMM, A_LDR_IMM, A_LDR_IMM, A_LDR_IMM,
    A_LDR_IMM, A_LDR_IMM, A_LDR_IMM, A_LDR_IMM,
    A_LDR_IMM, A_LDR_IMM, A_LDR_IMM, A_LDR_IMM,
    A_LDR_IMM, A_LDR_IMM, A_LDR_IMM, A_LDR_IMM,

    // 0101 0010 0000
    A_STR_IMM, A_STR_IMM, A_STR_IMM, A_STR_IMM,
    A_STR_IMM, A_STR_IMM, A_STR_IMM, A_STR_IMM,
    A_STR_IMM, A_STR_IMM, A_STR_IMM, A_STR_IMM,
    A_STR_IMM, A_STR_IMM, A_STR_IMM, A_STR_IMM,

    // 0101 0011 0000
    A_LDR_IMM, A_LDR_IMM, A_LDR_IMM, A_LDR_IMM,
    A_LDR_IMM, A_LDR_IMM, A_LDR_IMM, A_LDR_IMM,
    A_LDR_IMM, A_LDR_IMM, A_LDR_IMM, A_LDR_IMM,
    A_LDR_IMM, A_LDR_IMM, A_LDR_IMM, A_LDR_IMM,

    // 0101 0100 0000
    A_STRB_IMM, A_STRB_IMM, A_STRB_IMM, A_STRB_IMM,
    A_STRB_IMM, A_STRB_IMM, A_STRB_IMM, A_STRB_IMM,
    A_STRB_IMM, A_STRB_IMM, A_STRB_IMM, A_STRB_IMM,
    A_STRB_IMM, A_STRB_IMM, A_STRB_IMM, A_STRB_IMM,

    // 0101 0101 0000
    A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM,
    A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM,
    A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM,
    A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM,

    // 0101 0110 0000
    A_STRB_IMM, A_STRB_IMM, A_STRB_IMM, A_STRB_IMM,
    A_STRB_IMM, A_STRB_IMM, A_STRB_IMM, A_STRB_IMM,
    A_STRB_IMM, A_STRB_IMM, A_STRB_IMM, A_STRB_IMM,
    A_STRB_IMM, A_STRB_IMM, A_STRB_IMM, A_STRB_IMM,

    // 0101 0111 0000
    A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM,
    A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM,
    A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM,
    A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM,

    // 0101 1000 0000
    A_STR_IMM, A_STR_IMM, A_STR_IMM, A_STR_IMM,
    A_STR_IMM, A_STR_IMM, A_STR_IMM, A_STR_IMM,
    A_STR_IMM, A_STR_IMM, A_STR_IMM, A_STR_IMM,
    A_STR_IMM, A_STR_IMM, A_STR_IMM, A_STR_IMM,

    // 0101 1001 0000
    A_LDR_IMM, A_LDR_IMM, A_LDR_IMM, A_LDR_IMM,
    A_LDR_IMM, A_LDR_IMM, A_LDR_IMM, A_LDR_IMM,
    A_LDR_IMM, A_LDR_IMM, A_LDR_IMM, A_LDR_IMM,
    A_LDR_IMM, A_LDR_IMM, A_LDR_IMM, A_LDR_IMM,

    // 0101 1010 0000
    A_STR_IMM, A_STR_IMM, A_STR_IMM, A_STR_IMM,
    A_STR_IMM, A_STR_IMM, A_STR_IMM, A_STR_IMM,
    A_STR_IMM, A_STR_IMM, A_STR_IMM, A_STR_IMM,
    A_STR_IMM, A_STR_IMM, A_STR_IMM, A_STR_IMM,

    // 0101 1011 0000
    A_LDR_IMM, A_LDR_IMM, A_LDR_IMM, A_LDR_IMM,
    A_LDR_IMM, A_LDR_IMM, A_LDR_IMM, A_LDR_IMM,
    A_LDR_IMM, A_LDR_IMM, A_LDR_IMM, A_LDR_IMM,
    A_LDR_IMM, A_LDR_IMM, A_LDR_IMM, A_LDR_IMM,

    // 0101 1100 0000
    A_STRB_IMM, A_STRB_IMM, A_STRB_IMM, A_STRB_IMM,
    A_STRB_IMM, A_STRB_IMM, A_STRB_IMM, A_STRB_IMM,
    A_STRB_IMM, A_STRB_IMM, A_STRB_IMM, A_STRB_IMM,
    A_STRB_IMM, A_STRB_IMM, A_STRB_IMM, A_STRB_IMM,

    // 0101 1101 0000
    A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM,
    A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM,
    A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM,
    A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM,

    // 0101 1110 0000
    A_STRB_IMM, A_STRB_IMM, A_STRB_IMM, A_STRB_IMM,
    A_STRB_IMM, A_STRB_IMM, A_STRB_IMM, A_STRB_IMM,
    A_STRB_IMM, A_STRB_IMM, A_STRB_IMM, A_STRB_IMM,
    A_STRB_IMM, A_STRB_IMM, A_STRB_IMM, A_STRB_IMM,

    // 0101 1111 0000
    A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM,
    A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM,
    A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM,
    A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM, A_LDRB_IMM,



    // 0110 0000 0000
    A_STR_POST_REG_LSL, A_UNK, A_STR_POST_REG_LSR, A_UNK,
    A_STR_POST_REG_ASR, A_UNK, A_STR_POST_REG_ROR, A_UNK,
    A_STR_POST_REG_LSL, A_UNK, A_STR_POST_REG_LSR, A_UNK,
    A_STR_POST_REG_ASR, A_UNK, A_STR_POST_REG_ROR, A_UNK,

    // 0110 0001 0000
    A_LDR_POST_REG_LSL, A_UNK, A_LDR_POST_REG_LSR, A_UNK,
    A_LDR_POST_REG_ASR, A_UNK, A_LDR_POST_REG_ROR, A_UNK,
    A_LDR_POST_REG_LSL, A_UNK, A_LDR_POST_REG_LSR, A_UNK,
    A_LDR_POST_REG_ASR, A_UNK, A_LDR_POST_REG_ROR, A_UNK,

    // 0110 0010 0000
    A_STR_POST_REG_LSL, A_UNK, A_STR_POST_REG_LSR, A_UNK,
    A_STR_POST_REG_ASR, A_UNK, A_STR_POST_REG_ROR, A_UNK,
    A_STR_POST_REG_LSL, A_UNK, A_STR_POST_REG_LSR, A_UNK,
    A_STR_POST_REG_ASR, A_UNK, A_STR_POST_REG_ROR, A_UNK,

    // 0110 0011 0000
    A_LDR_POST_REG_LSL, A_UNK, A_LDR_POST_REG_LSR, A_UNK,
    A_LDR_POST_REG_ASR, A_UNK, A_LDR_POST_REG_ROR, A_UNK,
    A_LDR_POST_REG_LSL, A_UNK, A_LDR_POST_REG_LSR, A_UNK,
    A_LDR_POST_REG_ASR, A_UNK, A_LDR_POST_REG_ROR, A_UNK,

    // 0110 0100 0000
    A_STRB_POST_REG_LSL, A_UNK, A_STRB_POST_REG_LSR, A_UNK,
    A_STRB_POST_REG_ASR, A_UNK, A_STRB_POST_REG_ROR, A_UNK,
    A_STRB_POST_REG_LSL, A_UNK, A_STRB_POST_REG_LSR, A_UNK,
    A_STRB_POST_REG_ASR, A_UNK, A_STRB_POST_REG_ROR, A_UNK,

    // 0110 0101 0000
    A_LDRB_POST_REG_LSL, A_UNK, A_LDRB_POST_REG_LSR, A_UNK,
    A_LDRB_POST_REG_ASR, A_UNK, A_LDRB_POST_REG_ROR, A_UNK,
    A_LDRB_POST_REG_LSL, A_UNK, A_LDRB_POST_REG_LSR, A_UNK,
    A_LDRB_POST_REG_ASR, A_UNK, A_LDRB_POST_REG_ROR, A_UNK,

    // 0110 0110 0000
    A_STRB_POST_REG_LSL, A_UNK, A_STRB_POST_REG_LSR, A_UNK,
    A_STRB_POST_REG_ASR, A_UNK, A_STRB_POST_REG_ROR, A_UNK,
    A_STRB_POST_REG_LSL, A_UNK, A_STRB_POST_REG_LSR, A_UNK,
    A_STRB_POST_REG_ASR, A_UNK, A_STRB_POST_REG_ROR, A_UNK,

    // 0110 0111 0000
    A_LDRB_POST_REG_LSL, A_UNK, A_LDRB_POST_REG_LSR, A_UNK,
    A_LDRB_POST_REG_ASR, A_UNK, A_LDRB_POST_REG_ROR, A_UNK,
    A_LDRB_POST_REG_LSL, A_UNK, A_LDRB_POST_REG_LSR, A_UNK,
    A_LDRB_POST_REG_ASR, A_UNK, A_LDRB_POST_REG_ROR, A_UNK,

    // 0110 1000 0000
    A_STR_POST_REG_LSL, A_UNK, A_STR_POST_REG_LSR, A_UNK,
    A_STR_POST_REG_ASR, A_UNK, A_STR_POST_REG_ROR, A_UNK,
    A_STR_POST_REG_LSL, A_UNK, A_STR_POST_REG_LSR, A_UNK,
    A_STR_POST_REG_ASR, A_UNK, A_STR_POST_REG_ROR, A_UNK,

    // 0110 1001 0000
    A_LDR_POST_REG_LSL, A_UNK, A_LDR_POST_REG_LSR, A_UNK,
    A_LDR_POST_REG_ASR, A_UNK, A_LDR_POST_REG_ROR, A_UNK,
    A_LDR_POST_REG_LSL, A_UNK, A_LDR_POST_REG_LSR, A_UNK,
    A_LDR_POST_REG_ASR, A_UNK, A_LDR_POST_REG_ROR, A_UNK,

    // 0110 1010 0000
    A_STR_POST_REG_LSL, A_UNK, A_STR_POST_REG_LSR, A_UNK,
    A_STR_POST_REG_ASR, A_UNK, A_STR_POST_REG_ROR, A_UNK,
    A_STR_POST_REG_LSL, A_UNK, A_STR_POST_REG_LSR, A_UNK,
    A_STR_POST_REG_ASR, A_UNK, A_STR_POST_REG_ROR, A_UNK,

    // 0110 1011 0000
    A_LDR_POST_REG_LSL, A_UNK, A_LDR_POST_REG_LSR, A_UNK,
    A_LDR_POST_REG_ASR, A_UNK, A_LDR_POST_REG_ROR, A_UNK,
    A_LDR_POST_REG_LSL, A_UNK, A_LDR_POST_REG_LSR, A_UNK,
    A_LDR_POST_REG_ASR, A_UNK, A_LDR_POST_REG_ROR, A_UNK,

    // 0110 1100 0000
    A_STRB_POST_REG_LSL, A_UNK, A_STRB_POST_REG_LSR, A_UNK,
    A_STRB_POST_REG_ASR, A_UNK, A_STRB_POST_REG_ROR, A_UNK,
    A_STRB_POST_REG_LSL, A_UNK, A_STRB_POST_REG_LSR, A_UNK,
    A_STRB_POST_REG_ASR, A_UNK, A_STRB_POST_REG_ROR, A_UNK,

    // 0110 1101 0000
    A_LDRB_POST_REG_LSL, A_UNK, A_LDRB_POST_REG_LSR, A_UNK,
    A_LDRB_POST_REG_ASR, A_UNK, A_LDRB_POST_REG_ROR, A_UNK,
    A_LDRB_POST_REG_LSL, A_UNK, A_LDRB_POST_REG_LSR, A_UNK,
    A_LDRB_POST_REG_ASR, A_UNK, A_LDRB_POST_REG_ROR, A_UNK,

    // 0110 1110 0000
    A_STRB_POST_REG_LSL, A_UNK, A_STRB_POST_REG_LSR, A_UNK,
    A_STRB_POST_REG_ASR, A_UNK, A_STRB_POST_REG_ROR, A_UNK,
    A_STRB_POST_REG_LSL, A_UNK, A_STRB_POST_REG_LSR, A_UNK,
    A_STRB_POST_REG_ASR, A_UNK, A_STRB_POST_REG_ROR, A_UNK,

    // 0110 1111 0000
    A_LDRB_POST_REG_LSL, A_UNK, A_LDRB_POST_REG_LSR, A_UNK,
    A_LDRB_POST_REG_ASR, A_UNK, A_LDRB_POST_REG_ROR, A_UNK,
    A_LDRB_POST_REG_LSL, A_UNK, A_LDRB_POST_REG_LSR, A_UNK,
    A_LDRB_POST_REG_ASR, A_UNK, A_LDRB_POST_REG_ROR, A_UNK,



    // 0111 0000 0000
    A_STR_REG_LSL, A_UNK, A_STR_REG_LSR, A_UNK,
    A_STR_REG_ASR, A_UNK, A_STR_REG_ROR, A_UNK,
    A_STR_REG_LSL, A_UNK, A_STR_REG_LSR, A_UNK,
    A_STR_REG_ASR, A_UNK, A_STR_REG_ROR, A_UNK,

    // 0111 0001 0000
    A_LDR_REG_LSL, A_UNK, A_LDR_REG_LSR, A_UNK,
    A_LDR_REG_ASR, A_UNK, A_LDR_REG_ROR, A_UNK,
    A_LDR_REG_LSL, A_UNK, A_LDR_REG_LSR, A_UNK,
    A_LDR_REG_ASR, A_UNK, A_LDR_REG_ROR, A_UNK,

    // 0111 0010 0000
    A_STR_REG_LSL, A_UNK, A_STR_REG_LSR, A_UNK,
    A_STR_REG_ASR, A_UNK, A_STR_REG_ROR, A_UNK,
    A_STR_REG_LSL, A_UNK, A_STR_REG_LSR, A_UNK,
    A_STR_REG_ASR, A_UNK, A_STR_REG_ROR, A_UNK,

    // 0111 0011 0000
    A_LDR_REG_LSL, A_UNK, A_LDR_REG_LSR, A_UNK,
    A_LDR_REG_ASR, A_UNK, A_LDR_REG_ROR, A_UNK,
    A_LDR_REG_LSL, A_UNK, A_LDR_REG_LSR, A_UNK,
    A_LDR_REG_ASR, A_UNK, A_LDR_REG_ROR, A_UNK,

    // 0111 0100 0000
    A_STRB_REG_LSL, A_UNK, A_STRB_REG_LSR, A_UNK,
    A_STRB_REG_ASR, A_UNK, A_STRB_REG_ROR, A_UNK,
    A_STRB_REG_LSL, A_UNK, A_STRB_REG_LSR, A_UNK,
    A_STRB_REG_ASR, A_UNK, A_STRB_REG_ROR, A_UNK,

    // 0111 0101 0000
    A_LDRB_REG_LSL, A_UNK, A_LDRB_REG_LSR, A_UNK,
    A_LDRB_REG_ASR, A_UNK, A_LDRB_REG_ROR, A_UNK,
    A_LDRB_REG_LSL, A_UNK, A_LDRB_REG_LSR, A_UNK,
    A_LDRB_REG_ASR, A_UNK, A_LDRB_REG_ROR, A_UNK,

    // 0111 0110 0000
    A_STRB_REG_LSL, A_UNK, A_STRB_REG_LSR, A_UNK,
    A_STRB_REG_ASR, A_UNK, A_STRB_REG_ROR, A_UNK,
    A_STRB_REG_LSL, A_UNK, A_STRB_REG_LSR, A_UNK,
    A_STRB_REG_ASR, A_UNK, A_STRB_REG_ROR, A_UNK,

    // 0111 0111 0000
    A_LDRB_REG_LSL, A_UNK, A_LDRB_REG_LSR, A_UNK,
    A_LDRB_REG_ASR, A_UNK, A_LDRB_REG_ROR, A_UNK,
    A_LDRB_REG_LSL, A_UNK, A_LDRB_REG_LSR, A_UNK,
    A_LDRB_REG_ASR, A_UNK, A_LDRB_REG_ROR, A_UNK,

    // 0111 1000 0000
    A_STR_REG_LSL, A_UNK, A_STR_REG_LSR, A_UNK,
    A_STR_REG_ASR, A_UNK, A_STR_REG_ROR, A_UNK,
    A_STR_REG_LSL, A_UNK, A_STR_REG_LSR, A_UNK,
    A_STR_REG_ASR, A_UNK, A_STR_REG_ROR, A_UNK,

    // 0111 1001 0000
    A_LDR_REG_LSL, A_UNK, A_LDR_REG_LSR, A_UNK,
    A_LDR_REG_ASR, A_UNK, A_LDR_REG_ROR, A_UNK,
    A_LDR_REG_LSL, A_UNK, A_LDR_REG_LSR, A_UNK,
    A_LDR_REG_ASR, A_UNK, A_LDR_REG_ROR, A_UNK,

    // 0111 1010 0000
    A_STR_REG_LSL, A_UNK, A_STR_REG_LSR, A_UNK,
    A_STR_REG_ASR, A_UNK, A_STR_REG_ROR, A_UNK,
    A_STR_REG_LSL, A_UNK, A_STR_REG_LSR, A_UNK,
    A_STR_REG_ASR, A_UNK, A_STR_REG_ROR, A_UNK,

    // 0111 1011 0000
    A_LDR_REG_LSL, A_UNK, A_LDR_REG_LSR, A_UNK,
    A_LDR_REG_ASR, A_UNK, A_LDR_REG_ROR, A_UNK,
    A_LDR_REG_LSL, A_UNK, A_LDR_REG_LSR, A_UNK,
    A_LDR_REG_ASR, A_UNK, A_LDR_REG_ROR, A_UNK,

    // 0111 1100 0000
    A_STRB_REG_LSL, A_UNK, A_STRB_REG_LSR, A_UNK,
    A_STRB_REG_ASR, A_UNK, A_STRB_REG_ROR, A_UNK,
    A_STRB_REG_LSL, A_UNK, A_STRB_REG_LSR, A_UNK,
    A_STRB_REG_ASR, A_UNK, A_STRB_REG_ROR, A_UNK,

    // 0111 1101 0000
    A_LDRB_REG_LSL, A_UNK, A_LDRB_REG_LSR, A_UNK,
    A_LDRB_REG_ASR, A_UNK, A_LDRB_REG_ROR, A_UNK,
    A_LDRB_REG_LSL, A_UNK, A_LDRB_REG_LSR, A_UNK,
    A_LDRB_REG_ASR, A_UNK, A_LDRB_REG_ROR, A_UNK,

    // 0111 1110 0000
    A_STRB_REG_LSL, A_UNK, A_STRB_REG_LSR, A_UNK,
    A_STRB_REG_ASR, A_UNK, A_STRB_REG_ROR, A_UNK,
    A_STRB_REG_LSL, A_UNK, A_STRB_REG_LSR, A_UNK,
    A_STRB_REG_ASR, A_UNK, A_STRB_REG_ROR, A_UNK,

    // 0111 1111 0000
    A_LDRB_REG_LSL, A_UNK, A_LDRB_REG_LSR, A_UNK,
    A_LDRB_REG_ASR, A_UNK, A_LDRB_REG_ROR, A_UNK,
    A_LDRB_REG_LSL, A_UNK, A_LDRB_REG_LSR, A_UNK,
    A_LDRB_REG_ASR, A_UNK, A_LDRB_REG_ROR, A_UNK,



    // 1000 0000 0000
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,

    // 1000 0001 0000
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,

    // 1000 0010 0000
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,

    // 1000 0011 0000
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,

    // 1000 0100 0000
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,

    // 1000 0101 0000
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,

    // 1000 0110 0000
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,

    // 1000 0111 0000
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,

    // 1000 1000 0000
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,

    // 1000 1001 0000
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,

    // 1000 1010 0000
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,

    // 1000 1011 0000
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,

    // 1000 1100 0000
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,

    // 1000 1101 0000
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,

    // 1000 1110 0000
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,

    // 1000 1111 0000
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,



    // 1001 0000 0000
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,

    // 1001 0001 0000
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,

    // 1001 0010 0000
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,

    // 1001 0011 0000
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,

    // 1001 0100 0000
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,

    // 1001 0101 0000
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,

    // 1001 0110 0000
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,

    // 1001 0111 0000
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,

    // 1001 1000 0000
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,

    // 1001 1001 0000
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,

    // 1001 1010 0000
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,

    // 1001 1011 0000
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,

    // 1001 1100 0000
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,

    // 1001 1101 0000
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,

    // 1001 1110 0000
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,
    A_STM, A_STM, A_STM, A_STM,

    // 1001 1111 0000
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,
    A_LDM, A_LDM, A_LDM, A_LDM,



    // 1010 0000 0000
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,

    // 1010 0001 0000
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,

    // 1010 0010 0000
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,

    // 1010 0011 0000
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,

    // 1010 0100 0000
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,

    // 1010 0101 0000
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,

    // 1010 0110 0000
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,

    // 1010 0111 0000
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,

    // 1010 1000 0000
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,

    // 1010 1001 0000
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,

    // 1010 1010 0000
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,

    // 1010 1011 0000
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,

    // 1010 1100 0000
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,

    // 1010 1101 0000
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,

    // 1010 1110 0000
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,

    // 1010 1111 0000
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,
    A_B, A_B, A_B, A_B,



    // 1011 0000 0000
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,

    // 1011 0001 0000
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,

    // 1011 0010 0000
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,

    // 1011 0011 0000
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,

    // 1011 0100 0000
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,

    // 1011 0101 0000
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,

    // 1011 0110 0000
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,

    // 1011 0111 0000
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,

    // 1011 1000 0000
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,

    // 1011 1001 0000
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,

    // 1011 1010 0000
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,

    // 1011 1011 0000
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,

    // 1011 1100 0000
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,

    // 1011 1101 0000
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,

    // 1011 1110 0000
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,

    // 1011 1111 0000
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,
    A_BL, A_BL, A_BL, A_BL,



    // 1100 0000 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 1100 0001 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 1100 0010 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 1100 0011 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 1100 0100 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 1100 0101 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 1100 0110 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 1100 0111 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 1100 1000 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 1100 1001 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 1100 1010 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 1100 1011 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 1100 1100 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 1100 1101 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 1100 1110 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 1100 1111 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,



    // 1101 0000 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 1101 0001 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 1101 0010 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 1101 0011 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 1101 0100 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 1101 0101 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 1101 0110 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 1101 0111 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 1101 1000 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 1101 1001 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 1101 1010 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 1101 1011 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 1101 1100 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 1101 1101 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 1101 1110 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,

    // 1101 1111 0000
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,
    A_UNK, A_UNK, A_UNK, A_UNK,



    // 1110 0000 0000
    A_UNK, A_MCR, A_UNK, A_MCR,
    A_UNK, A_MCR, A_UNK, A_MCR,
    A_UNK, A_MCR, A_UNK, A_MCR,
    A_UNK, A_MCR, A_UNK, A_MCR,

    // 1110 0001 0000
    A_UNK, A_MRC, A_UNK, A_MRC,
    A_UNK, A_MRC, A_UNK, A_MRC,
    A_UNK, A_MRC, A_UNK, A_MRC,
    A_UNK, A_MRC, A_UNK, A_MRC,

    // 1110 0010 0000
    A_UNK, A_MCR, A_UNK, A_MCR,
    A_UNK, A_MCR, A_UNK, A_MCR,
    A_UNK, A_MCR, A_UNK, A_MCR,
    A_UNK, A_MCR, A_UNK, A_MCR,

    // 1110 0011 0000
    A_UNK, A_MRC, A_UNK, A_MRC,
    A_UNK, A_MRC, A_UNK, A_MRC,
    A_UNK, A_MRC, A_UNK, A_MRC,
    A_UNK, A_MRC, A_UNK, A_MRC,

    // 1110 0100 0000
    A_UNK, A_MCR, A_UNK, A_MCR,
    A_UNK, A_MCR, A_UNK, A_MCR,
    A_UNK, A_MCR, A_UNK, A_MCR,
    A_UNK, A_MCR, A_UNK, A_MCR,

    // 1110 0101 0000
    A_UNK, A_MRC, A_UNK, A_MRC,
    A_UNK, A_MRC, A_UNK, A_MRC,
    A_UNK, A_MRC, A_UNK, A_MRC,
    A_UNK, A_MRC, A_UNK, A_MRC,

    // 1110 0110 0000
    A_UNK, A_MCR, A_UNK, A_MCR,
    A_UNK, A_MCR, A_UNK, A_MCR,
    A_UNK, A_MCR, A_UNK, A_MCR,
    A_UNK, A_MCR, A_UNK, A_MCR,

    // 1110 0111 0000
    A_UNK, A_MRC, A_UNK, A_MRC,
    A_UNK, A_MRC, A_UNK, A_MRC,
    A_UNK, A_MRC, A_UNK, A_MRC,
    A_UNK, A_MRC, A_UNK, A_MRC,

    // 1110 1000 0000
    A_UNK, A_MCR, A_UNK, A_MCR,
    A_UNK, A_MCR, A_UNK, A_MCR,
    A_UNK, A_MCR, A_UNK, A_MCR,
    A_UNK, A_MCR, A_UNK, A_MCR,

    // 1110 1001 0000
    A_UNK, A_MRC, A_UNK, A_MRC,
    A_UNK, A_MRC, A_UNK, A_MRC,
    A_UNK, A_MRC, A_UNK, A_MRC,
    A_UNK, A_MRC, A_UNK, A_MRC,

    // 1110 1010 0000
    A_UNK, A_MCR, A_UNK, A_MCR,
    A_UNK, A_MCR, A_UNK, A_MCR,
    A_UNK, A_MCR, A_UNK, A_MCR,
    A_UNK, A_MCR, A_UNK, A_MCR,

    // 1110 1011 0000
    A_UNK, A_MRC, A_UNK, A_MRC,
    A_UNK, A_MRC, A_UNK, A_MRC,
    A_UNK, A_MRC, A_UNK, A_MRC,
    A_UNK, A_MRC, A_UNK, A_MRC,

    // 1110 1100 0000
    A_UNK, A_MCR, A_UNK, A_MCR,
    A_UNK, A_MCR, A_UNK, A_MCR,
    A_UNK, A_MCR, A_UNK, A_MCR,
    A_UNK, A_MCR, A_UNK, A_MCR,

    // 1110 1101 0000
    A_UNK, A_MRC, A_UNK, A_MRC,
    A_UNK, A_MRC, A_UNK, A_MRC,
    A_UNK, A_MRC, A_UNK, A_MRC,
    A_UNK, A_MRC, A_UNK, A_MRC,

    // 1110 1110 0000
    A_UNK, A_MCR, A_UNK, A_MCR,
    A_UNK, A_MCR, A_UNK, A_MCR,
    A_UNK, A_MCR, A_UNK, A_MCR,
    A_UNK, A_MCR, A_UNK, A_MCR,

    // 1110 1111 0000
    A_UNK, A_MRC, A_UNK, A_MRC,
    A_UNK, A_MRC, A_UNK, A_MRC,
    A_UNK, A_MRC, A_UNK, A_MRC,
    A_UNK, A_MRC, A_UNK, A_MRC,



    // 1111 0000 0000
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,

    // 1111 0001 0000
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,

    // 1111 0010 0000
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,

    // 1111 0011 0000
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,

    // 1111 0100 0000
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,

    // 1111 0101 0000
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,

    // 1111 0110 0000
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,

    // 1111 0111 0000
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,

    // 1111 1000 0000
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,

    // 1111 1001 0000
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,

    // 1111 1010 0000
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,

    // 1111 1011 0000
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,

    // 1111 1100 0000
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,

    // 1111 1101 0000
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,

    // 1111 1110 0000
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,

    // 1111 1111 0000
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC,
    A_SVC, A_SVC, A_SVC, A_SVC
};

INSTRFUNC_PROTO(THUMBInstrTable[1024]) =
{
    // 0000 0000 00
    T_LSL_IMM, T_LSL_IMM, T_LSL_IMM, T_LSL_IMM,
    T_LSL_IMM, T_LSL_IMM, T_LSL_IMM, T_LSL_IMM,
    T_LSL_IMM, T_LSL_IMM, T_LSL_IMM, T_LSL_IMM,
    T_LSL_IMM, T_LSL_IMM, T_LSL_IMM, T_LSL_IMM,

    // 0000 0100 00
    T_LSL_IMM, T_LSL_IMM, T_LSL_IMM, T_LSL_IMM,
    T_LSL_IMM, T_LSL_IMM, T_LSL_IMM, T_LSL_IMM,
    T_LSL_IMM, T_LSL_IMM, T_LSL_IMM, T_LSL_IMM,
    T_LSL_IMM, T_LSL_IMM, T_LSL_IMM, T_LSL_IMM,

    // 0000 1000 00
    T_LSR_IMM, T_LSR_IMM, T_LSR_IMM, T_LSR_IMM,
    T_LSR_IMM, T_LSR_IMM, T_LSR_IMM, T_LSR_IMM,
    T_LSR_IMM, T_LSR_IMM, T_LSR_IMM, T_LSR_IMM,
    T_LSR_IMM, T_LSR_IMM, T_LSR_IMM, T_LSR_IMM,

    // 0000 1100 00
    T_LSR_IMM, T_LSR_IMM, T_LSR_IMM, T_LSR_IMM,
    T_LSR_IMM, T_LSR_IMM, T_LSR_IMM, T_LSR_IMM,
    T_LSR_IMM, T_LSR_IMM, T_LSR_IMM, T_LSR_IMM,
    T_LSR_IMM, T_LSR_IMM, T_LSR_IMM, T_LSR_IMM,

    // 0001 0000 00
    T_ASR_IMM, T_ASR_IMM, T_ASR_IMM, T_ASR_IMM,
    T_ASR_IMM, T_ASR_IMM, T_ASR_IMM, T_ASR_IMM,
    T_ASR_IMM, T_ASR_IMM, T_ASR_IMM, T_ASR_IMM,
    T_ASR_IMM, T_ASR_IMM, T_ASR_IMM, T_ASR_IMM,

    // 0001 0100 00
    T_ASR_IMM, T_ASR_IMM, T_ASR_IMM, T_ASR_IMM,
    T_ASR_IMM, T_ASR_IMM, T_ASR_IMM, T_ASR_IMM,
    T_ASR_IMM, T_ASR_IMM, T_ASR_IMM, T_ASR_IMM,
    T_ASR_IMM, T_ASR_IMM, T_ASR_IMM, T_ASR_IMM,

    // 0001 1000 00
    T_ADD_REG_, T_ADD_REG_, T_ADD_REG_, T_ADD_REG_,
    T_ADD_REG_, T_ADD_REG_, T_ADD_REG_, T_ADD_REG_,
    T_SUB_REG_, T_SUB_REG_, T_SUB_REG_, T_SUB_REG_,
    T_SUB_REG_, T_SUB_REG_, T_SUB_REG_, T_SUB_REG_,

    // 0001 1100 00
    T_ADD_IMM_, T_ADD_IMM_, T_ADD_IMM_, T_ADD_IMM_,
    T_ADD_IMM_, T_ADD_IMM_, T_ADD_IMM_, T_ADD_IMM_,
    T_SUB_IMM_, T_SUB_IMM_, T_SUB_IMM_, T_SUB_IMM_,
    T_SUB_IMM_, T_SUB_IMM_, T_SUB_IMM_, T_SUB_IMM_,

    // 0010 0000 00
    T_MOV_IMM, T_MOV_IMM, T_MOV_IMM, T_MOV_IMM,
    T_MOV_IMM, T_MOV_IMM, T_MOV_IMM, T_MOV_IMM,
    T_MOV_IMM, T_MOV_IMM, T_MOV_IMM, T_MOV_IMM,
    T_MOV_IMM, T_MOV_IMM, T_MOV_IMM, T_MOV_IMM,

    // 0010 0100 00
    T_MOV_IMM, T_MOV_IMM, T_MOV_IMM, T_MOV_IMM,
    T_MOV_IMM, T_MOV_IMM, T_MOV_IMM, T_MOV_IMM,
    T_MOV_IMM, T_MOV_IMM, T_MOV_IMM, T_MOV_IMM,
    T_MOV_IMM, T_MOV_IMM, T_MOV_IMM, T_MOV_IMM,

    // 0010 1000 00
    T_CMP_IMM, T_CMP_IMM, T_CMP_IMM, T_CMP_IMM,
    T_CMP_IMM, T_CMP_IMM, T_CMP_IMM, T_CMP_IMM,
    T_CMP_IMM, T_CMP_IMM, T_CMP_IMM, T_CMP_IMM,
    T_CMP_IMM, T_CMP_IMM, T_CMP_IMM, T_CMP_IMM,

    // 0010 1100 00
    T_CMP_IMM, T_CMP_IMM, T_CMP_IMM, T_CMP_IMM,
    T_CMP_IMM, T_CMP_IMM, T_CMP_IMM, T_CMP_IMM,
    T_CMP_IMM, T_CMP_IMM, T_CMP_IMM, T_CMP_IMM,
    T_CMP_IMM, T_CMP_IMM, T_CMP_IMM, T_CMP_IMM,

    // 0011 0000 00
    T_ADD_IMM, T_ADD_IMM, T_ADD_IMM, T_ADD_IMM,
    T_ADD_IMM, T_ADD_IMM, T_ADD_IMM, T_ADD_IMM,
    T_ADD_IMM, T_ADD_IMM, T_ADD_IMM, T_ADD_IMM,
    T_ADD_IMM, T_ADD_IMM, T_ADD_IMM, T_ADD_IMM,

    // 0011 0100 00
    T_ADD_IMM, T_ADD_IMM, T_ADD_IMM, T_ADD_IMM,
    T_ADD_IMM, T_ADD_IMM, T_ADD_IMM, T_ADD_IMM,
    T_ADD_IMM, T_ADD_IMM, T_ADD_IMM, T_ADD_IMM,
    T_ADD_IMM, T_ADD_IMM, T_ADD_IMM, T_ADD_IMM,

    // 0011 1000 00
    T_SUB_IMM, T_SUB_IMM, T_SUB_IMM, T_SUB_IMM,
    T_SUB_IMM, T_SUB_IMM, T_SUB_IMM, T_SUB_IMM,
    T_SUB_IMM, T_SUB_IMM, T_SUB_IMM, T_SUB_IMM,
    T_SUB_IMM, T_SUB_IMM, T_SUB_IMM, T_SUB_IMM,

    // 0011 1100 00
    T_SUB_IMM, T_SUB_IMM, T_SUB_IMM, T_SUB_IMM,
    T_SUB_IMM, T_SUB_IMM, T_SUB_IMM, T_SUB_IMM,
    T_SUB_IMM, T_SUB_IMM, T_SUB_IMM, T_SUB_IMM,
    T_SUB_IMM, T_SUB_IMM, T_SUB_IMM, T_SUB_IMM,



    // 0100 0000 00
    T_AND_REG, T_EOR_REG, T_LSL_REG, T_LSR_REG,
    T_ASR_REG, T_ADC_REG, T_SBC_REG, T_ROR_REG,
    T_TST_REG, T_NEG_REG, T_CMP_REG, T_CMN_REG,
    T_ORR_REG, T_MUL_REG, T_BIC_REG, T_MVN_REG,

    // 0100 0100 00
    T_ADD_HIREG, T_ADD_HIREG, T_ADD_HIREG, T_ADD_HIREG,
    T_CMP_HIREG, T_CMP_HIREG, T_CMP_HIREG, T_CMP_HIREG,
    T_MOV_HIREG, T_MOV_HIREG, T_MOV_HIREG, T_MOV_HIREG,
    T_BX, T_BX, T_BLX_REG, T_BLX_REG,

    // 0100 1000 00
    T_LDR_PCREL, T_LDR_PCREL, T_LDR_PCREL, T_LDR_PCREL,
    T_LDR_PCREL, T_LDR_PCREL, T_LDR_PCREL, T_LDR_PCREL,
    T_LDR_PCREL, T_LDR_PCREL, T_LDR_PCREL, T_LDR_PCREL,
    T_LDR_PCREL, T_LDR_PCREL, T_LDR_PCREL, T_LDR_PCREL,

    // 0100 1100 00
    T_LDR_PCREL, T_LDR_PCREL, T_LDR_PCREL, T_LDR_PCREL,
    T_LDR_PCREL, T_LDR_PCREL, T_LDR_PCREL, T_LDR_PCREL,
    T_LDR_PCREL, T_LDR_PCREL, T_LDR_PCREL, T_LDR_PCREL,
    T_LDR_PCREL, T_LDR_PCREL, T_LDR_PCREL, T_LDR_PCREL,

    // 0101 0000 00
    T_STR_REG, T_STR_REG, T_STR_REG, T_STR_REG,
    T_STR_REG, T_STR_REG, T_STR_REG, T_STR_REG,
    T_STRH_REG, T_STRH_REG, T_STRH_REG, T_STRH_REG,
    T_STRH_REG, T_STRH_REG, T_STRH_REG, T_STRH_REG,

    // 0101 0100 00
    T_STRB_REG, T_STRB_REG, T_STRB_REG, T_STRB_REG,
    T_STRB_REG, T_STRB_REG, T_STRB_REG, T_STRB_REG,
    T_LDRSB_REG, T_LDRSB_REG, T_LDRSB_REG, T_LDRSB_REG,
    T_LDRSB_REG, T_LDRSB_REG, T_LDRSB_REG, T_LDRSB_REG,

    // 0101 1000 00
    T_LDR_REG, T_LDR_REG, T_LDR_REG, T_LDR_REG,
    T_LDR_REG, T_LDR_REG, T_LDR_REG, T_LDR_REG,
    T_LDRH_REG, T_LDRH_REG, T_LDRH_REG, T_LDRH_REG,
    T_LDRH_REG, T_LDRH_REG, T_LDRH_REG, T_LDRH_REG,

    // 0101 1100 00
    T_LDRB_REG, T_LDRB_REG, T_LDRB_REG, T_LDRB_REG,
    T_LDRB_REG, T_LDRB_REG, T_LDRB_REG, T_LDRB_REG,
    T_LDRSH_REG, T_LDRSH_REG, T_LDRSH_REG, T_LDRSH_REG,
    T_LDRSH_REG, T_LDRSH_REG, T_LDRSH_REG, T_LDRSH_REG,

    // 0110 0000 00
    T_STR_IMM, T_STR_IMM, T_STR_IMM, T_STR_IMM,
    T_STR_IMM, T_STR_IMM, T_STR_IMM, T_STR_IMM,
    T_STR_IMM, T_STR_IMM, T_STR_IMM, T_STR_IMM,
    T_STR_IMM, T_STR_IMM, T_STR_IMM, T_STR_IMM,

    // 0110 0100 00
    T_STR_IMM, T_STR_IMM, T_STR_IMM, T_STR_IMM,
    T_STR_IMM, T_STR_IMM, T_STR_IMM, T_STR_IMM,
    T_STR_IMM, T_STR_IMM, T_STR_IMM, T_STR_IMM,
    T_STR_IMM, T_STR_IMM, T_STR_IMM, T_STR_IMM,

    // 0110 1000 00
    T_LDR_IMM, T_LDR_IMM, T_LDR_IMM, T_LDR_IMM,
    T_LDR_IMM, T_LDR_IMM, T_LDR_IMM, T_LDR_IMM,
    T_LDR_IMM, T_LDR_IMM, T_LDR_IMM, T_LDR_IMM,
    T_LDR_IMM, T_LDR_IMM, T_LDR_IMM, T_LDR_IMM,

    // 0110 1100 00
    T_LDR_IMM, T_LDR_IMM, T_LDR_IMM, T_LDR_IMM,
    T_LDR_IMM, T_LDR_IMM, T_LDR_IMM, T_LDR_IMM,
    T_LDR_IMM, T_LDR_IMM, T_LDR_IMM, T_LDR_IMM,
    T_LDR_IMM, T_LDR_IMM, T_LDR_IMM, T_LDR_IMM,

    // 0111 0000 00
    T_STRB_IMM, T_STRB_IMM, T_STRB_IMM, T_STRB_IMM,
    T_STRB_IMM, T_STRB_IMM, T_STRB_IMM, T_STRB_IMM,
    T_STRB_IMM, T_STRB_IMM, T_STRB_IMM, T_STRB_IMM,
    T_STRB_IMM, T_STRB_IMM, T_STRB_IMM, T_STRB_IMM,

    // 0111 0100 00
    T_STRB_IMM, T_STRB_IMM, T_STRB_IMM, T_STRB_IMM,
    T_STRB_IMM, T_STRB_IMM, T_STRB_IMM, T_STRB_IMM,
    T_STRB_IMM, T_STRB_IMM, T_STRB_IMM, T_STRB_IMM,
    T_STRB_IMM, T_STRB_IMM, T_STRB_IMM, T_STRB_IMM,

    // 0111 1000 00
    T_LDRB_IMM, T_LDRB_IMM, T_LDRB_IMM, T_LDRB_IMM,
    T_LDRB_IMM, T_LDRB_IMM, T_LDRB_IMM, T_LDRB_IMM,
    T_LDRB_IMM, T_LDRB_IMM, T_LDRB_IMM, T_LDRB_IMM,
    T_LDRB_IMM, T_LDRB_IMM, T_LDRB_IMM, T_LDRB_IMM,

    // 0111 1100 00
    T_LDRB_IMM, T_LDRB_IMM, T_LDRB_IMM, T_LDRB_IMM,
    T_LDRB_IMM, T_LDRB_IMM, T_LDRB_IMM, T_LDRB_IMM,
    T_LDRB_IMM, T_LDRB_IMM, T_LDRB_IMM, T_LDRB_IMM,
    T_LDRB_IMM, T_LDRB_IMM, T_LDRB_IMM, T_LDRB_IMM,



    // 1000 0000 00
    T_STRH_IMM, T_STRH_IMM, T_STRH_IMM, T_STRH_IMM,
    T_STRH_IMM, T_STRH_IMM, T_STRH_IMM, T_STRH_IMM,
    T_STRH_IMM, T_STRH_IMM, T_STRH_IMM, T_STRH_IMM,
    T_STRH_IMM, T_STRH_IMM, T_STRH_IMM, T_STRH_IMM,

    // 1000 0100 00
    T_STRH_IMM, T_STRH_IMM, T_STRH_IMM, T_STRH_IMM,
    T_STRH_IMM, T_STRH_IMM, T_STRH_IMM, T_STRH_IMM,
    T_STRH_IMM, T_STRH_IMM, T_STRH_IMM, T_STRH_IMM,
    T_STRH_IMM, T_STRH_IMM, T_STRH_IMM, T_STRH_IMM,

    // 1000 1000 00
    T_LDRH_IMM, T_LDRH_IMM, T_LDRH_IMM, T_LDRH_IMM,
    T_LDRH_IMM, T_LDRH_IMM, T_LDRH_IMM, T_LDRH_IMM,
    T_LDRH_IMM, T_LDRH_IMM, T_LDRH_IMM, T_LDRH_IMM,
    T_LDRH_IMM, T_LDRH_IMM, T_LDRH_IMM, T_LDRH_IMM,

    // 1000 1100 00
    T_LDRH_IMM, T_LDRH_IMM, T_LDRH_IMM, T_LDRH_IMM,
    T_LDRH_IMM, T_LDRH_IMM, T_LDRH_IMM, T_LDRH_IMM,
    T_LDRH_IMM, T_LDRH_IMM, T_LDRH_IMM, T_LDRH_IMM,
    T_LDRH_IMM, T_LDRH_IMM, T_LDRH_IMM, T_LDRH_IMM,

    // 1001 0000 00
    T_STR_SPREL, T_STR_SPREL, T_STR_SPREL, T_STR_SPREL,
    T_STR_SPREL, T_STR_SPREL, T_STR_SPREL, T_STR_SPREL,
    T_STR_SPREL, T_STR_SPREL, T_STR_SPREL, T_STR_SPREL,
    T_STR_SPREL, T_STR_SPREL, T_STR_SPREL, T_STR_SPREL,

    // 1001 0100 00
    T_STR_SPREL, T_STR_SPREL, T_STR_SPREL, T_STR_SPREL,
    T_STR_SPREL, T_STR_SPREL, T_STR_SPREL, T_STR_SPREL,
    T_STR_SPREL, T_STR_SPREL, T_STR_SPREL, T_STR_SPREL,
    T_STR_SPREL, T_STR_SPREL, T_STR_SPREL, T_STR_SPREL,

    // 1001 1000 00
    T_LDR_SPREL, T_LDR_SPREL, T_LDR_SPREL, T_LDR_SPREL,
    T_LDR_SPREL, T_LDR_SPREL, T_LDR_SPREL, T_LDR_SPREL,
    T_LDR_SPREL, T_LDR_SPREL, T_LDR_SPREL, T_LDR_SPREL,
    T_LDR_SPREL, T_LDR_SPREL, T_LDR_SPREL, T_LDR_SPREL,

    // 1001 1100 00
    T_LDR_SPREL, T_LDR_SPREL, T_LDR_SPREL, T_LDR_SPREL,
    T_LDR_SPREL, T_LDR_SPREL, T_LDR_SPREL, T_LDR_SPREL,
    T_LDR_SPREL, T_LDR_SPREL, T_LDR_SPREL, T_LDR_SPREL,
    T_LDR_SPREL, T_LDR_SPREL, T_LDR_SPREL, T_LDR_SPREL,

    // 1010 0000 00
    T_ADD_PCREL, T_ADD_PCREL, T_ADD_PCREL, T_ADD_PCREL,
    T_ADD_PCREL, T_ADD_PCREL, T_ADD_PCREL, T_ADD_PCREL,
    T_ADD_PCREL, T_ADD_PCREL, T_ADD_PCREL, T_ADD_PCREL,
    T_ADD_PCREL, T_ADD_PCREL, T_ADD_PCREL, T_ADD_PCREL,

    // 1010 0100 00
    T_ADD_PCREL, T_ADD_PCREL, T_ADD_PCREL, T_ADD_PCREL,
    T_ADD_PCREL, T_ADD_PCREL, T_ADD_PCREL, T_ADD_PCREL,
    T_ADD_PCREL, T_ADD_PCREL, T_ADD_PCREL, T_ADD_PCREL,
    T_ADD_PCREL, T_ADD_PCREL, T_ADD_PCREL, T_ADD_PCREL,

    // 1010 1000 00
    T_ADD_SPREL, T_ADD_SPREL, T_ADD_SPREL, T_ADD_SPREL,
    T_ADD_SPREL, T_ADD_SPREL, T_ADD_SPREL, T_ADD_SPREL,
    T_ADD_SPREL, T_ADD_SPREL, T_ADD_SPREL, T_ADD_SPREL,
    T_ADD_SPREL, T_ADD_SPREL, T_ADD_SPREL, T_ADD_SPREL,

    // 1010 1100 00
    T_ADD_SPREL, T_ADD_SPREL, T_ADD_SPREL, T_ADD_SPREL,
    T_ADD_SPREL, T_ADD_SPREL, T_ADD_SPREL, T_ADD_SPREL,
    T_ADD_SPREL, T_ADD_SPREL, T_ADD_SPREL, T_ADD_SPREL,
    T_ADD_SPREL, T_ADD_SPREL, T_ADD_SPREL, T_ADD_SPREL,

    // 1011 0000 00
    T_ADD_SP, T_ADD_SP, T_ADD_SP, T_ADD_SP,
    T_UNK, T_UNK, T_UNK, T_UNK,
    T_UNK, T_UNK, T_UNK, T_UNK,
    T_UNK, T_UNK, T_UNK, T_UNK,

    // 1011 0100 00
    T_PUSH, T_PUSH, T_PUSH, T_PUSH,
    T_PUSH, T_PUSH, T_PUSH, T_PUSH,
    T_UNK, T_UNK, T_UNK, T_UNK,
    T_UNK, T_UNK, T_UNK, T_UNK,

    // 1011 1000 00
    T_UNK, T_UNK, T_UNK, T_UNK,
    T_UNK, T_UNK, T_UNK, T_UNK,
    T_UNK, T_UNK, T_UNK, T_UNK,
    T_UNK, T_UNK, T_UNK, T_UNK,

    // 1011 1100 00
    T_POP, T_POP, T_POP, T_POP,
    T_POP, T_POP, T_POP, T_POP,
    T_UNK, T_UNK, T_UNK, T_UNK,
    T_UNK, T_UNK, T_UNK, T_UNK,



    // 1100 0000 00
    T_STMIA, T_STMIA, T_STMIA, T_STMIA,
    T_STMIA, T_STMIA, T_STMIA, T_STMIA,
    T_STMIA, T_STMIA, T_STMIA, T_STMIA,
    T_STMIA, T_STMIA, T_STMIA, T_STMIA,

    // 1100 0100 00
    T_STMIA, T_STMIA, T_STMIA, T_STMIA,
    T_STMIA, T_STMIA, T_STMIA, T_STMIA,
    T_STMIA, T_STMIA, T_STMIA, T_STMIA,
    T_STMIA, T_STMIA, T_STMIA, T_STMIA,

    // 1100 1000 00
    T_LDMIA, T_LDMIA, T_LDMIA, T_LDMIA,
    T_LDMIA, T_LDMIA, T_LDMIA, T_LDMIA,
    T_LDMIA, T_LDMIA, T_LDMIA, T_LDMIA,
    T_LDMIA, T_LDMIA, T_LDMIA, T_LDMIA,

    // 1100 1100 00
    T_LDMIA, T_LDMIA, T_LDMIA, T_LDMIA,
    T_LDMIA, T_LDMIA, T_LDMIA, T_LDMIA,
    T_LDMIA, T_LDMIA, T_LDMIA, T_LDMIA,
    T_LDMIA, T_LDMIA, T_LDMIA, T_LDMIA,

    // 1101 0000 00
    T_BCOND, T_BCOND, T_BCOND, T_BCOND,
    T_BCOND, T_BCOND, T_BCOND, T_BCOND,
    T_BCOND, T_BCOND, T_BCOND, T_BCOND,
    T_BCOND, T_BCOND, T_BCOND, T_BCOND,

    // 1101 0100 00
    T_BCOND, T_BCOND, T_BCOND, T_BCOND,
    T_BCOND, T_BCOND, T_BCOND, T_BCOND,
    T_BCOND, T_BCOND, T_BCOND, T_BCOND,
    T_BCOND, T_BCOND, T_BCOND, T_BCOND,

    // 1101 1000 00
    T_BCOND, T_BCOND, T_BCOND, T_BCOND,
    T_BCOND, T_BCOND, T_BCOND, T_BCOND,
    T_BCOND, T_BCOND, T_BCOND, T_BCOND,
    T_BCOND, T_BCOND, T_BCOND, T_BCOND,

    // 1101 1100 00
    T_BCOND, T_BCOND, T_BCOND, T_BCOND,
    T_BCOND, T_BCOND, T_BCOND, T_BCOND,
    T_UNK, T_UNK, T_UNK, T_UNK,
    T_SVC, T_SVC, T_SVC, T_SVC,

    // 1110 0000 00
    T_B, T_B, T_B, T_B,
    T_B, T_B, T_B, T_B,
    T_B, T_B, T_B, T_B,
    T_B, T_B, T_B, T_B,

    // 1110 0100 00
    T_B, T_B, T_B, T_B,
    T_B, T_B, T_B, T_B,
    T_B, T_B, T_B, T_B,
    T_B, T_B, T_B, T_B,

    // 1110 1000 00
    T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2,
    T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2,
    T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2,
    T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2,

    // 1110 1100 00
    T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2,
    T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2,
    T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2,
    T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2,

    // 1111 0000 00
    T_BL_LONG_1, T_BL_LONG_1, T_BL_LONG_1, T_BL_LONG_1,
    T_BL_LONG_1, T_BL_LONG_1, T_BL_LONG_1, T_BL_LONG_1,
    T_BL_LONG_1, T_BL_LONG_1, T_BL_LONG_1, T_BL_LONG_1,
    T_BL_LONG_1, T_BL_LONG_1, T_BL_LONG_1, T_BL_LONG_1,

    // 1111 0100 00
    T_BL_LONG_1, T_BL_LONG_1, T_BL_LONG_1, T_BL_LONG_1,
    T_BL_LONG_1, T_BL_LONG_1, T_BL_LONG_1, T_BL_LONG_1,
    T_BL_LONG_1, T_BL_LONG_1, T_BL_LONG_1, T_BL_LONG_1,
    T_BL_LONG_1, T_BL_LONG_1, T_BL_LONG_1, T_BL_LONG_1,

    // 1111 1000 00
    T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2,
    T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2,
    T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2,
    T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2,

    // 1111 1100 00
    T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2,
    T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2,
    T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2,
    T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2, T_BL_LONG_2
};
