/***************************************************************************
 *   Copyright (C) 2004 by EVER Sp. z o.o.                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef NET3000_H
#define NET3000_H

#include "structs.h"
#include "gldefs.h"
#include "ioctldef.h"
#include <math.h>

#ifdef NET3000_DRIVER_BUILD

/* 
 * Driver definitions
 */
#define DRIVER_VERSION_MAJOR			0
#define DRIVER_VERSION_MINOR			0
#define DRIVER_VERSION_SUBMINOR			1

#define DRIVER_BITMAP_FILE				PIX_PATH"/net3000.bmp"
#define DRIVER_CONFIG_FILE				"net3000.conf"
#define DRIVER_UPS_FAMILY				"NET 3000 DPC"
#define DRIVER_UPS_PREFIX				"NET 3000"
#define DRIVER_UPS_SUFFIX				"DPC"


#define UPS_MAX_MODELS					1
#define UPS_MODEL1						"3000"
#define INT_UPS_MODEL1					72

/* 
 * Licznik pozycji ustawien z drivera
 */
#define INT_MAX_SETUPITEMS				8
/* 
 * Identyfikatory ustawien UPS-a
 */
#define INT_UPSCFG_SERIALCOMM			0
#define INT_UPSCFG_BUZZER				1
#define INT_UPSCFG_STANDBYDELAY			2
#define INT_UPSCFG_V_TH_LOWER			3
#define INT_UPSCFG_V_TH_AVR				4
#define INT_UPSCFG_V_TH_UPPER			5
#define INT_UPSCFG_KEYBOARDLOCK			6
#define INT_UPSCFG_MODULE_NO			7

// default values
#define DEFAULT_STANDBY_TIME			90
#define DEFAULT_LOWER_TT				185
#define DEFAULT_AVR_TT					200
#define DEFAULT_UPPER_TT				270
#define DEFAULT_MODULE_NO				1

/* 
 * Kody zawartosci ramek transmisyjnych
 */
#define FRAME_INITCODE					0xD0
#define FRAME_BUSYCODE					0xCF

/*
 * Kody informacji z UPS'a
 */
/*
 * rejestr sysflag
 * Bity:
 * 0 - powrot do pracy po standby
 * 1 - test ups, autotest
 * 2 - wylaczenie buzzera
 * 3 - zezwolenie na przejscie do standby na bat
 * 4 - zezwolenie na uruchomienie timera standby
 * 5 - zezwala na odliczanie licznikow a,b,c dla timera
 * 6 - test ups
 * 7 - test ups oraz przy standby i wlaczonym timerze znacznik dla ups
 */
#define SFB_AND_STANDBY				0xE7	// Tryb oczekiwania
#define SFB_OR_STANDBY				0x08	// flaga do uaktywnienia trybu oczekiwania
#define SFB_AND_STANDBY2			0xC7	// Tryb oczekiwania na sieci
#define SFB_OR_STANDBY2				0x30	// flaga do uaktywnienia trybu oczekiwania na sieci
#define SFB_AND_LATCH				0x2F	// Zatrzasnij sysflag
#define SFB_OR_LATCH				0xC0	// flaga do zatrzasniecia sysflaga
#define SFB_AND_TEST				0xED	// Autotest
#define SFB_OR_TEST					0x02	// flaga do wykonania autotestu
#define SFB_AND_SOUND				0xFB	// dzwiek buzzera
#define SFB_OR_SOUND				0x04	// flaga do wylaczenia dzwieku

/*
 * status pracy zasilacza
 * 0 - praca standby
 * 1 - praca bateryjna gdy 1
 * 2 - przetwornica start gdy 1
 * 3 - n/a
 * 4 - zwarcie
 * 5 - przeciazenie
 * 6 - n/a
 * 7 - n/a
 */
#define USB_AND_STANDBY				0x01
#define USB_FLAG_STANDBY			0x01
#define USB_AND_POWERFAIL			0x05
#define USB_FLAG_POWERFAIL			0x04
#define USB_AND_POWEROK				0x05
#define USB_FLAG_POWEROK			0x00
#define USB_AND_SHORT				0x10
#define USB_FLAG_SHORT				0x10
#define USB_AND_OVERLOAD			0x20
#define USB_FLAG_OVERLOAD			0x20

/*
 * Indeksy z tablicy ustawien UPS'a - wewnetrzne
 */
#define IDXS_TAB_ITEMS				0x0A
// Indeksy tablicy ustawien
#define IDXS_SYSFLAG_OR				0x00
#define IDXS_SYSFLAG_AND			0x01
#define IDXS_TH_UPPER_LSB			0x02
#define IDXS_TH_UPPER_MSB			0x03
#define IDXS_TH_AVR_LSB				0x04
#define IDXS_TH_AVR_MSB				0x05
#define IDXS_TH_LOWER_LSB			0x06
#define IDXS_TH_LOWER_MSB			0x07
#define IDXS_MODULE_NO				0x08
#define IDXS_KEYB_LOCK				0x09


/*
 * Indeksy z tablicy parametrow UPS'a - wewnetrzne
 */
// licznik
#define IDXP_TAB_ITEMS				0x1A
// Indeksy tablicy parametr�
#define IDXP_UPSTYPE				0x00
#define IDXP_TH_UPPER_LSB			0x01
#define IDXP_TH_UPPER_MSB			0x02
#define IDXP_TH_AVR_LSB				0x03
#define IDXP_TH_AVR_MSB				0x04
#define IDXP_TH_LOWER_LSB			0x05
#define IDXP_TH_LOWER_MSB			0x06
#define IDXP_L3AKU					0x07
#define IDXP_L2AKU					0x08
#define IDXP_L1AKU					0x09
#define IDXP_WSP_AKU1B				0x0A
#define IDXP_WSP_AKU2B				0x0B
#define IDXP_WSP_AKU1S				0x0C
#define IDXP_WSP_AKU2S				0x0D
#define IDXP_U_AKU					0x0E
#define IDXP_POWER_OUT				0x0F
#define IDXP_U_IN_LSB				0x10
#define IDXP_U_IN_MSB				0x11
#define IDXP_REG47					0x12
#define IDXP_REG46					0x13
#define IDXP_DATA1					0x14
#define IDXP_DATA2					0x15
#define IDXP_DATA3					0x16
#define IDXP_FIX_LSB				0x17
#define IDXP_FIX_MSB				0x18
#define IDXP_FIX_MMSB				0x19

/*
 * Indeksy z rozszerzonej tablicy parametrow UPS'a - wewnetrzne
 */
// licznik
#define IDXPEXT_TAB_OFFSET			IDXP_TAB_ITEMS
#define IDXPEXT_TAB_ITEMS			0x08
// Indeksy rozszerzonej tablicy parametrow
#define IDXPEXT_L3AKU				0x1A
#define IDXPEXT_L2AKU				0x1B
#define IDXPEXT_L1AKU				0x1C
#define IDXPEXT_WSP_AKU1			0x1D
#define IDXPEXT_WSP_AKU2			0x1E
#define IDXPEXT_MODULE_NO			0x1F
#define IDXPEXT_V_AKU				0x20
#define IDXPEXT_POWER_OUT			0x21

/*
 * Parametry interfejsowe - zewnetrzne /po obrobce/
 */
// licznik parametrow konfiguracji
#define SETUP_TABLE_ITEMS			0x07
// parametry konfiguracyjne
#define SETUP_ITEM_V_TH_UPPER		0x00
#define SETUP_ITEM_V_TH_AVR			0x01
#define SETUP_ITEM_V_TH_LOWER		0x02
#define SETUP_ITEM_BUZZER_EN		0x03
#define SETUP_ITEM_STANDBY_TIME		0x04
#define SETUP_ITEM_KEYB_LOCK		0x05
#define SETUP_ITEM_MODULE_NO		0x06

// licznik parametrow informacyjnych
#define PARAMS_TABLE_ITEMS			0x08
// parametry informacyjne
#define PARAMS_ITEM_UPSTYPE			0x00
#define PARAMS_ITEM_TH_UPPER		0x01
#define PARAMS_ITEM_TH_AVR			0x02
#define PARAMS_ITEM_TH_LOWER		0x03
#define PARAMS_ITEM_V_AKU			0x04
#define PARAMS_ITEM_V_INPUT			0x05
#define PARAMS_ITEM_POWEROUT		0x06
#define PARAMS_ITEM_SYSFLAG			0x07

// licznik parametrow informacyjnych
#define EXT_PARAMS_TABLE_ITEMS		0x05
// parametry informacyjne
#define EXT_PARAMS_ITEM_AKUVIRTCAP	0x00
#define EXT_PARAMS_ITEM_AKUFACTOR	0x01
#define EXT_PARAMS_ITEM_MODULENO	0x02
#define EXT_PARAMS_ITEM_V_AKU		0x03
#define EXT_PARAMS_ITEM_POWEROUT	0x04


/*
 * Structures
 */
typedef struct _sdrv_config_
{
	/* struct size. could be used for versioning */
	unsigned long	ulSize;
	/* serial port configured by user */
	int				iSerialPort;
	char			szSerialPort[ MAX_PATHBUFF ];
	/* setup table */
	unsigned int	uiSetupTable[SETUP_TABLE_ITEMS];
	/* parameters table */
	unsigned int	uiParamsTable[PARAMS_TABLE_ITEMS];
} sdrv_config, *lpsdrv_config;


/* 
 * Enumerators
 */
// supported request type
typedef enum _eups_datatypes_
{
	EU_MAIN				= 0x01,		// ask for main parameters
	EU_EXTENDED			= 0x02,		// ask for extended parameters + autotest (don't do it frequently)
	EU_SERVICE			= 0x04,		// ask for service information (manufact. dates)
	EU_SET_MAIN			= 0x08,		// set main settings (modules, beeper, tresholds)
	EU_SET_UPSSHUTDOWN	= 0x10		// set ups shutdown timer and activate it
} eups_datatypes;

/* 
 * Function prototypes - internal
 */
int		Net3k_DoInit(void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoUnInit(void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoGetConfigFileName(void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoAutoConfigure(void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoConfigure(void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoGetUpsInfoMask(void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoSetUpsInfoMask(void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoGetUpsStateMask(void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoSetUpsStateMask(void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoGetUpsState(void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoGetUpsParamsMask(void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoSetUpsParamsMask(void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoGetUpsParams(void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoGetUpsSetupParamsMask(void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoSetUpsSetupParamsMask(void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoGetUpsSetupParams(void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoSetUpsSetupParams(void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoGetDriverInfo(void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoGetUpsCharacteristics(void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoGetExtendedError(void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoTestUpsLink(void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoGetUPSdata(eups_datatypes eType, void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoSetUPSdata(eups_datatypes eType, void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoGetUpsCharacteristicMask(void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoGetUpsCharacteristic(void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoGetConfigParamsCount(void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoGetConfigParams(void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoGetConfigParam(void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoSetConfigParams(void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoSetConfigParam(void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoUpdateConfig(void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoGetDriverMode(void *lpvBuff, int *lpiBuffSize);
int		Net3k_DoUpsShutdown(void *lpvBuff, int *lpiBuffSize);

int		Net3k_ReadConfig();

int		Net3k_GetAllUpsParams(void *lpvBuff, int *lpiBuffSize);
int		Net3k_GetAllUpsSetupParams(void *lpvBuff, int *lpiBuffSize);
int		Net3k_SetAllUpsSetupParams(void *lpvBuff, int *lpiBuffSize);

#else/*NET3000_DRIVER_BUILD*/

int		net3k_ioctl(long lCommand, void *lpvBuff, int *lpiBuffSize);

#endif/*NET3000_DRIVER_BUILD*/

#endif/*NET3000_H*/
