/*
Copyright 2011-2012  Francesco Cecconi <francesco.cecconi@gmail.com>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "addvulnerabilityurl.h"

AddVulnerabilityUrl::AddVulnerabilityUrl(QWidget* parent)
    : QDialog(parent)
{
    Q_UNUSED(parent)

    setupUi(this);

    connect(doneButt, &QPushButton::clicked,
            this, &AddVulnerabilityUrl::exit);
    connect(cancelButt, &QPushButton::clicked,
            this, &AddVulnerabilityUrl::close);
}

AddVulnerabilityUrl::~AddVulnerabilityUrl()
{

}

void AddVulnerabilityUrl::exit()
{
    if (!lineUrlName->text().isEmpty() && !lineUrlAddr->text().isEmpty()) {
        emit doneUrl(lineUrlName->text(), lineUrlAddr->text());
        close();
    } else {
        QMessageBox::warning(this, tr("Warning - Nmapsi4"), tr("Insert url name or/and address."));
    }
}
