/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.binding;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import javafx.beans.binding.ObjectBinding;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;

public abstract class AbstractNestedListBinding<T, U>
extends ObjectBinding<U> {
    protected final ObservableList<ObservableList<T>> source;
    private final ListChangeListener<T> innerListChangeListener = change -> {
        while (change.next()) {
            if (!change.wasAdded() && !change.wasRemoved()) continue;
            this.invalidate();
            break;
        }
    };
    private final WeakListChangeListener<T> weakInnerListChangeListener = new WeakListChangeListener(this.innerListChangeListener);
    private final ListChangeListener<ObservableList<T>> outerListChangeListener = change -> {
        while (change.next()) {
            if (change.wasRemoved()) {
                change.getRemoved().forEach(this::safeRemoveListener);
            }
            if (change.wasAdded()) {
                change.getAddedSubList().forEach(this::safeAddListener);
            }
            this.invalidate();
        }
    };
    private final WeakListChangeListener<ObservableList<T>> weakOuterListChangeListener = new WeakListChangeListener(this.outerListChangeListener);

    public AbstractNestedListBinding(ObservableList<ObservableList<T>> source) {
        this.source = Objects.requireNonNull(source, "Source list cannot be null");
    }

    protected void initListeners() {
        this.source.forEach(this::safeAddListener);
        this.source.addListener(this.weakOuterListChangeListener);
    }

    private void safeAddListener(ObservableList<T> list) {
        if (list != null) {
            list.addListener(this.weakInnerListChangeListener);
        }
    }

    private void safeRemoveListener(ObservableList<T> list) {
        if (list != null) {
            list.removeListener(this.weakInnerListChangeListener);
        }
    }

    protected Stream<T> flattenSource() {
        return this.source.stream().filter(Objects::nonNull).flatMap(Collection::stream);
    }

    public void dispose() {
        this.source.forEach(this::safeRemoveListener);
        this.source.removeListener(this.weakOuterListChangeListener);
    }
}

