/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.SearchTextField;
import com.dlsc.gemsfx.skins.FilterViewSkin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import org.apache.commons.lang3.StringUtils;

public class FilterView<T>
extends Control {
    private final SearchTextField searchTextField = new SearchTextField();
    private final IntegerProperty scrollThreshold = new SimpleIntegerProperty((Object)this, "scrollThreshold", 100);
    private final ObjectProperty<Label> titleLabel = new SimpleObjectProperty((Object)this, "titleLabel", (Object)new Label());
    private final ObjectProperty<Label> titlePostfixLabel = new SimpleObjectProperty((Object)this, "titlePostfixLabel", (Object)new Label());
    private final ObjectProperty<Label> subtitleLabel = new SimpleObjectProperty((Object)this, "subtitleLabel", (Object)new Label());
    private final BooleanProperty showHeader = new SimpleBooleanProperty((Object)this, "showHeader", true);
    private final ObjectProperty<Node> extras = new SimpleObjectProperty((Object)this, "extras");
    private final StringProperty title = new SimpleStringProperty((Object)this, "title", "Untitled");
    private final StringProperty titlePostfix = new SimpleStringProperty((Object)this, "titlePostfix", "");
    private final StringProperty subtitle = new SimpleStringProperty((Object)this, "subtitle", "");
    private final ListProperty<T> items = new SimpleListProperty((Object)this, "items", FXCollections.observableArrayList());
    private final ReadOnlyListWrapper<T> filteredItems = new ReadOnlyListWrapper();
    private final StringProperty filterText = new SimpleStringProperty((Object)this, "filterText");
    private final ObjectProperty<Callback<String, Predicate<T>>> textFilterProvider = new SimpleObjectProperty((Object)this, "textFilterProvider");
    private final ListProperty<FilterGroup<T>> filterGroups = new SimpleListProperty(FXCollections.observableArrayList());
    private final ListProperty<Filter<T>> filters = new SimpleListProperty((Object)this, "filters", FXCollections.observableArrayList());
    private final ObjectProperty<Predicate<T>> additionalFilterPredicate = new SimpleObjectProperty((Object)this, "additionalFilterPredicate", item -> true);
    private final ReadOnlyObjectWrapper<Predicate<T>> filterPredicate = new ReadOnlyObjectWrapper((Object)this, "filterPredicate", item -> true);

    public FilterView() {
        this.getStyleClass().add((Object)"filter-view");
        this.setFocusTraversable(false);
        InvalidationListener updatePredicateListener = it -> {
            HashMap<FilterGroup, List> map = new HashMap<FilterGroup, List>();
            for (Object filter : this.getFilters()) {
                for (FilterGroup group : this.getFilterGroups()) {
                    if (!group.getFilters().contains(filter)) continue;
                    map.computeIfAbsent(group, key -> new ArrayList()).add(filter);
                }
            }
            Predicate<Object> predicate = item -> true;
            for (FilterGroup group : map.keySet()) {
                Predicate<Object> groupPredicate = item -> false;
                for (Filter filter : (List)map.get(group)) {
                    groupPredicate = groupPredicate.or(filter);
                }
                predicate = predicate.and(groupPredicate);
            }
            Callback<String, Predicate<T>> textFilterProvider = this.getTextFilterProvider();
            if (textFilterProvider != null && StringUtils.isNotBlank((CharSequence)this.getFilterText())) {
                predicate = predicate.and((Predicate)textFilterProvider.call((Object)this.getFilterText().toLowerCase()));
            }
            this.filterPredicate.set(predicate.and(this.getAdditionalFilterPredicate()));
        };
        this.filters.addListener(updatePredicateListener);
        this.textFilterProviderProperty().addListener(updatePredicateListener);
        this.filterTextProperty().addListener(updatePredicateListener);
        this.additionalFilterPredicateProperty().addListener(updatePredicateListener);
        this.items.addListener(it -> {
            FilteredList filteredList = new FilteredList(this.getItems());
            filteredList.predicateProperty().bind(this.filterPredicateProperty());
            this.filteredItems.set((ObservableList)filteredList);
        });
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(FilterView.class.getResource("filter-view.css")).toExternalForm();
    }

    protected Skin<?> createDefaultSkin() {
        return new FilterViewSkin(this);
    }

    public final SearchTextField getSearchTextField() {
        return this.searchTextField;
    }

    public int getScrollThreshold() {
        return this.scrollThreshold.get();
    }

    public IntegerProperty scrollThresholdProperty() {
        return this.scrollThreshold;
    }

    public void setScrollThreshold(int scrollThreshold) {
        this.scrollThreshold.set(scrollThreshold);
    }

    public final Label getTitleLabel() {
        return (Label)this.titleLabel.get();
    }

    public final ObjectProperty<Label> titleLabelProperty() {
        return this.titleLabel;
    }

    public final void setTitleLabel(Label titleLabel) {
        this.titleLabel.set((Object)titleLabel);
    }

    public final Label getTitlePostfixLabel() {
        return (Label)this.titlePostfixLabel.get();
    }

    public final ObjectProperty<Label> titlePostfixLabelProperty() {
        return this.titlePostfixLabel;
    }

    public final void setTitlePostfixLabel(Label titlePostfixLabel) {
        this.titlePostfixLabel.set((Object)titlePostfixLabel);
    }

    public Label getSubtitleLabel() {
        return (Label)this.subtitleLabel.get();
    }

    public ObjectProperty<Label> subtitleLabelProperty() {
        return this.subtitleLabel;
    }

    public void setSubtitleLabel(Label subtitleLabel) {
        this.subtitleLabel.set((Object)subtitleLabel);
    }

    public final boolean isShowHeader() {
        return this.showHeader.get();
    }

    public final BooleanProperty showHeaderProperty() {
        return this.showHeader;
    }

    public final void setShowHeader(boolean showHeader) {
        this.showHeader.set(showHeader);
    }

    public final Node getExtras() {
        return (Node)this.extras.get();
    }

    public final ObjectProperty<Node> extrasProperty() {
        return this.extras;
    }

    public final void setExtras(Node extras) {
        this.extras.set((Object)extras);
    }

    public final String getTitle() {
        return (String)this.title.get();
    }

    public final StringProperty titleProperty() {
        return this.title;
    }

    public final void setTitle(String title) {
        this.title.set((Object)title);
    }

    public final String getTitlePostfix() {
        return (String)this.titlePostfix.get();
    }

    public final StringProperty titlePostfixProperty() {
        return this.titlePostfix;
    }

    public final void setTitlePostfix(String titlePostfix) {
        this.titlePostfix.set((Object)titlePostfix);
    }

    public final String getSubtitle() {
        return (String)this.subtitle.get();
    }

    public final StringProperty subtitleProperty() {
        return this.subtitle;
    }

    public final void setSubtitle(String subtitle) {
        this.subtitle.set((Object)subtitle);
    }

    public final ObservableList<T> getItems() {
        return (ObservableList)this.items.get();
    }

    public final ListProperty<T> itemsProperty() {
        return this.items;
    }

    public final void setItems(ObservableList<T> items) {
        this.items.set(items);
    }

    public final ReadOnlyListProperty<T> filteredItemsProperty() {
        return this.filteredItems.getReadOnlyProperty();
    }

    public final ObservableList<T> getFilteredItems() {
        return this.filteredItems.getReadOnlyProperty();
    }

    public final String getFilterText() {
        return (String)this.filterText.get();
    }

    public final StringProperty filterTextProperty() {
        return this.filterText;
    }

    public final void setFilterText(String filterText) {
        this.filterText.set((Object)filterText);
    }

    public final Callback<String, Predicate<T>> getTextFilterProvider() {
        return (Callback)this.textFilterProvider.get();
    }

    public final ObjectProperty<Callback<String, Predicate<T>>> textFilterProviderProperty() {
        return this.textFilterProvider;
    }

    public final void setTextFilterProvider(Callback<String, Predicate<T>> textFilterProvider) {
        this.textFilterProvider.set(textFilterProvider);
    }

    public final ObservableList<FilterGroup<T>> getFilterGroups() {
        return (ObservableList)this.filterGroups.get();
    }

    public final ListProperty<FilterGroup<T>> filterGroupsProperty() {
        return this.filterGroups;
    }

    public final void setFilterGroups(ObservableList<FilterGroup<T>> filterGroups) {
        this.filterGroups.set(filterGroups);
    }

    public ObservableList<Filter<T>> getFilters() {
        return (ObservableList)this.filters.get();
    }

    public ListProperty<Filter<T>> filtersProperty() {
        return this.filters;
    }

    public void setFilters(ObservableList<Filter<T>> filters) {
        this.filters.set(filters);
    }

    public final Predicate<T> getAdditionalFilterPredicate() {
        return (Predicate)this.additionalFilterPredicate.get();
    }

    public final ObjectProperty<Predicate<T>> additionalFilterPredicateProperty() {
        return this.additionalFilterPredicate;
    }

    public final void setAdditionalFilterPredicate(Predicate<T> additionalFilterPredicate) {
        this.additionalFilterPredicate.set(additionalFilterPredicate);
    }

    public final Predicate<T> getFilterPredicate() {
        return (Predicate)this.filterPredicate.get();
    }

    public final ReadOnlyObjectProperty<Predicate<T>> filterPredicateProperty() {
        return this.filterPredicate.getReadOnlyProperty();
    }

    public static abstract class Filter<T>
    implements Predicate<T> {
        private FilterGroup<T> group;
        private boolean selected;
        private final StringProperty name = new SimpleStringProperty((Object)this, "name", "Untitled");
        private final StringProperty id = new SimpleStringProperty((Object)this, "id");

        public Filter(String name, String id) {
            Objects.requireNonNull(name, "filter name can not be null");
            this.setName(name);
            this.setId(id);
        }

        public Filter(String name) {
            this(name, StringUtils.replaceEach((String)name, (String[])new String[]{"(", ")", "&", "_", " "}, (String[])new String[]{"", "", "and", "-", "-"}).toLowerCase());
        }

        public Filter(String name, boolean selected) {
            this(name);
            this.selected = selected;
        }

        public Filter(String name, String id, boolean selected) {
            this(name, id);
            this.selected = selected;
        }

        public FilterGroup<T> getGroup() {
            return this.group;
        }

        void setGroup(FilterGroup<T> group) {
            this.group = group;
        }

        public final StringProperty nameProperty() {
            return this.name;
        }

        public final String getName() {
            return (String)this.name.get();
        }

        public final void setName(String name) {
            this.name.set((Object)name);
        }

        public final String getId() {
            return (String)this.id.get();
        }

        public final StringProperty idProperty() {
            return this.id;
        }

        public final void setId(String id) {
            this.id.set((Object)id);
        }

        public boolean isSelected() {
            return this.selected;
        }
    }

    public static class FilterGroup<T> {
        private final ListProperty<Filter<T>> filters = new SimpleListProperty(FXCollections.observableArrayList());
        private final StringProperty name = new SimpleStringProperty((Object)this, "name", "Untitled");
        private final StringProperty id = new SimpleStringProperty((Object)this, "id");

        public FilterGroup(String name, String id) {
            this.setName(name);
            this.setId(id);
            this.filters.addListener(change -> {
                while (change.next()) {
                    if (!change.wasAdded()) continue;
                    change.getAddedSubList().forEach(filter -> filter.setGroup(this));
                }
            });
        }

        public FilterGroup(String name) {
            this(name, StringUtils.replaceEach((String)name, (String[])new String[]{"(", ")", "&", "_", " "}, (String[])new String[]{"", "", "and", "-", "-"}).toLowerCase());
        }

        public final ObservableList<Filter<T>> getFilters() {
            return (ObservableList)this.filters.get();
        }

        public final ListProperty<Filter<T>> filtersProperty() {
            return this.filters;
        }

        public final void setFilters(ObservableList<Filter<T>> filters) {
            this.filters.set(filters);
        }

        public final StringProperty nameProperty() {
            return this.name;
        }

        public final String getName() {
            return (String)this.name.get();
        }

        public final void setName(String name) {
            this.name.set((Object)name);
        }

        public final String getId() {
            return (String)this.id.get();
        }

        public final StringProperty idProperty() {
            return this.id;
        }

        public final void setId(String id) {
            this.id.set((Object)id);
        }
    }
}

