/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.support;

public final class ClassLoaderSupport {
    protected ClassLoaderSupport() {
    }

    public static ClassLoaderSupport getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public Class<?> loadClass(String string) throws ClassNotFoundException {
        Class<?> clazz;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = ClassLoaderSupport.class.getClassLoader().loadClass(string);
        }
        return clazz;
    }

    private static final class SingletonHolder {
        private static final ClassLoaderSupport INSTANCE = new ClassLoaderSupport();

        private SingletonHolder() {
        }
    }
}

