/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.tableview2;

import impl.org.controlsfx.tableview2.RowHeader;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableView;
import org.controlsfx.control.tableview2.FilteredTableView;
import org.controlsfx.control.tableview2.TableColumn2;

public class FilteredTableColumn<S, T>
extends TableColumn2<S, T> {
    private static final PseudoClass FILTER_ON = PseudoClass.getPseudoClass((String)"filtered");
    private final HashMap<CellIdentity<S>, ChangeListener<T>> trackedCells = new HashMap();
    private final Button filterButton;
    private final ListChangeListener<S> backingListListener = lc -> {
        while (lc.next()) {
            if (lc.wasAdded()) {
                lc.getAddedSubList().forEach(s -> this.addBackingItem(s, this.getCellObservableValue(s)));
            }
            if (!lc.wasRemoved()) continue;
            lc.getRemoved().forEach(s -> this.removeBackingItem(s, this.getCellObservableValue(s)));
        }
    };
    private final WeakListChangeListener<S> weakListChangeListener = new WeakListChangeListener(this.backingListListener);
    private final ChangeListener<T> changeListener = (obs, ov, nv) -> Platform.runLater(() -> this.runOnFilteredTableView(FilteredTableView::filter));
    private final ChangeListener<Predicate<?>> filterListener = (obs, ov, nv) -> this.updateButton(nv != null);
    private final WeakChangeListener<Predicate<?>> weakFilterListener = new WeakChangeListener(this.filterListener);
    private final InvalidationListener tableListener = o -> this.init();
    private final WeakInvalidationListener weakTableListener = new WeakInvalidationListener(this.tableListener);
    private InvalidationListener itemsPropertyListener;
    private WeakInvalidationListener weakItemsPropertyListener;
    private InvalidationListener parentListener;
    private WeakInvalidationListener weakParentListener;
    private final BooleanProperty filterable = new SimpleBooleanProperty((Object)this, "filterable", true);
    private final ObjectProperty<Predicate<? super T>> predicate = new SimpleObjectProperty<Predicate<? super T>>((Object)this, "predicate", null){

        protected void invalidated() {
            FilteredTableColumn.this.getFilteredTableView().ifPresent(FilteredTableView::filter);
        }
    };
    private final ObjectProperty<EventHandler<ActionEvent>> onFilterAction = new SimpleObjectProperty((Object)this, "onFilterAction", null);

    public FilteredTableColumn() {
        this.tableViewProperty().addListener((InvalidationListener)this.weakTableListener);
        this.filterButton = new Button();
        this.filterButton.getStyleClass().add((Object)"filter");
        this.filterButton.onActionProperty().bind(this.onFilterActionProperty());
        this.filterButton.disableProperty().bind((ObservableValue)this.filterableProperty().not());
        this.setGraphic((Node)this.filterButton);
        this.updateButton(this.getPredicate() != null);
        this.predicateProperty().addListener(this.weakFilterListener);
    }

    public FilteredTableColumn(String text) {
        this();
        this.setText(text);
    }

    public final void setFilterable(boolean value) {
        this.filterable.set(value);
    }

    public final boolean isFilterable() {
        return this.filterable.get();
    }

    public final BooleanProperty filterableProperty() {
        return this.filterable;
    }

    public final void setPredicate(Predicate<? super T> value) {
        this.predicate.set(value);
    }

    public final Predicate<? super T> getPredicate() {
        return (Predicate)this.predicate.get();
    }

    public final ObservableValue<Predicate<? super T>> predicateProperty() {
        return this.predicate;
    }

    public final ObjectProperty<EventHandler<ActionEvent>> onFilterActionProperty() {
        return this.onFilterAction;
    }

    public final void setOnFilterAction(EventHandler<ActionEvent> value) {
        this.onFilterAction.set(value);
    }

    public final EventHandler<ActionEvent> getOnFilterAction() {
        return (EventHandler)this.onFilterAction.get();
    }

    private void init() {
        this.runOnFilteredTableView(filteredTableView -> {
            this.itemsPropertyListener = o -> {
                if (filteredTableView.getItems() != null) {
                    ObservableList backingList = filteredTableView.getBackingList();
                    if (backingList != null) {
                        backingList.forEach(s -> this.addBackingItem(s, this.getCellObservableValue(s)));
                        backingList.addListener(this.weakListChangeListener);
                    }
                    filteredTableView.itemsProperty().removeListener((InvalidationListener)this.weakItemsPropertyListener);
                }
            };
            this.weakItemsPropertyListener = new WeakInvalidationListener(this.itemsPropertyListener);
            filteredTableView.itemsProperty().addListener((InvalidationListener)this.weakItemsPropertyListener);
            if (filteredTableView.getParent() != null) {
                this.updateFilterButton((TableView<S>)filteredTableView);
            } else {
                this.parentListener = o -> {
                    if (filteredTableView.getParent() != null) {
                        this.updateFilterButton((TableView<S>)filteredTableView);
                        filteredTableView.parentProperty().removeListener((InvalidationListener)this.weakParentListener);
                    }
                };
                this.weakParentListener = new WeakInvalidationListener(this.parentListener);
                filteredTableView.parentProperty().addListener((InvalidationListener)this.weakParentListener);
            }
        });
    }

    private void updateButton(boolean value) {
        this.filterButton.pseudoClassStateChanged(FILTER_ON, value);
    }

    private void updateFilterButton(TableView<S> tableView) {
        if (tableView.getParent() instanceof RowHeader) {
            FilteredTableView parentTableView = (FilteredTableView)((RowHeader)tableView.getParent()).getParentTableView();
            this.updateButton(parentTableView.getPredicate() != null);
            parentTableView.predicateProperty().addListener(this.weakFilterListener);
        }
    }

    private void addBackingItem(S item, ObservableValue<T> cellValue) {
        if (cellValue == null) {
            return;
        }
        CellIdentity<S> trackedCellValue = new CellIdentity<S>(item);
        WeakChangeListener cellListener = new WeakChangeListener(this.changeListener);
        cellValue.addListener((ChangeListener)cellListener);
        this.trackedCells.put(trackedCellValue, (ChangeListener<T>)cellListener);
    }

    private void removeBackingItem(S item, ObservableValue<T> cellValue) {
        if (cellValue == null) {
            return;
        }
        ChangeListener<T> listener = this.trackedCells.remove(new CellIdentity<S>(item));
        cellValue.removeListener(listener);
    }

    private void runOnFilteredTableView(Consumer<FilteredTableView> consumer) {
        this.getFilteredTableView().ifPresent(consumer);
    }

    private Optional<FilteredTableView<S>> getFilteredTableView() {
        TableView tableView = this.getTableView();
        if (tableView != null && tableView instanceof FilteredTableView) {
            return Optional.of((FilteredTableView)tableView);
        }
        return Optional.empty();
    }

    private static final class CellIdentity<S> {
        private final S item;

        CellIdentity(S item) {
            this.item = item;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CellIdentity other = (CellIdentity)obj;
            return Objects.equals(this.item, other.item);
        }

        public int hashCode() {
            return System.identityHashCode(this.item);
        }
    }
}

